/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.api.status;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.kubernetes.operator.api.status.SavepointFormatType;
import org.apache.flink.kubernetes.operator.api.status.SavepointTriggerType;

@Experimental
public class Savepoint {
    private long timeStamp;
    private String location;
    private SavepointTriggerType triggerType = SavepointTriggerType.UNKNOWN;
    private SavepointFormatType formatType = SavepointFormatType.UNKNOWN;
    private Long triggerNonce;

    public Savepoint(long timeStamp, String location, @Nullable SavepointTriggerType triggerType, @Nullable SavepointFormatType formatType, @Nullable Long triggerNonce) {
        this.timeStamp = timeStamp;
        this.location = location;
        if (triggerType != null) {
            this.triggerType = triggerType;
        }
        if (formatType != null) {
            this.formatType = formatType;
        }
        this.triggerNonce = triggerNonce;
    }

    public static Savepoint of(String location, long timeStamp, SavepointTriggerType triggerType) {
        return new Savepoint(timeStamp, location, triggerType, SavepointFormatType.UNKNOWN, null);
    }

    public static Savepoint of(String location, SavepointTriggerType triggerType) {
        return new Savepoint(System.currentTimeMillis(), location, triggerType, SavepointFormatType.UNKNOWN, null);
    }

    public static Savepoint of(String location, SavepointTriggerType triggerType, SavepointFormatType formatType) {
        return new Savepoint(System.currentTimeMillis(), location, triggerType, formatType, null);
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String getLocation() {
        return this.location;
    }

    public SavepointTriggerType getTriggerType() {
        return this.triggerType;
    }

    public SavepointFormatType getFormatType() {
        return this.formatType;
    }

    public Long getTriggerNonce() {
        return this.triggerNonce;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setTriggerType(SavepointTriggerType triggerType) {
        this.triggerType = triggerType;
    }

    public void setFormatType(SavepointFormatType formatType) {
        this.formatType = formatType;
    }

    public void setTriggerNonce(Long triggerNonce) {
        this.triggerNonce = triggerNonce;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Savepoint)) {
            return false;
        }
        Savepoint other = (Savepoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimeStamp() != other.getTimeStamp()) {
            return false;
        }
        Long this$triggerNonce = this.getTriggerNonce();
        Long other$triggerNonce = other.getTriggerNonce();
        if (this$triggerNonce == null ? other$triggerNonce != null : !((Object)this$triggerNonce).equals(other$triggerNonce)) {
            return false;
        }
        String this$location = this.getLocation();
        String other$location = other.getLocation();
        if (this$location == null ? other$location != null : !this$location.equals(other$location)) {
            return false;
        }
        SavepointTriggerType this$triggerType = this.getTriggerType();
        SavepointTriggerType other$triggerType = other.getTriggerType();
        if (this$triggerType == null ? other$triggerType != null : !((Object)((Object)this$triggerType)).equals((Object)other$triggerType)) {
            return false;
        }
        SavepointFormatType this$formatType = this.getFormatType();
        SavepointFormatType other$formatType = other.getFormatType();
        return !(this$formatType == null ? other$formatType != null : !((Object)((Object)this$formatType)).equals((Object)other$formatType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Savepoint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timeStamp = this.getTimeStamp();
        result = result * 59 + (int)($timeStamp >>> 32 ^ $timeStamp);
        Long $triggerNonce = this.getTriggerNonce();
        result = result * 59 + ($triggerNonce == null ? 43 : ((Object)$triggerNonce).hashCode());
        String $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        SavepointTriggerType $triggerType = this.getTriggerType();
        result = result * 59 + ($triggerType == null ? 43 : ((Object)((Object)$triggerType)).hashCode());
        SavepointFormatType $formatType = this.getFormatType();
        result = result * 59 + ($formatType == null ? 43 : ((Object)((Object)$formatType)).hashCode());
        return result;
    }

    public String toString() {
        return "Savepoint(timeStamp=" + this.getTimeStamp() + ", location=" + this.getLocation() + ", triggerType=" + this.getTriggerType() + ", formatType=" + this.getFormatType() + ", triggerNonce=" + this.getTriggerNonce() + ")";
    }

    public Savepoint() {
    }
}

