/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.api.status;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.kubernetes.operator.api.spec.FlinkDeploymentSpec;
import org.apache.flink.kubernetes.operator.api.status.CommonStatus;
import org.apache.flink.kubernetes.operator.api.status.FlinkDeploymentReconciliationStatus;
import org.apache.flink.kubernetes.operator.api.status.JobManagerDeploymentStatus;
import org.apache.flink.kubernetes.operator.api.status.TaskManagerInfo;

@JsonIgnoreProperties(ignoreUnknown=true)
@Experimental
public class FlinkDeploymentStatus
extends CommonStatus<FlinkDeploymentSpec> {
    private Map<String, String> clusterInfo = new HashMap<String, String>();
    private JobManagerDeploymentStatus jobManagerDeploymentStatus = JobManagerDeploymentStatus.MISSING;
    private FlinkDeploymentReconciliationStatus reconciliationStatus = new FlinkDeploymentReconciliationStatus();
    private TaskManagerInfo taskManager;

    protected FlinkDeploymentStatus(FlinkDeploymentStatusBuilder<?, ?> b) {
        super(b);
        this.clusterInfo = b.clusterInfo;
        this.jobManagerDeploymentStatus = b.jobManagerDeploymentStatus;
        this.reconciliationStatus = b.reconciliationStatus;
        this.taskManager = b.taskManager;
    }

    public static FlinkDeploymentStatusBuilder<?, ?> builder() {
        return new FlinkDeploymentStatusBuilderImpl();
    }

    public Map<String, String> getClusterInfo() {
        return this.clusterInfo;
    }

    public JobManagerDeploymentStatus getJobManagerDeploymentStatus() {
        return this.jobManagerDeploymentStatus;
    }

    public FlinkDeploymentReconciliationStatus getReconciliationStatus() {
        return this.reconciliationStatus;
    }

    public TaskManagerInfo getTaskManager() {
        return this.taskManager;
    }

    public void setClusterInfo(Map<String, String> clusterInfo) {
        this.clusterInfo = clusterInfo;
    }

    public void setJobManagerDeploymentStatus(JobManagerDeploymentStatus jobManagerDeploymentStatus) {
        this.jobManagerDeploymentStatus = jobManagerDeploymentStatus;
    }

    public void setReconciliationStatus(FlinkDeploymentReconciliationStatus reconciliationStatus) {
        this.reconciliationStatus = reconciliationStatus;
    }

    public void setTaskManager(TaskManagerInfo taskManager) {
        this.taskManager = taskManager;
    }

    public FlinkDeploymentStatus(Map<String, String> clusterInfo, JobManagerDeploymentStatus jobManagerDeploymentStatus, FlinkDeploymentReconciliationStatus reconciliationStatus, TaskManagerInfo taskManager) {
        this.clusterInfo = clusterInfo;
        this.jobManagerDeploymentStatus = jobManagerDeploymentStatus;
        this.reconciliationStatus = reconciliationStatus;
        this.taskManager = taskManager;
    }

    public FlinkDeploymentStatus() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlinkDeploymentStatus)) {
            return false;
        }
        FlinkDeploymentStatus other = (FlinkDeploymentStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, String> this$clusterInfo = this.getClusterInfo();
        Map<String, String> other$clusterInfo = other.getClusterInfo();
        if (this$clusterInfo == null ? other$clusterInfo != null : !((Object)this$clusterInfo).equals(other$clusterInfo)) {
            return false;
        }
        JobManagerDeploymentStatus this$jobManagerDeploymentStatus = this.getJobManagerDeploymentStatus();
        JobManagerDeploymentStatus other$jobManagerDeploymentStatus = other.getJobManagerDeploymentStatus();
        if (this$jobManagerDeploymentStatus == null ? other$jobManagerDeploymentStatus != null : !((Object)((Object)this$jobManagerDeploymentStatus)).equals((Object)other$jobManagerDeploymentStatus)) {
            return false;
        }
        FlinkDeploymentReconciliationStatus this$reconciliationStatus = this.getReconciliationStatus();
        FlinkDeploymentReconciliationStatus other$reconciliationStatus = other.getReconciliationStatus();
        if (this$reconciliationStatus == null ? other$reconciliationStatus != null : !((Object)this$reconciliationStatus).equals(other$reconciliationStatus)) {
            return false;
        }
        TaskManagerInfo this$taskManager = this.getTaskManager();
        TaskManagerInfo other$taskManager = other.getTaskManager();
        return !(this$taskManager == null ? other$taskManager != null : !((Object)this$taskManager).equals(other$taskManager));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FlinkDeploymentStatus;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, String> $clusterInfo = this.getClusterInfo();
        result = result * 59 + ($clusterInfo == null ? 43 : ((Object)$clusterInfo).hashCode());
        JobManagerDeploymentStatus $jobManagerDeploymentStatus = this.getJobManagerDeploymentStatus();
        result = result * 59 + ($jobManagerDeploymentStatus == null ? 43 : ((Object)((Object)$jobManagerDeploymentStatus)).hashCode());
        FlinkDeploymentReconciliationStatus $reconciliationStatus = this.getReconciliationStatus();
        result = result * 59 + ($reconciliationStatus == null ? 43 : ((Object)$reconciliationStatus).hashCode());
        TaskManagerInfo $taskManager = this.getTaskManager();
        result = result * 59 + ($taskManager == null ? 43 : ((Object)$taskManager).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "FlinkDeploymentStatus(super=" + super.toString() + ", clusterInfo=" + this.getClusterInfo() + ", jobManagerDeploymentStatus=" + this.getJobManagerDeploymentStatus() + ", reconciliationStatus=" + this.getReconciliationStatus() + ", taskManager=" + this.getTaskManager() + ")";
    }

    private static final class FlinkDeploymentStatusBuilderImpl
    extends FlinkDeploymentStatusBuilder<FlinkDeploymentStatus, FlinkDeploymentStatusBuilderImpl> {
        private FlinkDeploymentStatusBuilderImpl() {
        }

        @Override
        protected FlinkDeploymentStatusBuilderImpl self() {
            return this;
        }

        @Override
        public FlinkDeploymentStatus build() {
            return new FlinkDeploymentStatus(this);
        }
    }

    public static abstract class FlinkDeploymentStatusBuilder<C extends FlinkDeploymentStatus, B extends FlinkDeploymentStatusBuilder<C, B>>
    extends CommonStatus.CommonStatusBuilder<FlinkDeploymentSpec, C, B> {
        private Map<String, String> clusterInfo;
        private JobManagerDeploymentStatus jobManagerDeploymentStatus;
        private FlinkDeploymentReconciliationStatus reconciliationStatus;
        private TaskManagerInfo taskManager;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B clusterInfo(Map<String, String> clusterInfo) {
            this.clusterInfo = clusterInfo;
            return (B)this.self();
        }

        public B jobManagerDeploymentStatus(JobManagerDeploymentStatus jobManagerDeploymentStatus) {
            this.jobManagerDeploymentStatus = jobManagerDeploymentStatus;
            return (B)this.self();
        }

        public B reconciliationStatus(FlinkDeploymentReconciliationStatus reconciliationStatus) {
            this.reconciliationStatus = reconciliationStatus;
            return (B)this.self();
        }

        public B taskManager(TaskManagerInfo taskManager) {
            this.taskManager = taskManager;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "FlinkDeploymentStatus.FlinkDeploymentStatusBuilder(super=" + super.toString() + ", clusterInfo=" + this.clusterInfo + ", jobManagerDeploymentStatus=" + this.jobManagerDeploymentStatus + ", reconciliationStatus=" + this.reconciliationStatus + ", taskManager=" + this.taskManager + ")";
        }
    }
}

