/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.api.status;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.model.annotation.PrinterColumn;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.Internal;
import org.apache.flink.kubernetes.operator.api.lifecycle.ResourceLifecycleState;
import org.apache.flink.kubernetes.operator.api.spec.AbstractFlinkSpec;
import org.apache.flink.kubernetes.operator.api.spec.JobState;
import org.apache.flink.kubernetes.operator.api.status.JobStatus;
import org.apache.flink.kubernetes.operator.api.status.ReconciliationState;
import org.apache.flink.kubernetes.operator.api.status.ReconciliationStatus;

@Experimental
public abstract class CommonStatus<SPEC extends AbstractFlinkSpec> {
    private JobStatus jobStatus = new JobStatus();
    private String error;
    @PrinterColumn(name="Lifecycle State")
    private ResourceLifecycleState lifecycleState;
    @JsonIgnore
    @Internal
    private boolean immediateReconciliationNeeded = false;

    public abstract ReconciliationStatus<SPEC> getReconciliationStatus();

    public ResourceLifecycleState getLifecycleState() {
        ReconciliationStatus<SPEC> reconciliationStatus = this.getReconciliationStatus();
        if (reconciliationStatus.isBeforeFirstDeployment()) {
            return StringUtils.isEmpty((CharSequence)this.error) ? ResourceLifecycleState.CREATED : ResourceLifecycleState.FAILED;
        }
        switch (reconciliationStatus.getState()) {
            case UPGRADING: {
                return ResourceLifecycleState.UPGRADING;
            }
            case ROLLING_BACK: {
                return ResourceLifecycleState.ROLLING_BACK;
            }
        }
        SPEC lastReconciledSpec = reconciliationStatus.deserializeLastReconciledSpec();
        if (((AbstractFlinkSpec)lastReconciledSpec).getJob() != null && ((AbstractFlinkSpec)lastReconciledSpec).getJob().getState() == JobState.SUSPENDED) {
            return ResourceLifecycleState.SUSPENDED;
        }
        String jobState = this.getJobStatus().getState();
        if (jobState != null && org.apache.flink.api.common.JobStatus.valueOf((String)jobState).equals((Object)org.apache.flink.api.common.JobStatus.FAILED)) {
            return ResourceLifecycleState.FAILED;
        }
        if (reconciliationStatus.getState() == ReconciliationState.ROLLED_BACK) {
            return ResourceLifecycleState.ROLLED_BACK;
        }
        if (reconciliationStatus.isLastReconciledSpecStable()) {
            return ResourceLifecycleState.STABLE;
        }
        return ResourceLifecycleState.DEPLOYED;
    }

    protected CommonStatus(CommonStatusBuilder<SPEC, ?, ?> b) {
        this.jobStatus = b.jobStatus;
        this.error = b.error;
        this.lifecycleState = b.lifecycleState;
        this.immediateReconciliationNeeded = b.immediateReconciliationNeeded;
    }

    public JobStatus getJobStatus() {
        return this.jobStatus;
    }

    public String getError() {
        return this.error;
    }

    public boolean isImmediateReconciliationNeeded() {
        return this.immediateReconciliationNeeded;
    }

    public void setJobStatus(JobStatus jobStatus) {
        this.jobStatus = jobStatus;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void setLifecycleState(ResourceLifecycleState lifecycleState) {
        this.lifecycleState = lifecycleState;
    }

    @JsonIgnore
    public void setImmediateReconciliationNeeded(boolean immediateReconciliationNeeded) {
        this.immediateReconciliationNeeded = immediateReconciliationNeeded;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonStatus)) {
            return false;
        }
        CommonStatus other = (CommonStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isImmediateReconciliationNeeded() != other.isImmediateReconciliationNeeded()) {
            return false;
        }
        JobStatus this$jobStatus = this.getJobStatus();
        JobStatus other$jobStatus = other.getJobStatus();
        if (this$jobStatus == null ? other$jobStatus != null : !((Object)this$jobStatus).equals(other$jobStatus)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        ResourceLifecycleState this$lifecycleState = this.getLifecycleState();
        ResourceLifecycleState other$lifecycleState = other.getLifecycleState();
        return !(this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommonStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isImmediateReconciliationNeeded() ? 79 : 97);
        JobStatus $jobStatus = this.getJobStatus();
        result = result * 59 + ($jobStatus == null ? 43 : ((Object)$jobStatus).hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        ResourceLifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        return result;
    }

    public String toString() {
        return "CommonStatus(jobStatus=" + this.getJobStatus() + ", error=" + this.getError() + ", lifecycleState=" + this.getLifecycleState() + ", immediateReconciliationNeeded=" + this.isImmediateReconciliationNeeded() + ")";
    }

    public CommonStatus(JobStatus jobStatus, String error, ResourceLifecycleState lifecycleState, boolean immediateReconciliationNeeded) {
        this.jobStatus = jobStatus;
        this.error = error;
        this.lifecycleState = lifecycleState;
        this.immediateReconciliationNeeded = immediateReconciliationNeeded;
    }

    public CommonStatus() {
    }

    public static abstract class CommonStatusBuilder<SPEC extends AbstractFlinkSpec, C extends CommonStatus<SPEC>, B extends CommonStatusBuilder<SPEC, C, B>> {
        private JobStatus jobStatus;
        private String error;
        private ResourceLifecycleState lifecycleState;
        private boolean immediateReconciliationNeeded;

        protected abstract B self();

        public abstract C build();

        public B jobStatus(JobStatus jobStatus) {
            this.jobStatus = jobStatus;
            return this.self();
        }

        public B error(String error) {
            this.error = error;
            return this.self();
        }

        public B lifecycleState(ResourceLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this.self();
        }

        @JsonIgnore
        public B immediateReconciliationNeeded(boolean immediateReconciliationNeeded) {
            this.immediateReconciliationNeeded = immediateReconciliationNeeded;
            return this.self();
        }

        public String toString() {
            return "CommonStatus.CommonStatusBuilder(jobStatus=" + this.jobStatus + ", error=" + this.error + ", lifecycleState=" + this.lifecycleState + ", immediateReconciliationNeeded=" + this.immediateReconciliationNeeded + ")";
        }
    }
}

