/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.api.spec;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Arrays;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.kubernetes.operator.api.diff.DiffType;
import org.apache.flink.kubernetes.operator.api.diff.Diffable;
import org.apache.flink.kubernetes.operator.api.diff.SpecDiff;
import org.apache.flink.kubernetes.operator.api.spec.JobState;
import org.apache.flink.kubernetes.operator.api.spec.KubernetesDeploymentMode;
import org.apache.flink.kubernetes.operator.api.spec.UpgradeMode;

@JsonIgnoreProperties(ignoreUnknown=true)
@Experimental
public class JobSpec
implements Diffable<JobSpec> {
    private String jarURI;
    @SpecDiff(value=DiffType.SCALE, mode={KubernetesDeploymentMode.STANDALONE})
    private int parallelism;
    private String entryClass;
    private String[] args = new String[0];
    private JobState state = JobState.RUNNING;
    @SpecDiff(value=DiffType.IGNORE)
    private Long savepointTriggerNonce;
    @SpecDiff(value=DiffType.IGNORE)
    private String initialSavepointPath;
    @SpecDiff(value=DiffType.IGNORE)
    private UpgradeMode upgradeMode = UpgradeMode.STATELESS;
    @SpecDiff(value=DiffType.IGNORE)
    private Boolean allowNonRestoredState;

    public static JobSpecBuilder builder() {
        return new JobSpecBuilder();
    }

    public String getJarURI() {
        return this.jarURI;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public String getEntryClass() {
        return this.entryClass;
    }

    public String[] getArgs() {
        return this.args;
    }

    public JobState getState() {
        return this.state;
    }

    public Long getSavepointTriggerNonce() {
        return this.savepointTriggerNonce;
    }

    public String getInitialSavepointPath() {
        return this.initialSavepointPath;
    }

    public UpgradeMode getUpgradeMode() {
        return this.upgradeMode;
    }

    public Boolean getAllowNonRestoredState() {
        return this.allowNonRestoredState;
    }

    public void setJarURI(String jarURI) {
        this.jarURI = jarURI;
    }

    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    public void setEntryClass(String entryClass) {
        this.entryClass = entryClass;
    }

    public void setArgs(String[] args) {
        this.args = args;
    }

    public void setState(JobState state) {
        this.state = state;
    }

    public void setSavepointTriggerNonce(Long savepointTriggerNonce) {
        this.savepointTriggerNonce = savepointTriggerNonce;
    }

    public void setInitialSavepointPath(String initialSavepointPath) {
        this.initialSavepointPath = initialSavepointPath;
    }

    public void setUpgradeMode(UpgradeMode upgradeMode) {
        this.upgradeMode = upgradeMode;
    }

    public void setAllowNonRestoredState(Boolean allowNonRestoredState) {
        this.allowNonRestoredState = allowNonRestoredState;
    }

    public String toString() {
        return "JobSpec(jarURI=" + this.getJarURI() + ", parallelism=" + this.getParallelism() + ", entryClass=" + this.getEntryClass() + ", args=" + Arrays.deepToString(this.getArgs()) + ", state=" + this.getState() + ", savepointTriggerNonce=" + this.getSavepointTriggerNonce() + ", initialSavepointPath=" + this.getInitialSavepointPath() + ", upgradeMode=" + this.getUpgradeMode() + ", allowNonRestoredState=" + this.getAllowNonRestoredState() + ")";
    }

    public JobSpec() {
    }

    public JobSpec(String jarURI, int parallelism, String entryClass, String[] args, JobState state, Long savepointTriggerNonce, String initialSavepointPath, UpgradeMode upgradeMode, Boolean allowNonRestoredState) {
        this.jarURI = jarURI;
        this.parallelism = parallelism;
        this.entryClass = entryClass;
        this.args = args;
        this.state = state;
        this.savepointTriggerNonce = savepointTriggerNonce;
        this.initialSavepointPath = initialSavepointPath;
        this.upgradeMode = upgradeMode;
        this.allowNonRestoredState = allowNonRestoredState;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobSpec)) {
            return false;
        }
        JobSpec other = (JobSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getParallelism() != other.getParallelism()) {
            return false;
        }
        Long this$savepointTriggerNonce = this.getSavepointTriggerNonce();
        Long other$savepointTriggerNonce = other.getSavepointTriggerNonce();
        if (this$savepointTriggerNonce == null ? other$savepointTriggerNonce != null : !((Object)this$savepointTriggerNonce).equals(other$savepointTriggerNonce)) {
            return false;
        }
        Boolean this$allowNonRestoredState = this.getAllowNonRestoredState();
        Boolean other$allowNonRestoredState = other.getAllowNonRestoredState();
        if (this$allowNonRestoredState == null ? other$allowNonRestoredState != null : !((Object)this$allowNonRestoredState).equals(other$allowNonRestoredState)) {
            return false;
        }
        String this$jarURI = this.getJarURI();
        String other$jarURI = other.getJarURI();
        if (this$jarURI == null ? other$jarURI != null : !this$jarURI.equals(other$jarURI)) {
            return false;
        }
        String this$entryClass = this.getEntryClass();
        String other$entryClass = other.getEntryClass();
        if (this$entryClass == null ? other$entryClass != null : !this$entryClass.equals(other$entryClass)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getArgs(), other.getArgs())) {
            return false;
        }
        JobState this$state = this.getState();
        JobState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        String this$initialSavepointPath = this.getInitialSavepointPath();
        String other$initialSavepointPath = other.getInitialSavepointPath();
        if (this$initialSavepointPath == null ? other$initialSavepointPath != null : !this$initialSavepointPath.equals(other$initialSavepointPath)) {
            return false;
        }
        UpgradeMode this$upgradeMode = this.getUpgradeMode();
        UpgradeMode other$upgradeMode = other.getUpgradeMode();
        return !(this$upgradeMode == null ? other$upgradeMode != null : !((Object)((Object)this$upgradeMode)).equals((Object)other$upgradeMode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getParallelism();
        Long $savepointTriggerNonce = this.getSavepointTriggerNonce();
        result = result * 59 + ($savepointTriggerNonce == null ? 43 : ((Object)$savepointTriggerNonce).hashCode());
        Boolean $allowNonRestoredState = this.getAllowNonRestoredState();
        result = result * 59 + ($allowNonRestoredState == null ? 43 : ((Object)$allowNonRestoredState).hashCode());
        String $jarURI = this.getJarURI();
        result = result * 59 + ($jarURI == null ? 43 : $jarURI.hashCode());
        String $entryClass = this.getEntryClass();
        result = result * 59 + ($entryClass == null ? 43 : $entryClass.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getArgs());
        JobState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        String $initialSavepointPath = this.getInitialSavepointPath();
        result = result * 59 + ($initialSavepointPath == null ? 43 : $initialSavepointPath.hashCode());
        UpgradeMode $upgradeMode = this.getUpgradeMode();
        result = result * 59 + ($upgradeMode == null ? 43 : ((Object)((Object)$upgradeMode)).hashCode());
        return result;
    }

    public static class JobSpecBuilder {
        private String jarURI;
        private int parallelism;
        private String entryClass;
        private String[] args;
        private JobState state;
        private Long savepointTriggerNonce;
        private String initialSavepointPath;
        private UpgradeMode upgradeMode;
        private Boolean allowNonRestoredState;

        JobSpecBuilder() {
        }

        public JobSpecBuilder jarURI(String jarURI) {
            this.jarURI = jarURI;
            return this;
        }

        public JobSpecBuilder parallelism(int parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        public JobSpecBuilder entryClass(String entryClass) {
            this.entryClass = entryClass;
            return this;
        }

        public JobSpecBuilder args(String[] args) {
            this.args = args;
            return this;
        }

        public JobSpecBuilder state(JobState state) {
            this.state = state;
            return this;
        }

        public JobSpecBuilder savepointTriggerNonce(Long savepointTriggerNonce) {
            this.savepointTriggerNonce = savepointTriggerNonce;
            return this;
        }

        public JobSpecBuilder initialSavepointPath(String initialSavepointPath) {
            this.initialSavepointPath = initialSavepointPath;
            return this;
        }

        public JobSpecBuilder upgradeMode(UpgradeMode upgradeMode) {
            this.upgradeMode = upgradeMode;
            return this;
        }

        public JobSpecBuilder allowNonRestoredState(Boolean allowNonRestoredState) {
            this.allowNonRestoredState = allowNonRestoredState;
            return this;
        }

        public JobSpec build() {
            return new JobSpec(this.jarURI, this.parallelism, this.entryClass, this.args, this.state, this.savepointTriggerNonce, this.initialSavepointPath, this.upgradeMode, this.allowNonRestoredState);
        }

        public String toString() {
            return "JobSpec.JobSpecBuilder(jarURI=" + this.jarURI + ", parallelism=" + this.parallelism + ", entryClass=" + this.entryClass + ", args=" + Arrays.deepToString(this.args) + ", state=" + this.state + ", savepointTriggerNonce=" + this.savepointTriggerNonce + ", initialSavepointPath=" + this.initialSavepointPath + ", upgradeMode=" + this.upgradeMode + ", allowNonRestoredState=" + this.allowNonRestoredState + ")";
        }
    }
}

