/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.api.reconciler;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.api.status.CommonStatus;
import org.apache.flink.kubernetes.operator.api.status.ReconciliationState;
import org.apache.flink.kubernetes.operator.api.status.ReconciliationStatus;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ReconciliationMetadata {
    private String apiVersion;
    private ObjectMeta metadata;
    private boolean firstDeployment;

    public static ReconciliationMetadata from(AbstractFlinkResource<?, ?> resource) {
        ObjectMeta metadata = new ObjectMeta();
        metadata.setGeneration(resource.getMetadata().getGeneration());
        boolean firstDeploy = ((CommonStatus)resource.getStatus()).getReconciliationStatus().isBeforeFirstDeployment() || ReconciliationMetadata.isFirstDeployment(resource);
        return new ReconciliationMetadata(resource.getApiVersion(), metadata, firstDeploy);
    }

    private static boolean isFirstDeployment(AbstractFlinkResource<?, ?> resource) {
        ReconciliationStatus reconStatus = ((CommonStatus)resource.getStatus()).getReconciliationStatus();
        return reconStatus.getState() == ReconciliationState.DEPLOYED && reconStatus.deserializeLastReconciledSpecWithMeta().getMeta().firstDeployment;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    public boolean isFirstDeployment() {
        return this.firstDeployment;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public void setFirstDeployment(boolean firstDeployment) {
        this.firstDeployment = firstDeployment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReconciliationMetadata)) {
            return false;
        }
        ReconciliationMetadata other = (ReconciliationMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFirstDeployment() != other.isFirstDeployment()) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        ObjectMeta this$metadata = this.getMetadata();
        ObjectMeta other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReconciliationMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFirstDeployment() ? 79 : 97);
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        ObjectMeta $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        return result;
    }

    public String toString() {
        return "ReconciliationMetadata(apiVersion=" + this.getApiVersion() + ", metadata=" + this.getMetadata() + ", firstDeployment=" + this.isFirstDeployment() + ")";
    }

    public ReconciliationMetadata() {
    }

    public ReconciliationMetadata(String apiVersion, ObjectMeta metadata, boolean firstDeployment) {
        this.apiVersion = apiVersion;
        this.metadata = metadata;
        this.firstDeployment = firstDeployment;
    }
}

