/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.api.listener;

import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.time.Instant;
import org.apache.flink.core.plugin.Plugin;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.FlinkSessionJob;
import org.apache.flink.kubernetes.operator.api.status.CommonStatus;
import org.apache.flink.kubernetes.operator.api.status.FlinkDeploymentStatus;
import org.apache.flink.kubernetes.operator.api.status.FlinkSessionJobStatus;

public interface FlinkResourceListener
extends Plugin {
    public void onDeploymentStatusUpdate(StatusUpdateContext<FlinkDeployment, FlinkDeploymentStatus> var1);

    public void onDeploymentEvent(ResourceEventContext<FlinkDeployment> var1);

    public void onSessionJobStatusUpdate(StatusUpdateContext<FlinkSessionJob, FlinkSessionJobStatus> var1);

    public void onSessionJobEvent(ResourceEventContext<FlinkSessionJob> var1);

    public static interface StatusUpdateContext<R extends AbstractFlinkResource<?, S>, S extends CommonStatus<?>>
    extends ResourceContext<R> {
        default public S getNewStatus() {
            return (S)((CommonStatus)this.getFlinkResource().getStatus());
        }

        public S getPreviousStatus();
    }

    public static interface ResourceEventContext<R extends AbstractFlinkResource<?, ?>>
    extends ResourceContext<R> {
        public Event getEvent();

        @Override
        default public Instant getTimestamp() {
            return Instant.parse(this.getEvent().getLastTimestamp());
        }
    }

    public static interface ResourceContext<R extends AbstractFlinkResource<?, ?>> {
        public R getFlinkResource();

        public KubernetesClient getKubernetesClient();

        public Instant getTimestamp();
    }
}

