/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.api.lifecycle;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public enum ResourceLifecycleState {
    CREATED(false, "The resource was created in Kubernetes but not yet handled by the operator"),
    SUSPENDED(true, "The resource (job) has been suspended"),
    UPGRADING(false, "The resource is being upgraded"),
    DEPLOYED(false, "The resource is deployed/submitted to Kubernetes, but it\u2019s not yet considered to be stable and might be rolled back in the future"),
    STABLE(true, "The resource deployment is considered to be stable and won\u2019t be rolled back"),
    ROLLING_BACK(false, "The resource is being rolled back to the last stable spec"),
    ROLLED_BACK(true, "The resource is deployed with the last stable spec"),
    FAILED(true, "The job terminally failed");

    @JsonIgnore
    private final boolean terminal;
    @JsonIgnore
    private final String description;

    private ResourceLifecycleState(boolean terminal, String description) {
        this.terminal = terminal;
        this.description = description;
    }

    public Set<ResourceLifecycleState> getClearedStatesAfterTransition(ResourceLifecycleState transitionFrom) {
        if (this == transitionFrom) {
            return Collections.emptySet();
        }
        EnumSet<ResourceLifecycleState> states = EnumSet.allOf(ResourceLifecycleState.class);
        if (this.terminal) {
            states.remove((Object)this);
            return states;
        }
        if (this == UPGRADING) {
            states.remove((Object)UPGRADING);
            states.remove((Object)transitionFrom);
            return states;
        }
        return Collections.emptySet();
    }

    public String getDescription() {
        return this.description;
    }
}

