/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.api.docs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.util.DocTrees;
import java.io.File;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner9;
import javax.lang.model.util.Types;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;
import org.apache.commons.io.FileUtils;

public class CrdReferenceDoclet
implements Doclet {
    private static final String SPEC_PACKAGE_PREFIX = "org.apache.flink.kubernetes.operator.api.spec";
    private static final String STATUS_PACKAGE_PREFIX = "org.apache.flink.kubernetes.operator.api.status";
    private DocTrees treeUtils;
    private String templateFile;
    private String outputFile;
    private Map<Element, Element> child2ParentElements;

    private String getNameOrJsonPropValue(Element e) {
        return e.getAnnotationMirrors().stream().filter(am -> am.getAnnotationType().toString().equals(JsonProperty.class.getName())).flatMap(am -> am.getElementValues().entrySet().stream()).filter(entry -> ((ExecutableElement)entry.getKey()).getSimpleName().toString().equals("value")).map(entry -> {
            AnnotationValue value = (AnnotationValue)entry.getValue();
            if (value.getValue() instanceof String) {
                return (String)value.getValue();
            }
            return e.getSimpleName().toString();
        }).findFirst().orElse(e.getSimpleName().toString());
    }

    @Override
    public void init(Locale locale, Reporter reporter) {
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    public Set<? extends Option> getSupportedOptions() {
        return Set.of(new Option("--templateFile", true, "Template File", "filename"){

            @Override
            public boolean process(String option, List<String> arguments) {
                CrdReferenceDoclet.this.templateFile = arguments.get(0);
                return true;
            }
        }, new Option("--outputFile", true, "Output File", "filename"){

            @Override
            public boolean process(String option, List<String> arguments) {
                CrdReferenceDoclet.this.outputFile = arguments.get(0);
                return true;
            }
        });
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean run(DocletEnvironment environment) {
        this.treeUtils = environment.getDocTrees();
        PrintStream printStream = new PrintStream(this.outputFile);
        try {
            printStream.write(FileUtils.readFileToByteArray((File)new File(this.templateFile)));
            MdPrinter se = new MdPrinter(printStream);
            printStream.println();
            printStream.println("## Spec");
            Set<? extends Element> spec = this.sortedByName(environment.getIncludedElements().stream().filter(e -> e.toString().startsWith(SPEC_PACKAGE_PREFIX)).collect(Collectors.toSet()));
            this.handleAbstractClass(spec, environment.getTypeUtils());
            se.show(spec);
            printStream.println();
            printStream.println("## Status");
            Set<? extends Element> status = this.sortedByName(environment.getIncludedElements().stream().filter(e -> e.toString().startsWith(STATUS_PACKAGE_PREFIX)).collect(Collectors.toSet()));
            this.handleAbstractClass(status, environment.getTypeUtils());
            se.show(status);
            boolean bl = true;
            printStream.close();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                try {
                    printStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    private void handleAbstractClass(Set<? extends Element> elements, Types typeUtils) {
        this.child2ParentElements = new HashMap<Element, Element>();
        List classElements = elements.stream().filter(element -> element.getKind() == ElementKind.CLASS).collect(Collectors.toList());
        for (Element element2 : classElements) {
            Element parentElement;
            String name;
            if (element2.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                List<? extends Element> enclosedElements = element2.getEnclosedElements();
                enclosedElements.forEach(elements::remove);
                elements.remove(element2);
                continue;
            }
            List<? extends TypeMirror> directSuperTypes = typeUtils.directSupertypes(element2.asType());
            if (directSuperTypes.size() != 1 || !(name = (parentElement = typeUtils.asElement(directSuperTypes.get(0))).toString()).startsWith(SPEC_PACKAGE_PREFIX) && !name.startsWith(STATUS_PACKAGE_PREFIX)) continue;
            this.child2ParentElements.put(element2, parentElement);
        }
    }

    private String cleanDoc(String doc) {
        return doc.replaceAll("[\\t]+", " ").replaceAll("[\\n\\r]+", "");
    }

    private Set<? extends Element> sortedByName(Set<? extends Element> elements) {
        TreeSet<? extends Element> out = new TreeSet<Element>((e1, e2) -> CharSequence.compare(e1.toString(), e2.toString()));
        out.addAll(elements);
        return out;
    }

    private abstract class Option
    implements Doclet.Option {
        private final String name;
        private final boolean hasArg;
        private final String description;
        private final String parameters;

        Option(String name, boolean hasArg, String description, String parameters) {
            this.name = name;
            this.hasArg = hasArg;
            this.description = description;
            this.parameters = parameters;
        }

        @Override
        public int getArgumentCount() {
            return this.hasArg ? 1 : 0;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public Doclet.Option.Kind getKind() {
            return Doclet.Option.Kind.STANDARD;
        }

        @Override
        public List<String> getNames() {
            return List.of(this.name);
        }

        @Override
        public String getParameters() {
            return this.hasArg ? this.parameters : "";
        }
    }

    private class MdPrinter
    extends ElementScanner9<Void, Integer> {
        final PrintStream out;

        MdPrinter(PrintStream out) {
            this.out = out;
        }

        void show(Set<? extends Element> elements) {
            this.scan(elements, Integer.valueOf(0));
        }

        @Override
        public Void scan(Element e, Integer depth) {
            DocCommentTree dcTree = CrdReferenceDoclet.this.treeUtils.getDocCommentTree(e);
            ElementKind kind = e.getKind();
            JsonIgnore jsonIgnore = e.getAnnotation(JsonIgnore.class);
            if (jsonIgnore != null && jsonIgnore.value()) {
                return null;
            }
            switch (kind) {
                case CLASS: {
                    this.out.println();
                    this.out.println("### " + e.getSimpleName());
                    this.out.println("**Class**: " + e);
                    this.out.println();
                    this.out.println("**Description**: " + dcTree);
                    this.out.println();
                    this.out.println("| Parameter | Type | Docs |");
                    this.out.println("| ----------| ---- | ---- |");
                    if (!CrdReferenceDoclet.this.child2ParentElements.containsKey(e)) break;
                    MdPrinter mdPrinter = new MdPrinter(this.out);
                    mdPrinter.scan(CrdReferenceDoclet.this.child2ParentElements.get(e).getEnclosedElements(), depth);
                    break;
                }
                case FIELD: {
                    this.out.println("| " + CrdReferenceDoclet.this.getNameOrJsonPropValue(e) + " | " + e.asType().toString() + " | " + (dcTree != null ? CrdReferenceDoclet.this.cleanDoc(dcTree.toString()) : "") + " |");
                    return null;
                }
                case ENUM: {
                    this.out.println();
                    this.out.println("### " + e.getSimpleName());
                    this.out.println("**Class**: " + e);
                    this.out.println();
                    this.out.println("**Description**: " + dcTree);
                    this.out.println();
                    this.out.println("| Value | Docs |");
                    this.out.println("| ----- | ---- |");
                    break;
                }
                case ENUM_CONSTANT: {
                    this.out.println("| " + CrdReferenceDoclet.this.getNameOrJsonPropValue(e) + " | " + (dcTree != null ? CrdReferenceDoclet.this.cleanDoc(dcTree.toString()) : "") + " |");
                    return null;
                }
                default: {
                    return null;
                }
            }
            return (Void)super.scan(e, Integer.valueOf(depth + 1));
        }
    }
}

