/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.api.validation;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrdCompatibilityChecker {
    private static final Logger logger = LoggerFactory.getLogger(CrdCompatibilityChecker.class);
    private static final ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public static void main(String[] args) throws IOException {
        for (int i = 1; i < args.length; ++i) {
            String actualSchema = args[0];
            String oldSchema = args[i];
            logger.info("New schema: {}", (Object)actualSchema);
            logger.info("Old schema: {}", (Object)oldSchema);
            CrdCompatibilityChecker.checkObjectCompatibility("", CrdCompatibilityChecker.getSchema(oldSchema), CrdCompatibilityChecker.getSchema(actualSchema));
        }
        System.out.println("Successful validation!");
    }

    private static JsonNode getSchema(String url) throws IOException {
        JsonNode crd = objectMapper.readTree(new URL(url));
        return crd.get("spec").get("versions").get(0).get("schema").get("openAPIV3Schema");
    }

    protected static void checkObjectCompatibility(String path, JsonNode oldNode, JsonNode newNode) {
        CrdCompatibilityChecker.checkTypeCompatibility(path, oldNode, newNode);
        if (oldNode.has("type") && oldNode.get("type").asText().equals("object") && oldNode.has("properties")) {
            JsonNode oldProps = oldNode.get("properties");
            JsonNode newProps = newNode.get("properties");
            Iterator fieldNamesIt = oldProps.fieldNames();
            while (fieldNamesIt.hasNext()) {
                String field = (String)fieldNamesIt.next();
                String fieldPath = path + "." + field;
                if (!newProps.has(field)) {
                    if (fieldPath.endsWith(".metadata.clusterName")) continue;
                    CrdCompatibilityChecker.err(fieldPath + " has been removed");
                    continue;
                }
                CrdCompatibilityChecker.checkObjectCompatibility(fieldPath, oldProps.get(field), newProps.get(field));
            }
            logger.debug("Successfully validated property names for {}", (Object)path);
        } else {
            logger.debug("Successfully validated type for {}", (Object)path);
        }
    }

    protected static void checkTypeCompatibility(String path, JsonNode oldNode, JsonNode newNode) {
        String oldType;
        if (!oldNode.has("type") && oldNode.has("anyOf")) {
            if (!oldNode.equals((Object)newNode)) {
                CrdCompatibilityChecker.err("AnyOf type mismatch for" + path);
            } else {
                return;
            }
        }
        if (!(oldType = oldNode.get("type").asText()).equals(newNode.get("type").asText())) {
            CrdCompatibilityChecker.err("Type mismatch for " + path);
        }
        CrdCompatibilityChecker.verifyOtherPropsMatch(path, oldNode, newNode);
        if (oldType.equals("string")) {
            CrdCompatibilityChecker.checkStringTypeCompatibility(path, oldNode, newNode);
        }
        if (oldType.equals("object") && oldNode.has("additionalProperties")) {
            CrdCompatibilityChecker.checkTypeCompatibility(path + ".additionalProperties", oldNode.get("additionalProperties"), newNode.get("additionalProperties"));
        }
        if (oldType.equals("array")) {
            CrdCompatibilityChecker.checkObjectCompatibility(path + ".items", oldNode.get("items"), newNode.get("items"));
        }
    }

    protected static void verifyOtherPropsMatch(String path, JsonNode oldNode, JsonNode newNode) {
        ObjectNode oldCopy = (ObjectNode)oldNode.deepCopy();
        ObjectNode newCopy = (ObjectNode)newNode.deepCopy();
        List.of("items", "additionalProperties", "properties", "enum", "type").forEach(k -> {
            oldCopy.remove(k);
            newCopy.remove(k);
        });
        if (!oldCopy.equals((Object)newCopy)) {
            CrdCompatibilityChecker.err("Other property mismatch for " + path);
        }
    }

    protected static void checkStringTypeCompatibility(String path, JsonNode oldNode, JsonNode newNode) {
        if (!oldNode.has("enum") && newNode.has("enum")) {
            CrdCompatibilityChecker.err("Cannot turn string into enum for " + path);
        }
        if (oldNode.has("enum")) {
            if (!newNode.has("enum")) {
                return;
            }
            ArrayList newElements = new ArrayList();
            newNode.get("enum").elements().forEachRemaining(jn -> newElements.add(jn.asText()));
            oldNode.get("enum").elements().forEachRemaining(jn -> {
                if (!newElements.contains(jn.asText())) {
                    CrdCompatibilityChecker.err("Enum value " + jn.asText() + " has been removed for " + path);
                }
            });
        }
    }

    private static void err(String err) {
        throw new CompatibilityError(err);
    }

    public static class CompatibilityError
    extends RuntimeException {
        public CompatibilityError(String msg) {
            super(msg);
        }
    }
}

