/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.api.spec;

import io.fabric8.kubernetes.api.model.Pod;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.kubernetes.operator.api.spec.Resource;

@Experimental
public class JobManagerSpec {
    private Resource resource;
    private int replicas = 1;
    private Pod podTemplate;

    public static JobManagerSpecBuilder builder() {
        return new JobManagerSpecBuilder();
    }

    public Resource getResource() {
        return this.resource;
    }

    public int getReplicas() {
        return this.replicas;
    }

    public Pod getPodTemplate() {
        return this.podTemplate;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setReplicas(int replicas) {
        this.replicas = replicas;
    }

    public void setPodTemplate(Pod podTemplate) {
        this.podTemplate = podTemplate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobManagerSpec)) {
            return false;
        }
        JobManagerSpec other = (JobManagerSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getReplicas() != other.getReplicas()) {
            return false;
        }
        Resource this$resource = this.getResource();
        Resource other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !((Object)this$resource).equals(other$resource)) {
            return false;
        }
        Pod this$podTemplate = this.getPodTemplate();
        Pod other$podTemplate = other.getPodTemplate();
        return !(this$podTemplate == null ? other$podTemplate != null : !this$podTemplate.equals(other$podTemplate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobManagerSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getReplicas();
        Resource $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : ((Object)$resource).hashCode());
        Pod $podTemplate = this.getPodTemplate();
        result = result * 59 + ($podTemplate == null ? 43 : $podTemplate.hashCode());
        return result;
    }

    public String toString() {
        return "JobManagerSpec(resource=" + this.getResource() + ", replicas=" + this.getReplicas() + ", podTemplate=" + this.getPodTemplate() + ")";
    }

    public JobManagerSpec() {
    }

    public JobManagerSpec(Resource resource, int replicas, Pod podTemplate) {
        this.resource = resource;
        this.replicas = replicas;
        this.podTemplate = podTemplate;
    }

    public static class JobManagerSpecBuilder {
        private Resource resource;
        private int replicas;
        private Pod podTemplate;

        JobManagerSpecBuilder() {
        }

        public JobManagerSpecBuilder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public JobManagerSpecBuilder replicas(int replicas) {
            this.replicas = replicas;
            return this;
        }

        public JobManagerSpecBuilder podTemplate(Pod podTemplate) {
            this.podTemplate = podTemplate;
            return this;
        }

        public JobManagerSpec build() {
            return new JobManagerSpec(this.resource, this.replicas, this.podTemplate);
        }

        public String toString() {
            return "JobManagerSpec.JobManagerSpecBuilder(resource=" + this.resource + ", replicas=" + this.replicas + ", podTemplate=" + this.podTemplate + ")";
        }
    }
}

