/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.api.spec;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.api.FlinkDeployment;
import org.apache.flink.kubernetes.operator.api.FlinkSessionJob;
import org.apache.flink.kubernetes.operator.api.spec.JobKind;

@JsonIgnoreProperties(ignoreUnknown=true)
@Experimental
public class JobReference {
    private JobKind kind;
    private String name;

    public static JobReference fromFlinkResource(AbstractFlinkResource<?, ?> flinkResource) {
        JobReference result = new JobReference();
        result.setName(flinkResource.getMetadata().getName());
        if (flinkResource instanceof FlinkDeployment) {
            result.setKind(JobKind.FLINK_DEPLOYMENT);
        } else if (flinkResource instanceof FlinkSessionJob) {
            result.setKind(JobKind.FLINK_SESSION_JOB);
        }
        return result;
    }

    public String toString() {
        String kindString = this.kind.name();
        if (this.kind == JobKind.FLINK_DEPLOYMENT) {
            kindString = "FlinkDeployment";
        } else if (this.kind == JobKind.FLINK_SESSION_JOB) {
            kindString = "FlinkSessionJob";
        }
        return String.format("%s (%s)", this.name, kindString);
    }

    public static JobReferenceBuilder builder() {
        return new JobReferenceBuilder();
    }

    public JobKind getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public void setKind(JobKind kind) {
        this.kind = kind;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobReference)) {
            return false;
        }
        JobReference other = (JobReference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JobKind this$kind = this.getKind();
        JobKind other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobReference;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JobKind $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public JobReference() {
    }

    public JobReference(JobKind kind, String name) {
        this.kind = kind;
        this.name = name;
    }

    public static class JobReferenceBuilder {
        private JobKind kind;
        private String name;

        JobReferenceBuilder() {
        }

        public JobReferenceBuilder kind(JobKind kind) {
            this.kind = kind;
            return this;
        }

        public JobReferenceBuilder name(String name) {
            this.name = name;
            return this;
        }

        public JobReference build() {
            return new JobReference(this.kind, this.name);
        }

        public String toString() {
            return "JobReference.JobReferenceBuilder(kind=" + this.kind + ", name=" + this.name + ")";
        }
    }
}

