/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.api.spec;

import org.apache.flink.annotation.Experimental;

@Experimental
public enum FlinkVersion {
    v1_13(1, 13),
    v1_14(1, 14),
    v1_15(1, 15),
    v1_16(1, 16),
    v1_17(1, 17),
    v1_18(1, 18),
    v1_19(1, 19),
    v1_20(1, 20),
    v2_0(2, 0);

    private final int majorVersion;
    private final int minorVersion;

    private FlinkVersion(int major, int minor) {
        this.majorVersion = major;
        this.minorVersion = minor;
    }

    public boolean isEqualOrNewer(FlinkVersion otherVersion) {
        if (this.majorVersion > otherVersion.majorVersion) {
            return true;
        }
        if (this.majorVersion == otherVersion.majorVersion) {
            return this.minorVersion >= otherVersion.minorVersion;
        }
        return false;
    }

    public static boolean isSupported(FlinkVersion version) {
        return version != null && version.isEqualOrNewer(v1_15);
    }

    public static FlinkVersion fromMajorMinor(int major, int minor) {
        for (FlinkVersion version : FlinkVersion.values()) {
            if (version.majorVersion != major || version.minorVersion != minor) continue;
            return version;
        }
        throw new IllegalArgumentException("Unknown Flink version: " + major + "." + minor);
    }
}

