/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.api.reconciler;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.kubernetes.operator.api.AbstractFlinkResource;
import org.apache.flink.kubernetes.operator.api.status.CommonStatus;
import org.apache.flink.kubernetes.operator.api.status.ReconciliationState;
import org.apache.flink.kubernetes.operator.api.status.ReconciliationStatus;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ReconciliationMetadata {
    private String apiVersion;
    private boolean firstDeployment;

    public static ReconciliationMetadata from(AbstractFlinkResource<?, ?> resource) {
        boolean firstDeploy = ((CommonStatus)resource.getStatus()).getReconciliationStatus().isBeforeFirstDeployment() || ReconciliationMetadata.isFirstDeployment(resource);
        return new ReconciliationMetadata(resource.getApiVersion(), firstDeploy);
    }

    private static boolean isFirstDeployment(AbstractFlinkResource<?, ?> resource) {
        ReconciliationStatus reconStatus = ((CommonStatus)resource.getStatus()).getReconciliationStatus();
        return reconStatus.getState() == ReconciliationState.DEPLOYED && reconStatus.deserializeLastReconciledSpecWithMeta().getMeta().firstDeployment;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public boolean isFirstDeployment() {
        return this.firstDeployment;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public void setFirstDeployment(boolean firstDeployment) {
        this.firstDeployment = firstDeployment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReconciliationMetadata)) {
            return false;
        }
        ReconciliationMetadata other = (ReconciliationMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFirstDeployment() != other.isFirstDeployment()) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        return !(this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReconciliationMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFirstDeployment() ? 79 : 97);
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        return result;
    }

    public String toString() {
        return "ReconciliationMetadata(apiVersion=" + this.getApiVersion() + ", firstDeployment=" + this.isFirstDeployment() + ")";
    }

    public ReconciliationMetadata() {
    }

    public ReconciliationMetadata(String apiVersion, boolean firstDeployment) {
        this.apiVersion = apiVersion;
        this.firstDeployment = firstDeployment;
    }
}

