/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonFormatOptions;
import org.apache.flink.formats.json.JsonFormatOptionsUtil;
import org.apache.flink.formats.json.JsonRowDataDeserializationSchema;
import org.apache.flink.formats.json.JsonRowDataSerializationSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;

@Internal
public class JsonFormatFactory
implements DeserializationFormatFactory,
SerializationFormatFactory {
    public static final String IDENTIFIER = "json";

    public DecodingFormat<DeserializationSchema<RowData>> createDecodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatOptions);
        JsonFormatOptionsUtil.validateDecodingFormatOptions(formatOptions);
        final boolean failOnMissingField = (Boolean)formatOptions.get(JsonFormatOptions.FAIL_ON_MISSING_FIELD);
        final boolean ignoreParseErrors = (Boolean)formatOptions.get(JsonFormatOptions.IGNORE_PARSE_ERRORS);
        final TimestampFormat timestampOption = JsonFormatOptionsUtil.getTimestampFormat(formatOptions);
        return new DecodingFormat<DeserializationSchema<RowData>>(){

            public DeserializationSchema<RowData> createRuntimeDecoder(DynamicTableSource.Context context, DataType producedDataType) {
                RowType rowType = (RowType)producedDataType.getLogicalType();
                TypeInformation rowDataTypeInfo = context.createTypeInformation(producedDataType);
                return new JsonRowDataDeserializationSchema(rowType, (TypeInformation<RowData>)rowDataTypeInfo, failOnMissingField, ignoreParseErrors, timestampOption);
            }

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.insertOnly();
            }
        };
    }

    public EncodingFormat<SerializationSchema<RowData>> createEncodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatOptions);
        JsonFormatOptionsUtil.validateEncodingFormatOptions(formatOptions);
        final TimestampFormat timestampOption = JsonFormatOptionsUtil.getTimestampFormat(formatOptions);
        final JsonFormatOptions.MapNullKeyMode mapNullKeyMode = JsonFormatOptionsUtil.getMapNullKeyMode(formatOptions);
        final String mapNullKeyLiteral = (String)formatOptions.get(JsonFormatOptions.MAP_NULL_KEY_LITERAL);
        final boolean encodeDecimalAsPlainNumber = (Boolean)formatOptions.get(JsonFormatOptions.ENCODE_DECIMAL_AS_PLAIN_NUMBER);
        return new EncodingFormat<SerializationSchema<RowData>>(){

            public SerializationSchema<RowData> createRuntimeEncoder(DynamicTableSink.Context context, DataType consumedDataType) {
                RowType rowType = (RowType)consumedDataType.getLogicalType();
                return new JsonRowDataSerializationSchema(rowType, timestampOption, mapNullKeyMode, mapNullKeyLiteral, encodeDecimalAsPlainNumber);
            }

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.insertOnly();
            }
        };
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Collections.emptySet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(JsonFormatOptions.FAIL_ON_MISSING_FIELD);
        options.add(JsonFormatOptions.IGNORE_PARSE_ERRORS);
        options.add(JsonFormatOptions.TIMESTAMP_FORMAT);
        options.add(JsonFormatOptions.MAP_NULL_KEY_MODE);
        options.add(JsonFormatOptions.MAP_NULL_KEY_LITERAL);
        options.add(JsonFormatOptions.ENCODE_DECIMAL_AS_PLAIN_NUMBER);
        return options;
    }
}

