/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json.maxwell;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonRowDataDeserializationSchema;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;

public class MaxwellJsonDeserializationSchema
implements DeserializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private static final String OP_INSERT = "insert";
    private static final String OP_UPDATE = "update";
    private static final String OP_DELETE = "delete";
    private final JsonRowDataDeserializationSchema jsonDeserializer;
    private final TypeInformation<RowData> resultTypeInfo;
    private final boolean ignoreParseErrors;
    private final int fieldCount;

    public MaxwellJsonDeserializationSchema(RowType rowType, TypeInformation<RowData> resultTypeInfo, boolean ignoreParseErrors, TimestampFormat timestampFormatOption) {
        this.resultTypeInfo = resultTypeInfo;
        this.ignoreParseErrors = ignoreParseErrors;
        this.fieldCount = rowType.getFieldCount();
        this.jsonDeserializer = new JsonRowDataDeserializationSchema(this.createJsonRowType(TypeConversions.fromLogicalToDataType((LogicalType)rowType)), resultTypeInfo, false, ignoreParseErrors, timestampFormatOption);
    }

    public RowData deserialize(byte[] message) throws IOException {
        throw new RuntimeException("Please invoke DeserializationSchema#deserialize(byte[], Collector<RowData>) instead.");
    }

    public void deserialize(byte[] message, Collector<RowData> out) throws IOException {
        block10: {
            try {
                RowData row = this.jsonDeserializer.deserialize(message);
                String type = row.getString(2).toString();
                if (OP_INSERT.equals(type)) {
                    RowData insert = row.getRow(0, this.fieldCount);
                    insert.setRowKind(RowKind.INSERT);
                    out.collect((Object)insert);
                } else if (OP_UPDATE.equals(type)) {
                    GenericRowData after = (GenericRowData)row.getRow(0, this.fieldCount);
                    GenericRowData before = (GenericRowData)row.getRow(1, this.fieldCount);
                    for (int f = 0; f < this.fieldCount; ++f) {
                        if (!before.isNullAt(f)) continue;
                        before.setField(f, after.getField(f));
                    }
                    before.setRowKind(RowKind.UPDATE_BEFORE);
                    after.setRowKind(RowKind.UPDATE_AFTER);
                    out.collect((Object)before);
                    out.collect((Object)after);
                } else if (OP_DELETE.equals(type)) {
                    RowData delete = row.getRow(0, this.fieldCount);
                    delete.setRowKind(RowKind.DELETE);
                    out.collect((Object)delete);
                } else if (!this.ignoreParseErrors) {
                    throw new IOException(String.format("Unknown \"type\" value \"%s\". The Maxwell JSON message is '%s'", type, new String(message)));
                }
            }
            catch (Throwable t) {
                if (this.ignoreParseErrors) break block10;
                throw new IOException(String.format("Corrupt Maxwell JSON message '%s'.", new String(message)), t);
            }
        }
    }

    public boolean isEndOfStream(RowData nextElement) {
        return false;
    }

    public TypeInformation<RowData> getProducedType() {
        return this.resultTypeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaxwellJsonDeserializationSchema that = (MaxwellJsonDeserializationSchema)o;
        return this.ignoreParseErrors == that.ignoreParseErrors && this.fieldCount == that.fieldCount && Objects.equals(this.jsonDeserializer, that.jsonDeserializer) && Objects.equals(this.resultTypeInfo, that.resultTypeInfo);
    }

    public int hashCode() {
        return Objects.hash(this.jsonDeserializer, this.resultTypeInfo, this.ignoreParseErrors, this.fieldCount);
    }

    private RowType createJsonRowType(DataType databaseSchema) {
        return (RowType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"data", (DataType)databaseSchema), DataTypes.FIELD((String)"old", (DataType)databaseSchema), DataTypes.FIELD((String)"type", (DataType)DataTypes.STRING())}).getLogicalType();
    }
}

