/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io.jdbc;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.flink.api.common.io.RichOutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.types.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCOutputFormat
extends RichOutputFormat<Row> {
    private static final long serialVersionUID = 1L;
    static final int DEFAULT_BATCH_INTERVAL = 5000;
    private static final Logger LOG = LoggerFactory.getLogger(JDBCOutputFormat.class);
    private String username;
    private String password;
    private String drivername;
    private String dbURL;
    private String query;
    private int batchInterval = 5000;
    private Connection dbConn;
    private PreparedStatement upload;
    private int batchCount = 0;
    private int[] typesArray;

    public void configure(Configuration parameters) {
    }

    public void open(int taskNumber, int numTasks) throws IOException {
        try {
            this.establishConnection();
            this.upload = this.dbConn.prepareStatement(this.query);
        }
        catch (SQLException sqe) {
            throw new IllegalArgumentException("open() failed.", sqe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException("JDBC driver class not found.", cnfe);
        }
    }

    private void establishConnection() throws SQLException, ClassNotFoundException {
        Class.forName(this.drivername);
        this.dbConn = this.username == null ? DriverManager.getConnection(this.dbURL) : DriverManager.getConnection(this.dbURL, this.username, this.password);
    }

    public void writeRecord(Row row) throws IOException {
        if (this.typesArray != null && this.typesArray.length > 0 && this.typesArray.length != row.getArity()) {
            LOG.warn("Column SQL types array doesn't match arity of passed Row! Check the passed array...");
        }
        try {
            if (this.typesArray == null) {
                for (int index = 0; index < row.getArity(); ++index) {
                    LOG.warn("Unknown column type for column {}. Best effort approach to set its value: {}.", (Object)(index + 1), row.getField(index));
                    this.upload.setObject(index + 1, row.getField(index));
                }
            } else {
                block19: for (int index = 0; index < row.getArity(); ++index) {
                    if (row.getField(index) == null) {
                        this.upload.setNull(index + 1, this.typesArray[index]);
                        continue;
                    }
                    switch (this.typesArray[index]) {
                        case 0: {
                            this.upload.setNull(index + 1, this.typesArray[index]);
                            continue block19;
                        }
                        case -7: 
                        case 16: {
                            this.upload.setBoolean(index + 1, (Boolean)row.getField(index));
                            continue block19;
                        }
                        case -16: 
                        case -15: 
                        case -1: 
                        case 1: 
                        case 12: {
                            this.upload.setString(index + 1, (String)row.getField(index));
                            continue block19;
                        }
                        case -6: {
                            this.upload.setByte(index + 1, (Byte)row.getField(index));
                            continue block19;
                        }
                        case 5: {
                            this.upload.setShort(index + 1, (Short)row.getField(index));
                            continue block19;
                        }
                        case 4: {
                            this.upload.setInt(index + 1, (Integer)row.getField(index));
                            continue block19;
                        }
                        case -5: {
                            this.upload.setLong(index + 1, (Long)row.getField(index));
                            continue block19;
                        }
                        case 7: {
                            this.upload.setFloat(index + 1, ((Float)row.getField(index)).floatValue());
                            continue block19;
                        }
                        case 6: 
                        case 8: {
                            this.upload.setDouble(index + 1, (Double)row.getField(index));
                            continue block19;
                        }
                        case 2: 
                        case 3: {
                            this.upload.setBigDecimal(index + 1, (BigDecimal)row.getField(index));
                            continue block19;
                        }
                        case 91: {
                            this.upload.setDate(index + 1, (Date)row.getField(index));
                            continue block19;
                        }
                        case 92: {
                            this.upload.setTime(index + 1, (Time)row.getField(index));
                            continue block19;
                        }
                        case 93: {
                            this.upload.setTimestamp(index + 1, (Timestamp)row.getField(index));
                            continue block19;
                        }
                        case -4: 
                        case -3: 
                        case -2: {
                            this.upload.setBytes(index + 1, (byte[])row.getField(index));
                            continue block19;
                        }
                        default: {
                            this.upload.setObject(index + 1, row.getField(index));
                            LOG.warn("Unmanaged sql type ({}) for column {}. Best effort approach to set its value: {}.", new Object[]{this.typesArray[index], index + 1, row.getField(index)});
                        }
                    }
                }
            }
            this.upload.addBatch();
            ++this.batchCount;
        }
        catch (SQLException e) {
            throw new RuntimeException("Preparation of JDBC statement failed.", e);
        }
        if (this.batchCount >= this.batchInterval) {
            this.flush();
        }
    }

    void flush() {
        try {
            this.upload.executeBatch();
            this.batchCount = 0;
        }
        catch (SQLException e) {
            throw new RuntimeException("Execution of JDBC statement failed.", e);
        }
    }

    int[] getTypesArray() {
        return this.typesArray;
    }

    public void close() throws IOException {
        if (this.upload != null) {
            this.flush();
            try {
                this.upload.close();
            }
            catch (SQLException e) {
                LOG.info("JDBC statement could not be closed: " + e.getMessage());
            }
            finally {
                this.upload = null;
            }
        }
        if (this.dbConn != null) {
            try {
                this.dbConn.close();
            }
            catch (SQLException se) {
                LOG.info("JDBC connection could not be closed: " + se.getMessage());
            }
            finally {
                this.dbConn = null;
            }
        }
    }

    public static JDBCOutputFormatBuilder buildJDBCOutputFormat() {
        return new JDBCOutputFormatBuilder();
    }

    static /* synthetic */ int[] access$602(JDBCOutputFormat x0, int[] x1) {
        x0.typesArray = x1;
        return x1;
    }

    public static class JDBCOutputFormatBuilder {
        private final JDBCOutputFormat format = new JDBCOutputFormat();

        protected JDBCOutputFormatBuilder() {
        }

        public JDBCOutputFormatBuilder setUsername(String username) {
            this.format.username = username;
            return this;
        }

        public JDBCOutputFormatBuilder setPassword(String password) {
            this.format.password = password;
            return this;
        }

        public JDBCOutputFormatBuilder setDrivername(String drivername) {
            this.format.drivername = drivername;
            return this;
        }

        public JDBCOutputFormatBuilder setDBUrl(String dbURL) {
            this.format.dbURL = dbURL;
            return this;
        }

        public JDBCOutputFormatBuilder setQuery(String query) {
            this.format.query = query;
            return this;
        }

        public JDBCOutputFormatBuilder setBatchInterval(int batchInterval) {
            this.format.batchInterval = batchInterval;
            return this;
        }

        public JDBCOutputFormatBuilder setSqlTypes(int[] typesArray) {
            JDBCOutputFormat.access$602(this.format, typesArray);
            return this;
        }

        public JDBCOutputFormat finish() {
            if (this.format.username == null) {
                LOG.info("Username was not supplied.");
            }
            if (this.format.password == null) {
                LOG.info("Password was not supplied.");
            }
            if (this.format.dbURL == null) {
                throw new IllegalArgumentException("No database URL supplied.");
            }
            if (this.format.query == null) {
                throw new IllegalArgumentException("No query supplied.");
            }
            if (this.format.drivername == null) {
                throw new IllegalArgumentException("No driver supplied.");
            }
            return this.format;
        }
    }
}

