/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io.jdbc;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.io.DefaultInputSplitAssigner;
import org.apache.flink.api.common.io.RichInputFormat;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.api.java.io.jdbc.split.ParameterValuesProvider;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.GenericInputSplit;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.core.io.InputSplitAssigner;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCInputFormat
extends RichInputFormat<Row, InputSplit>
implements ResultTypeQueryable<Row> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(JDBCInputFormat.class);
    private String username;
    private String password;
    private String drivername;
    private String dbURL;
    private String queryTemplate;
    private int resultSetType;
    private int resultSetConcurrency;
    private RowTypeInfo rowTypeInfo;
    private transient Connection dbConn;
    private transient PreparedStatement statement;
    private transient ResultSet resultSet;
    private int fetchSize;
    private boolean hasNext;
    private Object[][] parameterValues;

    public RowTypeInfo getProducedType() {
        return this.rowTypeInfo;
    }

    public void configure(Configuration parameters) {
    }

    public void openInputFormat() {
        try {
            Class.forName(this.drivername);
            this.dbConn = this.username == null ? DriverManager.getConnection(this.dbURL) : DriverManager.getConnection(this.dbURL, this.username, this.password);
            this.statement = this.dbConn.prepareStatement(this.queryTemplate, this.resultSetType, this.resultSetConcurrency);
            if (this.fetchSize == Integer.MIN_VALUE || this.fetchSize > 0) {
                this.statement.setFetchSize(this.fetchSize);
            }
        }
        catch (SQLException se) {
            throw new IllegalArgumentException("open() failed." + se.getMessage(), se);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException("JDBC-Class not found. - " + cnfe.getMessage(), cnfe);
        }
    }

    public void closeInputFormat() {
        try {
            if (this.statement != null) {
                this.statement.close();
            }
        }
        catch (SQLException se) {
            LOG.info("Inputformat Statement couldn't be closed - " + se.getMessage());
        }
        finally {
            this.statement = null;
        }
        try {
            if (this.dbConn != null) {
                this.dbConn.close();
            }
        }
        catch (SQLException se) {
            LOG.info("Inputformat couldn't be closed - " + se.getMessage());
        }
        finally {
            this.dbConn = null;
        }
        this.parameterValues = null;
    }

    public void open(InputSplit inputSplit) throws IOException {
        try {
            if (inputSplit != null && this.parameterValues != null) {
                for (int i = 0; i < this.parameterValues[inputSplit.getSplitNumber()].length; ++i) {
                    Object param = this.parameterValues[inputSplit.getSplitNumber()][i];
                    if (param instanceof String) {
                        this.statement.setString(i + 1, (String)param);
                        continue;
                    }
                    if (param instanceof Long) {
                        this.statement.setLong(i + 1, (Long)param);
                        continue;
                    }
                    if (param instanceof Integer) {
                        this.statement.setInt(i + 1, (Integer)param);
                        continue;
                    }
                    if (param instanceof Double) {
                        this.statement.setDouble(i + 1, (Double)param);
                        continue;
                    }
                    if (param instanceof Boolean) {
                        this.statement.setBoolean(i + 1, (Boolean)param);
                        continue;
                    }
                    if (param instanceof Float) {
                        this.statement.setFloat(i + 1, ((Float)param).floatValue());
                        continue;
                    }
                    if (param instanceof BigDecimal) {
                        this.statement.setBigDecimal(i + 1, (BigDecimal)param);
                        continue;
                    }
                    if (param instanceof Byte) {
                        this.statement.setByte(i + 1, (Byte)param);
                        continue;
                    }
                    if (param instanceof Short) {
                        this.statement.setShort(i + 1, (Short)param);
                        continue;
                    }
                    if (param instanceof Date) {
                        this.statement.setDate(i + 1, (Date)param);
                        continue;
                    }
                    if (param instanceof Time) {
                        this.statement.setTime(i + 1, (Time)param);
                        continue;
                    }
                    if (param instanceof Timestamp) {
                        this.statement.setTimestamp(i + 1, (Timestamp)param);
                        continue;
                    }
                    if (param instanceof Array) {
                        this.statement.setArray(i + 1, (Array)param);
                        continue;
                    }
                    throw new IllegalArgumentException("open() failed. Parameter " + i + " of type " + param.getClass() + " is not handled (yet).");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Executing '%s' with parameters %s", this.queryTemplate, Arrays.deepToString(this.parameterValues[inputSplit.getSplitNumber()])));
                }
            }
            this.resultSet = this.statement.executeQuery();
            this.hasNext = this.resultSet.next();
        }
        catch (SQLException se) {
            throw new IllegalArgumentException("open() failed." + se.getMessage(), se);
        }
    }

    public void close() throws IOException {
        if (this.resultSet == null) {
            return;
        }
        try {
            this.resultSet.close();
        }
        catch (SQLException se) {
            LOG.info("Inputformat ResultSet couldn't be closed - " + se.getMessage());
        }
    }

    public boolean reachedEnd() throws IOException {
        return !this.hasNext;
    }

    public Row nextRecord(Row row) throws IOException {
        try {
            if (!this.hasNext) {
                return null;
            }
            for (int pos = 0; pos < row.getArity(); ++pos) {
                row.setField(pos, this.resultSet.getObject(pos + 1));
            }
            this.hasNext = this.resultSet.next();
            return row;
        }
        catch (SQLException se) {
            throw new IOException("Couldn't read data - " + se.getMessage(), se);
        }
        catch (NullPointerException npe) {
            throw new IOException("Couldn't access resultSet", npe);
        }
    }

    public BaseStatistics getStatistics(BaseStatistics cachedStatistics) throws IOException {
        return cachedStatistics;
    }

    public InputSplit[] createInputSplits(int minNumSplits) throws IOException {
        if (this.parameterValues == null) {
            return new GenericInputSplit[]{new GenericInputSplit(0, 1)};
        }
        GenericInputSplit[] ret = new GenericInputSplit[this.parameterValues.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new GenericInputSplit(i, ret.length);
        }
        return ret;
    }

    public InputSplitAssigner getInputSplitAssigner(InputSplit[] inputSplits) {
        return new DefaultInputSplitAssigner(inputSplits);
    }

    @VisibleForTesting
    PreparedStatement getStatement() {
        return this.statement;
    }

    public static JDBCInputFormatBuilder buildJDBCInputFormat() {
        return new JDBCInputFormatBuilder();
    }

    static /* synthetic */ Object[][] access$702(JDBCInputFormat x0, Object[][] x1) {
        x0.parameterValues = x1;
        return x1;
    }

    public static class JDBCInputFormatBuilder {
        private final JDBCInputFormat format = new JDBCInputFormat();

        public JDBCInputFormatBuilder() {
            this.format.resultSetType = 1003;
            this.format.resultSetConcurrency = 1007;
        }

        public JDBCInputFormatBuilder setUsername(String username) {
            this.format.username = username;
            return this;
        }

        public JDBCInputFormatBuilder setPassword(String password) {
            this.format.password = password;
            return this;
        }

        public JDBCInputFormatBuilder setDrivername(String drivername) {
            this.format.drivername = drivername;
            return this;
        }

        public JDBCInputFormatBuilder setDBUrl(String dbURL) {
            this.format.dbURL = dbURL;
            return this;
        }

        public JDBCInputFormatBuilder setQuery(String query) {
            this.format.queryTemplate = query;
            return this;
        }

        public JDBCInputFormatBuilder setResultSetType(int resultSetType) {
            this.format.resultSetType = resultSetType;
            return this;
        }

        public JDBCInputFormatBuilder setResultSetConcurrency(int resultSetConcurrency) {
            this.format.resultSetConcurrency = resultSetConcurrency;
            return this;
        }

        public JDBCInputFormatBuilder setParametersProvider(ParameterValuesProvider parameterValuesProvider) {
            JDBCInputFormat.access$702(this.format, parameterValuesProvider.getParameterValues());
            return this;
        }

        public JDBCInputFormatBuilder setRowTypeInfo(RowTypeInfo rowTypeInfo) {
            this.format.rowTypeInfo = rowTypeInfo;
            return this;
        }

        public JDBCInputFormatBuilder setFetchSize(int fetchSize) {
            Preconditions.checkArgument((fetchSize == Integer.MIN_VALUE || fetchSize > 0 ? 1 : 0) != 0, (String)"Illegal value %s for fetchSize, has to be positive or Integer.MIN_VALUE.", (Object[])new Object[]{fetchSize});
            this.format.fetchSize = fetchSize;
            return this;
        }

        public JDBCInputFormat finish() {
            if (this.format.username == null) {
                LOG.info("Username was not supplied separately.");
            }
            if (this.format.password == null) {
                LOG.info("Password was not supplied separately.");
            }
            if (this.format.dbURL == null) {
                throw new IllegalArgumentException("No database URL supplied");
            }
            if (this.format.queryTemplate == null) {
                throw new IllegalArgumentException("No query supplied");
            }
            if (this.format.drivername == null) {
                throw new IllegalArgumentException("No driver supplied");
            }
            if (this.format.rowTypeInfo == null) {
                throw new IllegalArgumentException("No " + RowTypeInfo.class.getSimpleName() + " supplied");
            }
            if (this.format.parameterValues == null) {
                LOG.debug("No input splitting configured (data will be read with parallelism 1).");
            }
            return this.format;
        }
    }
}

