/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.util.Preconditions;

@Public
public abstract class Operator<OUT, O extends Operator<OUT, O>>
extends DataSet<OUT> {
    protected String name;
    protected int parallelism = -1;
    protected ResourceSpec minResources = ResourceSpec.DEFAULT;
    protected ResourceSpec preferredResources = ResourceSpec.DEFAULT;

    protected Operator(ExecutionEnvironment context, TypeInformation<OUT> resultType) {
        super(context, resultType);
    }

    public TypeInformation<OUT> getResultType() {
        return this.getType();
    }

    public String getName() {
        return this.name;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public ResourceSpec getMinResources() {
        return this.minResources;
    }

    public ResourceSpec getPreferredResources() {
        return this.preferredResources;
    }

    public O name(String newName) {
        this.name = newName;
        Operator returnType = this;
        return (O)returnType;
    }

    public O setParallelism(int parallelism) {
        Preconditions.checkArgument((parallelism > 0 || parallelism == -1 ? 1 : 0) != 0, (Object)"The parallelism must be at least one, or ExecutionConfig.PARALLELISM_DEFAULT (use system default).");
        this.parallelism = parallelism;
        Operator returnType = this;
        return (O)returnType;
    }

    private O setResources(ResourceSpec minResources, ResourceSpec preferredResources) {
        Preconditions.checkNotNull((Object)minResources, (String)"The min resources must be not null.");
        Preconditions.checkNotNull((Object)preferredResources, (String)"The preferred resources must be not null.");
        Preconditions.checkArgument((minResources.isValid() && preferredResources.isValid() && minResources.lessThanOrEqual(preferredResources) ? 1 : 0) != 0, (Object)"The values in resources must be not less than 0 and the preferred resources must be greater than the min resources.");
        this.minResources = minResources;
        this.preferredResources = preferredResources;
        Operator returnType = this;
        return (O)returnType;
    }

    private O setResources(ResourceSpec resources) {
        Preconditions.checkNotNull((Object)resources, (String)"The resources must be not null.");
        Preconditions.checkArgument((boolean)resources.isValid(), (Object)"The values in resources must be not less than 0.");
        this.minResources = resources;
        this.preferredResources = resources;
        Operator returnType = this;
        return (O)returnType;
    }
}

