/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.sca;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.functions.CrossFunction;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.operators.Keys;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.SemanticPropUtil;
import org.apache.flink.api.java.sca.CodeAnalyzerException;
import org.apache.flink.api.java.sca.CodeErrorException;
import org.apache.flink.api.java.sca.NestedMethodAnalyzer;
import org.apache.flink.api.java.sca.TaggedValue;
import org.apache.flink.api.java.sca.UdfAnalyzerUtils;
import org.apache.flink.shaded.asm5.org.objectweb.asm.Type;
import org.apache.flink.shaded.asm5.org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;

@Internal
public class UdfAnalyzer {
    private static final int MAX_NESTING = 20;
    private final Method baseClassMethod;
    private final boolean hasCollector;
    private final boolean isBinary;
    private final boolean isIterableInput;
    private final boolean isReduceFunction;
    private final boolean isFilterFunction;
    private final Class<?> udfClass;
    private final String externalUdfName;
    private final String internalUdfClassName;
    private final TypeInformation<?> in1Type;
    private final TypeInformation<?> in2Type;
    private final TypeInformation<?> outType;
    private final Keys<?> keys1;
    private final Keys<?> keys2;
    private final boolean throwErrorExceptions;
    private final List<TaggedValue> collectorValues;
    private final List<String> hints;
    private boolean warning = false;
    private int state = 0;
    static final int STATE_CAPTURE_RETURN = 0;
    static final int STATE_CAPTURE_THIS = 1;
    static final int STATE_CAPTURE_INPUT1 = 2;
    static final int STATE_CAPTURE_INPUT2 = 3;
    static final int STATE_CAPTURE_COLLECTOR = 4;
    static final int STATE_END_OF_CAPTURING = 5;
    static final int STATE_END_OF_ANALYZING = 6;
    private boolean iteratorTrueAssumptionApplied;
    private TaggedValue returnValue;
    private int newOperationCounterOverall;
    private int newOperationCounterTopLevel;
    private TaggedValue filterInputCopy;
    private TaggedValue filterInputRef;

    public UdfAnalyzer(Class<?> baseClass, Class<?> udfClass, String externalUdfName, TypeInformation<?> in1Type, TypeInformation<?> in2Type, TypeInformation<?> outType, Keys<?> keys1, Keys<?> keys2, boolean throwErrorExceptions) {
        this.baseClassMethod = baseClass.getDeclaredMethods()[0];
        this.udfClass = udfClass;
        this.externalUdfName = externalUdfName;
        this.internalUdfClassName = Type.getInternalName(udfClass);
        this.in1Type = in1Type;
        this.in2Type = in2Type;
        this.outType = outType;
        this.keys1 = keys1;
        this.keys2 = keys2;
        this.throwErrorExceptions = throwErrorExceptions;
        if (baseClass == CoGroupFunction.class) {
            this.hasCollector = true;
            this.isBinary = true;
            this.isIterableInput = true;
            this.isReduceFunction = false;
            this.isFilterFunction = false;
            this.iteratorTrueAssumptionApplied = true;
        } else if (baseClass == CrossFunction.class) {
            this.hasCollector = false;
            this.isBinary = true;
            this.isIterableInput = false;
            this.isReduceFunction = false;
            this.isFilterFunction = false;
            this.iteratorTrueAssumptionApplied = true;
        } else if (baseClass == FlatJoinFunction.class) {
            this.hasCollector = true;
            this.isBinary = true;
            this.isIterableInput = false;
            this.isReduceFunction = false;
            this.isFilterFunction = false;
            this.iteratorTrueAssumptionApplied = true;
        } else if (baseClass == FlatMapFunction.class) {
            this.hasCollector = true;
            this.isBinary = false;
            this.isIterableInput = false;
            this.isReduceFunction = false;
            this.isFilterFunction = false;
            this.iteratorTrueAssumptionApplied = true;
        } else if (baseClass == GroupReduceFunction.class) {
            this.hasCollector = true;
            this.isBinary = false;
            this.isIterableInput = true;
            this.isReduceFunction = false;
            this.isFilterFunction = false;
            this.iteratorTrueAssumptionApplied = false;
        } else if (baseClass == JoinFunction.class) {
            this.hasCollector = false;
            this.isBinary = true;
            this.isIterableInput = false;
            this.isReduceFunction = false;
            this.isFilterFunction = false;
            this.iteratorTrueAssumptionApplied = true;
        } else if (baseClass == MapFunction.class) {
            this.hasCollector = false;
            this.isBinary = false;
            this.isIterableInput = false;
            this.isReduceFunction = false;
            this.isFilterFunction = false;
            this.iteratorTrueAssumptionApplied = true;
        } else if (baseClass == ReduceFunction.class) {
            this.hasCollector = false;
            this.isBinary = false;
            this.isIterableInput = false;
            this.isReduceFunction = true;
            this.isFilterFunction = false;
            this.iteratorTrueAssumptionApplied = true;
        } else if (baseClass == FilterFunction.class) {
            this.hasCollector = false;
            this.isBinary = false;
            this.isIterableInput = false;
            this.isReduceFunction = false;
            this.isFilterFunction = true;
            this.iteratorTrueAssumptionApplied = true;
        } else {
            throw new UnsupportedOperationException("Unsupported operator.");
        }
        this.collectorValues = this.hasCollector ? new ArrayList<TaggedValue>() : null;
        this.hints = new ArrayList<String>();
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public boolean isUdfBinary() {
        return this.isBinary;
    }

    public boolean isIteratorTrueAssumptionApplied() {
        return this.iteratorTrueAssumptionApplied;
    }

    public void applyIteratorTrueAssumption() {
        this.iteratorTrueAssumptionApplied = true;
    }

    public void incrNewOperationCounters(boolean topLevel) {
        ++this.newOperationCounterOverall;
        if (topLevel) {
            ++this.newOperationCounterTopLevel;
        }
    }

    public boolean hasUdfCollector() {
        return this.hasCollector;
    }

    public boolean hasUdfIterableInput() {
        return this.isIterableInput;
    }

    public boolean isUdfReduceFunction() {
        return this.isReduceFunction;
    }

    public String getInternalUdfClassName() {
        return this.internalUdfClassName;
    }

    public List<TaggedValue> getCollectorValues() {
        return this.collectorValues;
    }

    public boolean analyze() throws CodeAnalyzerException {
        if (this.state == 6) {
            throw new IllegalStateException("Analyzing is already done.");
        }
        boolean discardReturnValues = false;
        if (this.isIterableInput) {
            if (this.keys1 == null || this.keys2 == null && this.isBinary) {
                throw new IllegalArgumentException("This type of function requires key information for analysis.");
            }
            if (!(this.keys1 instanceof Keys.ExpressionKeys) || !(this.keys2 instanceof Keys.ExpressionKeys) && this.isBinary) {
                discardReturnValues = true;
            }
        }
        try {
            Object[] mn = UdfAnalyzerUtils.findMethodNode(this.internalUdfClassName, this.baseClassMethod);
            NestedMethodAnalyzer nma = new NestedMethodAnalyzer(this, (String)mn[1], (MethodNode)mn[0], null, 20, true);
            TaggedValue result = nma.analyze();
            this.setState(6);
            if (this.isFilterFunction) {
                discardReturnValues = true;
                if (!this.filterInputCopy.equals((Object)this.filterInputRef)) {
                    this.addHintOrThrowException("Function modifies the input. This can lead to unexpected behaviour during runtime.");
                }
            }
            if (!discardReturnValues) {
                this.returnValue = this.hasCollector ? UdfAnalyzerUtils.mergeReturnValues(this.collectorValues) : result;
                if ((this.isIterableInput || this.isReduceFunction) && this.returnValue != null) {
                    if (this.returnValue.canContainFields()) {
                        UdfAnalyzerUtils.removeUngroupedInputsFromContainer(this.returnValue);
                    } else if (this.returnValue.isInput() && !this.returnValue.isGrouped()) {
                        this.returnValue = null;
                    }
                }
            } else {
                this.returnValue = null;
            }
        }
        catch (Exception e) {
            Throwable cause;
            for (cause = e.getCause(); cause != null && !(cause instanceof CodeErrorException); cause = cause.getCause()) {
            }
            if (cause != null && cause instanceof CodeErrorException || e instanceof CodeErrorException) {
                throw new CodeErrorException("Function code contains obvious errors. If you think the code analysis is wrong at this point you can disable the entire code analyzer in ExecutionConfig or add @SkipCodeAnalysis to your function to disable the analysis.", cause != null ? cause : e);
            }
            throw new CodeAnalyzerException("Exception occurred during code analysis.", e);
        }
        return true;
    }

    public SemanticProperties getSemanticProperties() {
        DualInputSemanticProperties sp;
        if (this.isBinary) {
            sp = new DualInputSemanticProperties();
            if (this.returnValue != null) {
                String[] ff1Array = null;
                String ff1 = this.returnValue.toForwardedFieldsExpression(TaggedValue.Input.INPUT_1);
                if (ff1 != null && ff1.length() > 0) {
                    ff1Array = new String[]{ff1};
                }
                String[] ff2Array = null;
                String ff2 = this.returnValue.toForwardedFieldsExpression(TaggedValue.Input.INPUT_2);
                if (ff2 != null && ff2.length() > 0) {
                    ff2Array = new String[]{ff2};
                }
                SemanticPropUtil.getSemanticPropsDualFromString(sp, ff1Array, ff2Array, null, null, null, null, this.in1Type, this.in2Type, this.outType, true);
            }
        } else {
            sp = new SingleInputSemanticProperties();
            if (this.returnValue != null) {
                String[] ffArray = null;
                String ff = this.returnValue.toForwardedFieldsExpression(TaggedValue.Input.INPUT_1);
                if (ff != null && ff.length() > 0) {
                    ffArray = new String[]{ff};
                }
                SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sp, ffArray, null, null, this.in1Type, this.outType, true);
            }
        }
        return sp;
    }

    public void addSemanticPropertiesHints() {
        boolean added = false;
        if (this.returnValue != null) {
            if (this.isBinary) {
                String ff2;
                String ff1 = this.returnValue.toForwardedFieldsExpression(TaggedValue.Input.INPUT_1);
                if (ff1 != null && ff1.length() > 0) {
                    added = true;
                    this.hints.add("Possible annotation: @ForwardedFieldsFirst(\"" + ff1 + "\")");
                }
                if ((ff2 = this.returnValue.toForwardedFieldsExpression(TaggedValue.Input.INPUT_2)) != null && ff2.length() > 0) {
                    added = true;
                    this.hints.add("Possible annotation: @ForwardedFieldsSecond(\"" + ff2 + "\")");
                }
            } else {
                String ff = this.returnValue.toForwardedFieldsExpression(TaggedValue.Input.INPUT_1);
                if (ff != null && ff.length() > 0) {
                    added = true;
                    this.hints.add("Possible annotation: @ForwardedFields(\"" + ff + "\")");
                }
            }
        }
        if (!added) {
            this.hints.add("Possible annotations: none.");
        }
    }

    public void printToLogger(Logger log) {
        StringBuilder sb = new StringBuilder();
        sb.append("Code analysis result for '" + this.externalUdfName + " (" + this.udfClass.getName() + ")':");
        sb.append("\nNumber of object creations: " + this.newOperationCounterTopLevel + " in method / " + this.newOperationCounterOverall + " transitively");
        for (String hint : this.hints) {
            sb.append('\n');
            sb.append(hint);
        }
        if (this.warning) {
            log.warn(sb.toString());
        } else {
            log.info(sb.toString());
        }
    }

    public TaggedValue getInput1AsTaggedValue() {
        int[] groupedKeys = this.keys1 != null ? this.keys1.computeLogicalKeyPositions() : null;
        TaggedValue input1 = UdfAnalyzerUtils.convertTypeInfoToTaggedValue(TaggedValue.Input.INPUT_1, this.in1Type, "", null, groupedKeys);
        if (this.isFilterFunction) {
            this.filterInputRef = input1;
            this.filterInputCopy = input1.copy();
        }
        return input1;
    }

    public TaggedValue getInput2AsTaggedValue() {
        int[] groupedKeys = this.keys2 != null ? this.keys2.computeLogicalKeyPositions() : null;
        return UdfAnalyzerUtils.convertTypeInfoToTaggedValue(TaggedValue.Input.INPUT_2, this.in2Type, "", null, groupedKeys);
    }

    private void addHintOrThrowException(String msg) {
        if (this.throwErrorExceptions) {
            throw new CodeErrorException(this.externalUdfName + ": " + msg);
        }
        this.warning = true;
        this.hints.add(msg);
    }

    public void handleNullReturn() {
        this.addHintOrThrowException("Function returns 'null' values. This can lead to errors during runtime.");
    }

    public void handlePutStatic() {
        this.addHintOrThrowException("Function modifies static fields. This can lead to unexpected behaviour during runtime.");
    }

    public void handleInvalidTupleAccess() {
        this.addHintOrThrowException("Function contains tuple accesses with invalid indexes. This can lead to errors during runtime.");
    }
}

