/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.api.java.summarize.StringColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.AggregateCombineHarness;
import org.apache.flink.api.java.summarize.aggregation.StringSummaryAggregatorTest;
import org.apache.flink.api.java.summarize.aggregation.ValueSummaryAggregator;
import org.apache.flink.types.StringValue;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;

class StringValueSummaryAggregatorTest
extends StringSummaryAggregatorTest {
    StringValueSummaryAggregatorTest() {
    }

    @Override
    protected StringColumnSummary summarize(String ... values) {
        StringValue[] stringValues = new StringValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            stringValues[i] = new StringValue((CharSequence)values[i]);
        }
        return (StringColumnSummary)new AggregateCombineHarness<StringValue, StringColumnSummary, ValueSummaryAggregator.StringValueSummaryAggregator>(){

            @Override
            protected void compareResults(StringColumnSummary result1, StringColumnSummary result2) {
                Assertions.assertThat((long)result2.getEmptyCount()).isEqualTo(result1.getEmptyCount());
                Assertions.assertThat((Integer)result2.getMaxLength()).isEqualTo((Object)result1.getMaxLength());
                Assertions.assertThat((Integer)result2.getMinLength()).isEqualTo((Object)result1.getMinLength());
                if (result1.getMeanLength() == null) {
                    Assertions.assertThat((Double)result2.getMeanLength()).isEqualTo(result1.getMeanLength());
                } else {
                    Assertions.assertThat((double)result2.getMeanLength()).isCloseTo(result1.getMeanLength().doubleValue(), Offset.offset((Number)1.0E-5));
                }
                Assertions.assertThat((long)result2.getNullCount()).isEqualTo(result1.getNullCount());
                Assertions.assertThat((long)result2.getNonNullCount()).isEqualTo(result1.getNonNullCount());
            }
        }.summarize(stringValues);
    }
}

