/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.api.java.summarize.StringColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.AggregateCombineHarness;
import org.apache.flink.api.java.summarize.aggregation.StringSummaryAggregator;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;

class StringSummaryAggregatorTest {
    StringSummaryAggregatorTest() {
    }

    @Test
    void testMixedGroup() {
        StringColumnSummary summary = this.summarize("abc", "", null, "  ", "defghi", "foo", null, null, "", " ");
        Assertions.assertThat((long)summary.getTotalCount()).isEqualTo(10L);
        Assertions.assertThat((long)summary.getNullCount()).isEqualTo(3L);
        Assertions.assertThat((long)summary.getNonNullCount()).isEqualTo(7L);
        Assertions.assertThat((long)summary.getEmptyCount()).isEqualTo(2L);
        Assertions.assertThat((int)summary.getMinLength()).isZero();
        Assertions.assertThat((int)summary.getMaxLength()).isEqualTo(6);
        Assertions.assertThat((double)summary.getMeanLength()).isCloseTo(2.142857, Offset.offset((Number)0.001));
    }

    @Test
    void testAllNullStrings() {
        StringColumnSummary summary = this.summarize(null, null, null, null);
        Assertions.assertThat((long)summary.getTotalCount()).isEqualTo(4L);
        Assertions.assertThat((long)summary.getNullCount()).isEqualTo(4L);
        Assertions.assertThat((long)summary.getNonNullCount()).isZero();
        Assertions.assertThat((long)summary.getEmptyCount()).isZero();
        Assertions.assertThat((Integer)summary.getMinLength()).isNull();
        Assertions.assertThat((Integer)summary.getMaxLength()).isNull();
        Assertions.assertThat((Double)summary.getMeanLength()).isNull();
    }

    @Test
    void testAllWithValues() {
        StringColumnSummary summary = this.summarize("cat", "hat", "dog", "frog");
        Assertions.assertThat((long)summary.getTotalCount()).isEqualTo(4L);
        Assertions.assertThat((long)summary.getNullCount()).isZero();
        Assertions.assertThat((long)summary.getNonNullCount()).isEqualTo(4L);
        Assertions.assertThat((long)summary.getEmptyCount()).isZero();
        Assertions.assertThat((int)summary.getMinLength()).isEqualTo(3);
        Assertions.assertThat((int)summary.getMaxLength()).isEqualTo(4);
        Assertions.assertThat((double)summary.getMeanLength()).isCloseTo(3.25, Offset.offset((Number)0.0));
    }

    protected StringColumnSummary summarize(String ... values) {
        return (StringColumnSummary)new AggregateCombineHarness<String, StringColumnSummary, StringSummaryAggregator>(){

            @Override
            protected void compareResults(StringColumnSummary result1, StringColumnSummary result2) {
                Assertions.assertThat((long)result2.getEmptyCount()).isEqualTo(result1.getEmptyCount());
                Assertions.assertThat((Integer)result2.getMaxLength()).isEqualTo((Object)result1.getMaxLength());
                Assertions.assertThat((Integer)result2.getMinLength()).isEqualTo((Object)result1.getMinLength());
                if (result1.getMeanLength() == null) {
                    Assertions.assertThat((Double)result2.getMeanLength()).isEqualTo(result1.getMeanLength());
                } else {
                    Assertions.assertThat((double)result2.getMeanLength()).isCloseTo(result1.getMeanLength().doubleValue(), Offset.offset((Number)1.0E-5));
                }
                Assertions.assertThat((long)result2.getNullCount()).isEqualTo(result1.getNullCount());
                Assertions.assertThat((long)result2.getNonNullCount()).isEqualTo(result1.getNonNullCount());
            }
        }.summarize(values);
    }
}

