/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.api.java.summarize.NumericColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.AggregateCombineHarness;
import org.apache.flink.api.java.summarize.aggregation.LongSummaryAggregatorTest;
import org.apache.flink.api.java.summarize.aggregation.ValueSummaryAggregator;
import org.apache.flink.types.LongValue;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;

class LongValueSummaryAggregatorTest
extends LongSummaryAggregatorTest {
    LongValueSummaryAggregatorTest() {
    }

    @Override
    protected NumericColumnSummary<Long> summarize(Long ... values) {
        LongValue[] longValues = new LongValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            longValues[i] = new LongValue(values[i].longValue());
        }
        return (NumericColumnSummary)new AggregateCombineHarness<LongValue, NumericColumnSummary<Long>, ValueSummaryAggregator.LongValueSummaryAggregator>(){

            @Override
            protected void compareResults(NumericColumnSummary<Long> result1, NumericColumnSummary<Long> result2) {
                Assertions.assertThat((long)result2.getTotalCount()).isEqualTo(result1.getTotalCount());
                Assertions.assertThat((long)result2.getNullCount()).isEqualTo(result1.getNullCount());
                Assertions.assertThat((long)result2.getMissingCount()).isEqualTo(result1.getMissingCount());
                Assertions.assertThat((long)result2.getNonMissingCount()).isEqualTo(result1.getNonMissingCount());
                Assertions.assertThat((long)result2.getInfinityCount()).isEqualTo(result1.getInfinityCount());
                Assertions.assertThat((long)result2.getNanCount()).isEqualTo(result1.getNanCount());
                Assertions.assertThat((boolean)result2.containsNull()).isEqualTo(result1.containsNull());
                Assertions.assertThat((boolean)result2.containsNonNull()).isEqualTo(result1.containsNonNull());
                Assertions.assertThat((long)((Long)result2.getMin())).isEqualTo(((Long)result1.getMin()).longValue());
                Assertions.assertThat((long)((Long)result2.getMax())).isEqualTo(((Long)result1.getMax()).longValue());
                Assertions.assertThat((long)((Long)result2.getSum())).isEqualTo(((Long)result1.getSum()).longValue());
                Assertions.assertThat((double)result2.getMean()).isCloseTo(result1.getMean().doubleValue(), Offset.offset((Number)1.0E-12));
                Assertions.assertThat((double)result2.getVariance()).isCloseTo(result1.getVariance().doubleValue(), Offset.offset((Number)1.0E-9));
                Assertions.assertThat((double)result2.getStandardDeviation()).isCloseTo(result1.getStandardDeviation().doubleValue(), Offset.offset((Number)1.0E-12));
            }
        }.summarize(longValues);
    }
}

