/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.api.java.summarize.BooleanColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.AggregateCombineHarness;
import org.apache.flink.api.java.summarize.aggregation.BooleanSummaryAggregatorTest;
import org.apache.flink.api.java.summarize.aggregation.ValueSummaryAggregator;
import org.apache.flink.types.BooleanValue;
import org.assertj.core.api.Assertions;

class BooleanValueSummaryAggregatorTest
extends BooleanSummaryAggregatorTest {
    BooleanValueSummaryAggregatorTest() {
    }

    @Override
    protected BooleanColumnSummary summarize(Boolean ... values) {
        BooleanValue[] booleanValues = new BooleanValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            booleanValues[i] = new BooleanValue(values[i].booleanValue());
        }
        return (BooleanColumnSummary)new AggregateCombineHarness<BooleanValue, BooleanColumnSummary, ValueSummaryAggregator.BooleanValueSummaryAggregator>(){

            @Override
            protected void compareResults(BooleanColumnSummary result1, BooleanColumnSummary result2) {
                Assertions.assertThat((long)result2.getNullCount()).isEqualTo(result1.getNullCount());
                Assertions.assertThat((long)result2.getNonNullCount()).isEqualTo(result1.getNonNullCount());
                Assertions.assertThat((long)result2.getTrueCount()).isEqualTo(result1.getTrueCount());
                Assertions.assertThat((long)result2.getFalseCount()).isEqualTo(result1.getFalseCount());
            }
        }.summarize(booleanValues);
    }
}

