/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.api.java.summarize.BooleanColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.AggregateCombineHarness;
import org.apache.flink.api.java.summarize.aggregation.BooleanSummaryAggregator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class BooleanSummaryAggregatorTest {
    BooleanSummaryAggregatorTest() {
    }

    @Test
    void testMixedGroup() {
        BooleanColumnSummary summary = this.summarize(true, false, null, true, true, true, false, null, true, false, true);
        Assertions.assertThat((long)summary.getTotalCount()).isEqualTo(11L);
        Assertions.assertThat((long)summary.getNullCount()).isEqualTo(2L);
        Assertions.assertThat((long)summary.getNonNullCount()).isEqualTo(9L);
        Assertions.assertThat((long)summary.getTrueCount()).isEqualTo(6L);
        Assertions.assertThat((long)summary.getFalseCount()).isEqualTo(3L);
    }

    @Test
    void testAllNullBooleans() {
        BooleanColumnSummary summary = this.summarize(null, null, null, null);
        Assertions.assertThat((long)summary.getTotalCount()).isEqualTo(4L);
        Assertions.assertThat((long)summary.getNullCount()).isEqualTo(4L);
        Assertions.assertThat((long)summary.getNonNullCount()).isZero();
        Assertions.assertThat((long)summary.getTrueCount()).isZero();
        Assertions.assertThat((long)summary.getFalseCount()).isZero();
    }

    @Test
    void testAllTrue() {
        BooleanColumnSummary summary = this.summarize(true, true, true, true, true, true);
        Assertions.assertThat((long)summary.getTotalCount()).isEqualTo(6L);
        Assertions.assertThat((long)summary.getNullCount()).isZero();
        Assertions.assertThat((long)summary.getNonNullCount()).isEqualTo(6L);
        Assertions.assertThat((long)summary.getTrueCount()).isEqualTo(6L);
        Assertions.assertThat((long)summary.getFalseCount()).isZero();
    }

    @Test
    void testAllFalse() {
        BooleanColumnSummary summary = this.summarize(false, false, false);
        Assertions.assertThat((long)summary.getTotalCount()).isEqualTo(3L);
        Assertions.assertThat((long)summary.getNullCount()).isZero();
        Assertions.assertThat((long)summary.getNonNullCount()).isEqualTo(3L);
        Assertions.assertThat((long)summary.getTrueCount()).isZero();
        Assertions.assertThat((long)summary.getFalseCount()).isEqualTo(3L);
    }

    protected BooleanColumnSummary summarize(Boolean ... values) {
        return (BooleanColumnSummary)new AggregateCombineHarness<Boolean, BooleanColumnSummary, BooleanSummaryAggregator>(){

            @Override
            protected void compareResults(BooleanColumnSummary result1, BooleanColumnSummary result2) {
                Assertions.assertThat((long)result2.getNullCount()).isEqualTo(result1.getNullCount());
                Assertions.assertThat((long)result2.getNonNullCount()).isEqualTo(result1.getNonNullCount());
                Assertions.assertThat((long)result2.getTrueCount()).isEqualTo(result1.getTrueCount());
                Assertions.assertThat((long)result2.getFalseCount()).isEqualTo(result1.getFalseCount());
            }
        }.summarize(values);
    }
}

