/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators.translation;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.common.operators.base.MapOperatorBase;
import org.apache.flink.api.common.operators.base.ReduceOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.LocalEnvironment;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DistinctOperator;
import org.apache.flink.api.java.operators.translation.KeyExtractingMapper;
import org.apache.flink.api.java.operators.translation.PlanUnwrappingReduceOperator;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.StringValue;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DistinctTranslationTest {
    DistinctTranslationTest() {
    }

    @Test
    void translateDistinctPlain() {
        try {
            int parallelism = 8;
            LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment((int)8);
            DataSet<Tuple3<Double, StringValue, LongValue>> initialData = DistinctTranslationTest.getSourceDataSet((ExecutionEnvironment)env);
            initialData.distinct().output((OutputFormat)new DiscardingOutputFormat());
            Plan p = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)p.getDataSinks().iterator().next();
            ReduceOperatorBase reducer = (ReduceOperatorBase)sink.getInput();
            Assertions.assertThat((Object)reducer.getOperatorInfo().getInputType()).isEqualTo((Object)initialData.getType());
            Assertions.assertThat((Object)reducer.getOperatorInfo().getOutputType()).isEqualTo((Object)initialData.getType());
            Assertions.assertThat((int[])reducer.getKeyColumns(0)).containsExactly(new int[]{0, 1, 2});
            Assertions.assertThat((int)reducer.getParallelism()).isIn(new Object[]{-1, 1});
            Assertions.assertThat((Object)reducer.getInput()).isInstanceOf(GenericDataSourceBase.class);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assertions.fail((String)("Test caused an error: " + e.getMessage()));
        }
    }

    @Test
    void translateDistinctPlain2() {
        try {
            int parallelism = 8;
            LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment((int)8);
            DataSet<CustomType> initialData = DistinctTranslationTest.getSourcePojoDataSet((ExecutionEnvironment)env);
            initialData.distinct().output((OutputFormat)new DiscardingOutputFormat());
            Plan p = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)p.getDataSinks().iterator().next();
            ReduceOperatorBase reducer = (ReduceOperatorBase)sink.getInput();
            Assertions.assertThat((Object)reducer.getOperatorInfo().getInputType()).isEqualTo((Object)initialData.getType());
            Assertions.assertThat((Object)reducer.getOperatorInfo().getOutputType()).isEqualTo((Object)initialData.getType());
            Assertions.assertThat((int[])reducer.getKeyColumns(0)).containsExactly(new int[]{0});
            Assertions.assertThat((int)reducer.getParallelism()).isIn(new Object[]{-1, 1});
            Assertions.assertThat((Object)reducer.getInput()).isInstanceOf(GenericDataSourceBase.class);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assertions.fail((String)("Test caused an error: " + e.getMessage()));
        }
    }

    @Test
    void translateDistinctPosition() {
        try {
            int parallelism = 8;
            LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment((int)8);
            DataSet<Tuple3<Double, StringValue, LongValue>> initialData = DistinctTranslationTest.getSourceDataSet((ExecutionEnvironment)env);
            initialData.distinct(new int[]{1, 2}).output((OutputFormat)new DiscardingOutputFormat());
            Plan p = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)p.getDataSinks().iterator().next();
            ReduceOperatorBase reducer = (ReduceOperatorBase)sink.getInput();
            Assertions.assertThat((Object)reducer.getOperatorInfo().getInputType()).isEqualTo((Object)initialData.getType());
            Assertions.assertThat((Object)reducer.getOperatorInfo().getOutputType()).isEqualTo((Object)initialData.getType());
            Assertions.assertThat((int[])reducer.getKeyColumns(0)).containsExactly(new int[]{1, 2});
            Assertions.assertThat((int)reducer.getParallelism()).isIn(new Object[]{-1, 1});
            Assertions.assertThat((Object)reducer.getInput()).isInstanceOf(GenericDataSourceBase.class);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assertions.fail((String)("Test caused an error: " + e.getMessage()));
        }
    }

    @Test
    void translateDistinctKeySelector() {
        try {
            int parallelism = 8;
            LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment((int)8);
            DataSet<Tuple3<Double, StringValue, LongValue>> initialData = DistinctTranslationTest.getSourceDataSet((ExecutionEnvironment)env);
            ((DistinctOperator)initialData.distinct((KeySelector & Serializable)value -> (StringValue)value.f1).setParallelism(4)).output((OutputFormat)new DiscardingOutputFormat());
            Plan p = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)p.getDataSinks().iterator().next();
            MapOperatorBase keyRemover = (MapOperatorBase)sink.getInput();
            PlanUnwrappingReduceOperator reducer = (PlanUnwrappingReduceOperator)keyRemover.getInput();
            MapOperatorBase keyExtractor = (MapOperatorBase)reducer.getInput();
            Assertions.assertThat((int)keyExtractor.getParallelism()).isOne();
            Assertions.assertThat((int)reducer.getParallelism()).isEqualTo(4);
            TupleTypeInfo keyValueInfo = new TupleTypeInfo(new TypeInformation[]{new ValueTypeInfo(StringValue.class), initialData.getType()});
            Assertions.assertThat((Object)keyExtractor.getOperatorInfo().getInputType()).isEqualTo((Object)initialData.getType());
            Assertions.assertThat((Object)keyExtractor.getOperatorInfo().getOutputType()).isEqualTo((Object)keyValueInfo);
            Assertions.assertThat((Object)reducer.getOperatorInfo().getInputType()).isEqualTo((Object)keyValueInfo);
            Assertions.assertThat((Object)reducer.getOperatorInfo().getOutputType()).isEqualTo((Object)keyValueInfo);
            Assertions.assertThat((Object)keyRemover.getOperatorInfo().getInputType()).isEqualTo((Object)keyValueInfo);
            Assertions.assertThat((Object)keyRemover.getOperatorInfo().getOutputType()).isEqualTo((Object)initialData.getType());
            Assertions.assertThat((Class)keyExtractor.getUserCodeWrapper().getUserCodeClass()).isEqualTo(KeyExtractingMapper.class);
            Assertions.assertThat((Object)keyExtractor.getInput()).isInstanceOf(GenericDataSourceBase.class);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assertions.fail((String)("Test caused an error: " + e.getMessage()));
        }
    }

    @Test
    void translateDistinctExpressionKey() {
        try {
            int parallelism = 8;
            LocalEnvironment env = ExecutionEnvironment.createLocalEnvironment((int)8);
            DataSet<CustomType> initialData = DistinctTranslationTest.getSourcePojoDataSet((ExecutionEnvironment)env);
            initialData.distinct(new String[]{"myInt"}).output((OutputFormat)new DiscardingOutputFormat());
            Plan p = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)p.getDataSinks().iterator().next();
            ReduceOperatorBase reducer = (ReduceOperatorBase)sink.getInput();
            Assertions.assertThat((Object)reducer.getOperatorInfo().getInputType()).isEqualTo((Object)initialData.getType());
            Assertions.assertThat((Object)reducer.getOperatorInfo().getOutputType()).isEqualTo((Object)initialData.getType());
            Assertions.assertThat((int[])reducer.getKeyColumns(0)).containsExactly(new int[]{0});
            Assertions.assertThat((int)reducer.getParallelism()).isIn(new Object[]{-1, 1});
            Assertions.assertThat((Object)reducer.getInput()).isInstanceOf(GenericDataSourceBase.class);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assertions.fail((String)("Test caused an error: " + e.getMessage()));
        }
    }

    private static DataSet<Tuple3<Double, StringValue, LongValue>> getSourceDataSet(ExecutionEnvironment env) {
        return env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3.141592, (Object)new StringValue((CharSequence)"foobar"), (Object)new LongValue(77L))}).setParallelism(1);
    }

    private static DataSet<CustomType> getSourcePojoDataSet(ExecutionEnvironment env) {
        ArrayList<CustomType> data = new ArrayList<CustomType>();
        data.add(new CustomType(1));
        return env.fromCollection(data);
    }

    public static class CustomType
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int myInt;

        public CustomType() {
        }

        public CustomType(int i) {
            this.myInt = i;
        }

        public String toString() {
            return "" + this.myInt;
        }
    }
}

