/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators.translation;

import java.io.Serializable;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.base.CoGroupOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.util.Collector;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CoGroupSortTranslationTest
implements Serializable {
    CoGroupSortTranslationTest() {
    }

    @Test
    void testGroupSortTuples() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource input1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)0L, (Object)0L)});
            DataSource input2 = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)0L, (Object)0L, (Object)0L)});
            input1.coGroup((DataSet)input2).where(new int[]{1}).equalTo(new int[]{2}).sortFirstGroup(0, Order.DESCENDING).sortSecondGroup(1, Order.ASCENDING).sortSecondGroup(0, Order.DESCENDING).with((CoGroupFunction)new CoGroupFunction<Tuple2<Long, Long>, Tuple3<Long, Long, Long>, Long>(){

                public void coGroup(Iterable<Tuple2<Long, Long>> first, Iterable<Tuple3<Long, Long, Long>> second, Collector<Long> out) throws Exception {
                }
            }).output((OutputFormat)new DiscardingOutputFormat());
            Plan p = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)p.getDataSinks().iterator().next();
            CoGroupOperatorBase coGroup = (CoGroupOperatorBase)sink.getInput();
            Assertions.assertThat((Object)coGroup.getGroupOrderForInputOne()).isNotNull();
            Assertions.assertThat((Object)coGroup.getGroupOrderForInputTwo()).isNotNull();
            Assertions.assertThat((int)coGroup.getGroupOrderForInputOne().getNumberOfFields()).isOne();
            Assertions.assertThat((int)coGroup.getGroupOrderForInputOne().getFieldNumber(0)).isZero();
            Assertions.assertThat((Comparable)coGroup.getGroupOrderForInputOne().getOrder(0)).isEqualTo((Object)Order.DESCENDING);
            Assertions.assertThat((int)coGroup.getGroupOrderForInputTwo().getNumberOfFields()).isEqualTo(2);
            Assertions.assertThat((int)coGroup.getGroupOrderForInputTwo().getFieldNumber(0)).isOne();
            Assertions.assertThat((int)coGroup.getGroupOrderForInputTwo().getFieldNumber(1)).isZero();
            Assertions.assertThat((Comparable)coGroup.getGroupOrderForInputTwo().getOrder(0)).isEqualTo((Object)Order.ASCENDING);
            Assertions.assertThat((Comparable)coGroup.getGroupOrderForInputTwo().getOrder(1)).isEqualTo((Object)Order.DESCENDING);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testSortTuplesAndPojos() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource input1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)0L, (Object)0L)});
            DataSource input2 = env.fromElements((Object[])new TestPoJo[]{new TestPoJo()});
            input1.coGroup((DataSet)input2).where(new int[]{1}).equalTo(new String[]{"b"}).sortFirstGroup(0, Order.DESCENDING).sortSecondGroup("c", Order.ASCENDING).sortSecondGroup("a", Order.DESCENDING).with((CoGroupFunction)new CoGroupFunction<Tuple2<Long, Long>, TestPoJo, Long>(){

                public void coGroup(Iterable<Tuple2<Long, Long>> first, Iterable<TestPoJo> second, Collector<Long> out) throws Exception {
                }
            }).output((OutputFormat)new DiscardingOutputFormat());
            Plan p = env.createProgramPlan();
            GenericDataSinkBase sink = (GenericDataSinkBase)p.getDataSinks().iterator().next();
            CoGroupOperatorBase coGroup = (CoGroupOperatorBase)sink.getInput();
            Assertions.assertThat((Object)coGroup.getGroupOrderForInputOne()).isNotNull();
            Assertions.assertThat((Object)coGroup.getGroupOrderForInputTwo()).isNotNull();
            Assertions.assertThat((int)coGroup.getGroupOrderForInputOne().getNumberOfFields()).isOne();
            Assertions.assertThat((int)coGroup.getGroupOrderForInputOne().getFieldNumber(0)).isZero();
            Assertions.assertThat((Comparable)coGroup.getGroupOrderForInputOne().getOrder(0)).isEqualTo((Object)Order.DESCENDING);
            Assertions.assertThat((int)coGroup.getGroupOrderForInputTwo().getNumberOfFields()).isEqualTo(2);
            Assertions.assertThat((int)coGroup.getGroupOrderForInputTwo().getFieldNumber(0)).isEqualTo(2);
            Assertions.assertThat((int)coGroup.getGroupOrderForInputTwo().getFieldNumber(1)).isZero();
            Assertions.assertThat((Comparable)coGroup.getGroupOrderForInputTwo().getOrder(0)).isEqualTo((Object)Order.ASCENDING);
            Assertions.assertThat((Comparable)coGroup.getGroupOrderForInputTwo().getOrder(1)).isEqualTo((Object)Order.DESCENDING);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    public static class TestPoJo {
        public long a;
        public long b;
        public long c;
    }
}

