/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.api.common.io.ParseException;
import org.apache.flink.api.common.io.compression.InflaterInputStreamFactory;
import org.apache.flink.api.java.io.CsvInputFormat;
import org.apache.flink.api.java.io.PojoCsvInputFormat;
import org.apache.flink.api.java.io.TextInputFormat;
import org.apache.flink.api.java.io.TupleCsvInputFormat;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.tuple.Tuple6;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.types.parser.FieldParser;
import org.apache.flink.types.parser.StringParser;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

class CsvInputFormatTest {
    private static final Path PATH = new Path("an/ignored/file/");
    private static final String FIRST_PART = "That is the first part";
    private static final String SECOND_PART = "That is the second part";

    CsvInputFormatTest() {
    }

    @Test
    void testSplitCsvInputStreamInLargeBuffer() throws Exception {
        this.testSplitCsvInputStream(0x100000, false, false);
        this.testSplitCsvInputStream(0x100000, false, true);
    }

    @Test
    void testSplitCsvInputStreamInSmallBuffer() throws Exception {
        this.testSplitCsvInputStream(2, false, false);
        this.testSplitCsvInputStream(0x100000, false, true);
    }

    private void testSplitCsvInputStream(int bufferSize, boolean failAtStart, boolean compressed) throws Exception {
        File tempFile;
        String fileContent = "this is|1|2.0|\na test|3|4.0|\n#next|5|6.0|\nasdadas|5|30.0|\n";
        if (compressed) {
            tempFile = File.createTempFile("TextInputFormatTest", ".compressed");
            TextInputFormat.registerInflaterInputStreamFactory((String)"compressed", (InflaterInputStreamFactory)new InflaterInputStreamFactory<InputStream>(){

                public InputStream create(InputStream in) {
                    return in;
                }

                public Collection<String> getCommonFileExtensions() {
                    return Collections.singletonList("compressed");
                }
            });
        } else {
            tempFile = File.createTempFile("input-stream-decoration-test", ".tmp");
        }
        tempFile.deleteOnExit();
        try (FileOutputStream fileOutputStream = new FileOutputStream(tempFile);){
            fileOutputStream.write("this is|1|2.0|\na test|3|4.0|\n#next|5|6.0|\nasdadas|5|30.0|\n".getBytes(ConfigConstants.DEFAULT_CHARSET));
        }
        int noOfBlocks = 3;
        TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{String.class, Integer.class, Double.class});
        TupleCsvInputFormat format = new TupleCsvInputFormat(new Path(tempFile.toURI()), "\n", "|", (TupleTypeInfoBase)typeInfo);
        format.setLenient(true);
        format.setBufferSize(bufferSize);
        Configuration config = new Configuration();
        format.configure(config);
        long[] offsetsAfterRecord = new long[]{15L, 29L, 42L, 58L};
        long[] offsetAtEndOfSplit = new long[]{20L, 40L, 58L};
        int recordCounter = 0;
        int splitCounter = 0;
        FileInputSplit[] inputSplits = format.createInputSplits(3);
        Tuple3 result = new Tuple3();
        for (FileInputSplit inputSplit : inputSplits) {
            if (!compressed) {
                Assertions.assertThat((long)offsetAtEndOfSplit[splitCounter]).isEqualTo(inputSplit.getStart() + inputSplit.getLength());
            }
            ++splitCounter;
            format.open(inputSplit);
            format.reopen(inputSplit, format.getCurrentState());
            while (!format.reachedEnd()) {
                if ((result = (Tuple3)format.nextRecord((Object)result)) != null) {
                    Assertions.assertThat((long)offsetsAfterRecord[recordCounter]).isEqualTo(format.getCurrentState().longValue());
                    if (++recordCounter == 1) {
                        Assertions.assertThat((String)((String)result.f0)).isEqualTo("this is");
                        Assertions.assertThat((Integer)((Integer)result.f1)).isOne();
                        Assertions.assertThat((Double)((Double)result.f2)).isEqualTo(new Double(2.0));
                        Assertions.assertThat((long)format.getCurrentState()).isEqualTo(15L);
                    } else if (recordCounter == 2) {
                        Assertions.assertThat((String)((String)result.f0)).isEqualTo("a test");
                        Assertions.assertThat((Integer)((Integer)result.f1)).isEqualTo((Object)3);
                        Assertions.assertThat((Double)((Double)result.f2)).isEqualTo(new Double(4.0));
                        Assertions.assertThat((long)format.getCurrentState()).isEqualTo(29L);
                    } else if (recordCounter == 3) {
                        Assertions.assertThat((String)((String)result.f0)).isEqualTo("#next");
                        Assertions.assertThat((Integer)((Integer)result.f1)).isEqualTo((Object)5);
                        Assertions.assertThat((Double)((Double)result.f2)).isEqualTo(new Double(6.0));
                        Assertions.assertThat((long)format.getCurrentState()).isEqualTo(42L);
                    } else {
                        Assertions.assertThat((String)((String)result.f0)).isEqualTo("asdadas");
                        Assertions.assertThat((Integer)((Integer)result.f1)).isEqualTo((Object)new Integer(5));
                        Assertions.assertThat((Double)((Double)result.f2)).isEqualTo(new Double(30.0));
                        Assertions.assertThat((long)format.getCurrentState()).isEqualTo(58L);
                    }
                    Long state = format.getCurrentState();
                    long offsetToRestore = state;
                    format = new TupleCsvInputFormat(new Path(tempFile.toURI()), "\n", "|", (TupleTypeInfoBase)typeInfo);
                    format.setLenient(true);
                    format.setBufferSize(bufferSize);
                    format.configure(config);
                    format.reopen(inputSplit, Long.valueOf(offsetToRestore));
                    continue;
                }
                result = new Tuple3();
            }
            format.close();
        }
        Assertions.assertThat((int)recordCounter).isEqualTo(4);
    }

    @Test
    void ignoreInvalidLinesAndGetOffsetInLargeBuffer() {
        this.ignoreInvalidLines(0x100000);
    }

    @Test
    void ignoreInvalidLinesAndGetOffsetInSmallBuffer() {
        this.ignoreInvalidLines(2);
    }

    private void ignoreInvalidLines(int bufferSize) {
        try {
            String fileContent = "#description of the data\nheader1|header2|header3|\nthis is|1|2.0|\n//a comment\na test|3|4.0|\n#next|5|6.0|\nasdasdas";
            FileInputSplit split = this.createTempFile("#description of the data\nheader1|header2|header3|\nthis is|1|2.0|\n//a comment\na test|3|4.0|\n#next|5|6.0|\nasdasdas");
            TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{String.class, Integer.class, Double.class});
            TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, "\n", "|", (TupleTypeInfoBase)typeInfo);
            format.setLenient(true);
            format.setBufferSize(bufferSize);
            Configuration parameters = new Configuration();
            format.configure(parameters);
            format.open(split);
            Tuple3 result = new Tuple3();
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((String)((String)result.f0)).isEqualTo("this is");
            Assertions.assertThat((Integer)((Integer)result.f1)).isOne();
            Assertions.assertThat((Double)((Double)result.f2)).isEqualTo(new Double(2.0));
            Assertions.assertThat((long)format.getCurrentState()).isEqualTo(65L);
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((String)((String)result.f0)).isEqualTo("a test");
            Assertions.assertThat((Integer)((Integer)result.f1)).isEqualTo((Object)3);
            Assertions.assertThat((Double)((Double)result.f2)).isEqualTo(new Double(4.0));
            Assertions.assertThat((long)format.getCurrentState()).isEqualTo(91L);
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((String)((String)result.f0)).isEqualTo("#next");
            Assertions.assertThat((Integer)((Integer)result.f1)).isEqualTo((Object)5);
            Assertions.assertThat((Double)((Double)result.f2)).isEqualTo(new Double(6.0));
            Assertions.assertThat((long)format.getCurrentState()).isEqualTo(104L);
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((Object)result).isNull();
            Assertions.assertThat((long)format.getCurrentState()).isEqualTo((long)"#description of the data\nheader1|header2|header3|\nthis is|1|2.0|\n//a comment\na test|3|4.0|\n#next|5|6.0|\nasdasdas".length());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assertions.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    void ignoreSingleCharPrefixComments() {
        try {
            String fileContent = "#description of the data\n#successive commented line\nthis is|1|2.0|\na test|3|4.0|\n#next|5|6.0|\n";
            FileInputSplit split = this.createTempFile("#description of the data\n#successive commented line\nthis is|1|2.0|\na test|3|4.0|\n#next|5|6.0|\n");
            TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{String.class, Integer.class, Double.class});
            TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, "\n", "|", (TupleTypeInfoBase)typeInfo);
            format.setCommentPrefix("#");
            Configuration parameters = new Configuration();
            format.configure(parameters);
            format.open(split);
            Tuple3 result = new Tuple3();
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((String)((String)result.f0)).isEqualTo("this is");
            Assertions.assertThat((Integer)((Integer)result.f1)).isOne();
            Assertions.assertThat((Double)((Double)result.f2)).isEqualTo(new Double(2.0));
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((String)((String)result.f0)).isEqualTo("a test");
            Assertions.assertThat((Integer)((Integer)result.f1)).isEqualTo((Object)3);
            Assertions.assertThat((Double)((Double)result.f2)).isEqualTo(new Double(4.0));
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((Object)result).isNull();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assertions.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    void ignoreMultiCharPrefixComments() {
        try {
            String fileContent = "//description of the data\n//successive commented line\nthis is|1|2.0|\na test|3|4.0|\n//next|5|6.0|\n";
            FileInputSplit split = this.createTempFile("//description of the data\n//successive commented line\nthis is|1|2.0|\na test|3|4.0|\n//next|5|6.0|\n");
            TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{String.class, Integer.class, Double.class});
            TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, "\n", "|", (TupleTypeInfoBase)typeInfo);
            format.setCommentPrefix("//");
            Configuration parameters = new Configuration();
            format.configure(parameters);
            format.open(split);
            Tuple3 result = new Tuple3();
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((String)((String)result.f0)).isEqualTo("this is");
            Assertions.assertThat((Integer)((Integer)result.f1)).isOne();
            Assertions.assertThat((Double)((Double)result.f2)).isEqualTo(new Double(2.0));
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((String)((String)result.f0)).isEqualTo("a test");
            Assertions.assertThat((Integer)((Integer)result.f1)).isEqualTo((Object)3);
            Assertions.assertThat((Double)((Double)result.f2)).isEqualTo(new Double(4.0));
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((Object)result).isNull();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assertions.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    void readStringFields() {
        try {
            String fileContent = "abc|def|ghijk\nabc||hhg\n|||";
            FileInputSplit split = this.createTempFile("abc|def|ghijk\nabc||hhg\n|||");
            TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{String.class, String.class, String.class});
            TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, "\n", "|", (TupleTypeInfoBase)typeInfo);
            Configuration parameters = new Configuration();
            format.configure(parameters);
            format.open(split);
            Tuple3 result = new Tuple3();
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((String)((String)result.f0)).isEqualTo("abc");
            Assertions.assertThat((String)((String)result.f1)).isEqualTo("def");
            Assertions.assertThat((String)((String)result.f2)).isEqualTo("ghijk");
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((String)((String)result.f0)).isEqualTo("abc");
            Assertions.assertThat((String)((String)result.f1)).isEmpty();
            Assertions.assertThat((String)((String)result.f2)).isEqualTo("hhg");
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((String)((String)result.f0)).isEmpty();
            Assertions.assertThat((String)((String)result.f1)).isEmpty();
            Assertions.assertThat((String)((String)result.f2)).isEmpty();
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((Object)result).isNull();
            Assertions.assertThat((boolean)format.reachedEnd()).isTrue();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assertions.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    void readMixedQuotedStringFields() {
        try {
            String fileContent = "@a|b|c@|def|@ghijk@\nabc||@|hhg@\n|||";
            FileInputSplit split = this.createTempFile("@a|b|c@|def|@ghijk@\nabc||@|hhg@\n|||");
            TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{String.class, String.class, String.class});
            TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, "\n", "|", (TupleTypeInfoBase)typeInfo);
            Configuration parameters = new Configuration();
            format.enableQuotedStringParsing('@');
            format.configure(parameters);
            format.open(split);
            Tuple3 result = new Tuple3();
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((String)((String)result.f0)).isEqualTo("a|b|c");
            Assertions.assertThat((String)((String)result.f1)).isEqualTo("def");
            Assertions.assertThat((String)((String)result.f2)).isEqualTo("ghijk");
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((String)((String)result.f0)).isEqualTo("abc");
            Assertions.assertThat((String)((String)result.f1)).isEmpty();
            Assertions.assertThat((String)((String)result.f2)).isEqualTo("|hhg");
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((String)((String)result.f0)).isEmpty();
            Assertions.assertThat((String)((String)result.f1)).isEmpty();
            Assertions.assertThat((String)((String)result.f2)).isEmpty();
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((Object)result).isNull();
            Assertions.assertThat((boolean)format.reachedEnd()).isTrue();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assertions.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    void readStringFieldsWithTrailingDelimiters() {
        try {
            String fileContent = "abc|-def|-ghijk\nabc|-|-hhg\n|-|-|-\n";
            FileInputSplit split = this.createTempFile("abc|-def|-ghijk\nabc|-|-hhg\n|-|-|-\n");
            TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{String.class, String.class, String.class});
            TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, (TupleTypeInfoBase)typeInfo);
            format.setFieldDelimiter("|-");
            format.configure(new Configuration());
            format.open(split);
            Tuple3 result = new Tuple3();
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((String)((String)result.f0)).isEqualTo("abc");
            Assertions.assertThat((String)((String)result.f1)).isEqualTo("def");
            Assertions.assertThat((String)((String)result.f2)).isEqualTo("ghijk");
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((String)((String)result.f0)).isEqualTo("abc");
            Assertions.assertThat((String)((String)result.f1)).isEmpty();
            Assertions.assertThat((String)((String)result.f2)).isEqualTo("hhg");
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((String)((String)result.f0)).isEmpty();
            Assertions.assertThat((String)((String)result.f1)).isEmpty();
            Assertions.assertThat((String)((String)result.f2)).isEmpty();
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((Object)result).isNull();
            Assertions.assertThat((boolean)format.reachedEnd()).isTrue();
        }
        catch (Exception ex) {
            Assertions.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    void testTailingEmptyFields() throws Exception {
        String fileContent = "aa,bb,cc\naa,bb,\naa,,\n,,\naa,bb";
        FileInputSplit split = this.createTempFile("aa,bb,cc\naa,bb,\naa,,\n,,\naa,bb");
        TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{String.class, String.class, String.class});
        TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, (TupleTypeInfoBase)typeInfo);
        format.setFieldDelimiter(",");
        format.configure(new Configuration());
        format.open(split);
        Tuple3 result = new Tuple3();
        result = (Tuple3)format.nextRecord((Object)result);
        Assertions.assertThat((String)((String)result.f0)).isEqualTo("aa");
        Assertions.assertThat((String)((String)result.f1)).isEqualTo("bb");
        Assertions.assertThat((String)((String)result.f2)).isEqualTo("cc");
        result = (Tuple3)format.nextRecord((Object)result);
        Assertions.assertThat((String)((String)result.f0)).isEqualTo("aa");
        Assertions.assertThat((String)((String)result.f1)).isEqualTo("bb");
        Assertions.assertThat((String)((String)result.f2)).isEmpty();
        result = (Tuple3)format.nextRecord((Object)result);
        Assertions.assertThat((String)((String)result.f0)).isEqualTo("aa");
        Assertions.assertThat((String)((String)result.f1)).isEmpty();
        Assertions.assertThat((String)((String)result.f2)).isEmpty();
        result = (Tuple3)format.nextRecord((Object)result);
        Assertions.assertThat((String)((String)result.f0)).isEmpty();
        Assertions.assertThat((String)((String)result.f1)).isEmpty();
        Assertions.assertThat((String)((String)result.f2)).isEmpty();
        try {
            format.nextRecord((Object)result);
            Assertions.fail((String)"Parse Exception was not thrown! (Row too short)");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Test
    void testIntegerFields() {
        try {
            String fileContent = "111|222|333|444|555\n666|777|888|999|000|\n";
            FileInputSplit split = this.createTempFile("111|222|333|444|555\n666|777|888|999|000|\n");
            TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{Integer.class, Integer.class, Integer.class, Integer.class, Integer.class});
            TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, (TupleTypeInfoBase)typeInfo);
            format.setFieldDelimiter("|");
            format.configure(new Configuration());
            format.open(split);
            Tuple5 result = new Tuple5();
            result = (Tuple5)format.nextRecord((Object)result);
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((Integer)((Integer)result.f0)).isEqualTo((Object)111);
            Assertions.assertThat((Integer)((Integer)result.f1)).isEqualTo((Object)222);
            Assertions.assertThat((Integer)((Integer)result.f2)).isEqualTo((Object)333);
            Assertions.assertThat((Integer)((Integer)result.f3)).isEqualTo((Object)444);
            Assertions.assertThat((Integer)((Integer)result.f4)).isEqualTo((Object)555);
            result = (Tuple5)format.nextRecord((Object)result);
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((Integer)((Integer)result.f0)).isEqualTo((Object)666);
            Assertions.assertThat((Integer)((Integer)result.f1)).isEqualTo((Object)777);
            Assertions.assertThat((Integer)((Integer)result.f2)).isEqualTo((Object)888);
            Assertions.assertThat((Integer)((Integer)result.f3)).isEqualTo((Object)999);
            Assertions.assertThat((Integer)((Integer)result.f4)).isEqualTo((Object)0);
            result = (Tuple5)format.nextRecord((Object)result);
            Assertions.assertThat((Object)result).isNull();
            Assertions.assertThat((boolean)format.reachedEnd()).isTrue();
        }
        catch (Exception ex) {
            Assertions.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    void testEmptyFields() {
        try {
            String fileContent = "|0|0|0|0|0|\n1||1|1|1|1|\n2|2||2|2|2|\n3|3|3| |3|3|\n4|4|4|4||4|\n5|5|5|5|5||\n";
            FileInputSplit split = this.createTempFile("|0|0|0|0|0|\n1||1|1|1|1|\n2|2||2|2|2|\n3|3|3| |3|3|\n4|4|4|4||4|\n5|5|5|5|5||\n");
            TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{Short.class, Integer.class, Long.class, Float.class, Double.class, Byte.class});
            TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, (TupleTypeInfoBase)typeInfo);
            format.setFieldDelimiter("|");
            format.configure(new Configuration());
            format.open(split);
            Tuple6 result = new Tuple6();
            try {
                result = (Tuple6)format.nextRecord((Object)result);
                Assertions.fail((String)"Empty String Parse Exception was not thrown! (ShortParser)");
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            try {
                result = (Tuple6)format.nextRecord((Object)result);
                Assertions.fail((String)"Empty String Parse Exception was not thrown! (IntegerParser)");
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            try {
                result = (Tuple6)format.nextRecord((Object)result);
                Assertions.fail((String)"Empty String Parse Exception was not thrown! (LongParser)");
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            try {
                result = (Tuple6)format.nextRecord((Object)result);
                Assertions.fail((String)"Empty String Parse Exception was not thrown! (FloatParser)");
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            try {
                result = (Tuple6)format.nextRecord((Object)result);
                Assertions.fail((String)"Empty String Parse Exception was not thrown! (DoubleParser)");
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            try {
                result = (Tuple6)format.nextRecord((Object)result);
                Assertions.fail((String)"Empty String Parse Exception was not thrown! (ByteParser)");
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            result = (Tuple6)format.nextRecord((Object)result);
            Assertions.assertThat((Object)result).isNull();
            Assertions.assertThat((boolean)format.reachedEnd()).isTrue();
        }
        catch (Exception ex) {
            Assertions.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    void testDoubleFields() {
        try {
            String fileContent = "11.1|22.2|33.3|44.4|55.5\n66.6|77.7|88.8|99.9|00.0|\n";
            FileInputSplit split = this.createTempFile("11.1|22.2|33.3|44.4|55.5\n66.6|77.7|88.8|99.9|00.0|\n");
            TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{Double.class, Double.class, Double.class, Double.class, Double.class});
            TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, (TupleTypeInfoBase)typeInfo);
            format.setFieldDelimiter("|");
            format.configure(new Configuration());
            format.open(split);
            Tuple5 result = new Tuple5();
            result = (Tuple5)format.nextRecord((Object)result);
            Assertions.assertThat((Double)((Double)result.f0)).isEqualTo(Double.valueOf(11.1));
            Assertions.assertThat((Double)((Double)result.f1)).isEqualTo(Double.valueOf(22.2));
            Assertions.assertThat((Double)((Double)result.f2)).isEqualTo(Double.valueOf(33.3));
            Assertions.assertThat((Double)((Double)result.f3)).isEqualTo(Double.valueOf(44.4));
            Assertions.assertThat((Double)((Double)result.f4)).isEqualTo(Double.valueOf(55.5));
            result = (Tuple5)format.nextRecord((Object)result);
            Assertions.assertThat((Double)((Double)result.f0)).isEqualTo(Double.valueOf(66.6));
            Assertions.assertThat((Double)((Double)result.f1)).isEqualTo(Double.valueOf(77.7));
            Assertions.assertThat((Double)((Double)result.f2)).isEqualTo(Double.valueOf(88.8));
            Assertions.assertThat((Double)((Double)result.f3)).isEqualTo(Double.valueOf(99.9));
            Assertions.assertThat((Double)((Double)result.f4)).isEqualTo(Double.valueOf(0.0));
            result = (Tuple5)format.nextRecord((Object)result);
            Assertions.assertThat((Object)result).isNull();
            Assertions.assertThat((boolean)format.reachedEnd()).isTrue();
        }
        catch (Exception ex) {
            Assertions.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    void testReadFirstN() {
        try {
            String fileContent = "111|222|333|444|555|\n666|777|888|999|000|\n";
            FileInputSplit split = this.createTempFile("111|222|333|444|555|\n666|777|888|999|000|\n");
            TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{Integer.class, Integer.class});
            TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, (TupleTypeInfoBase)typeInfo);
            format.setFieldDelimiter("|");
            format.configure(new Configuration());
            format.open(split);
            Tuple2 result = new Tuple2();
            result = (Tuple2)format.nextRecord((Object)result);
            Assertions.assertThat((Integer)((Integer)result.f0)).isEqualTo((Object)111);
            Assertions.assertThat((Integer)((Integer)result.f1)).isEqualTo((Object)222);
            result = (Tuple2)format.nextRecord((Object)result);
            Assertions.assertThat((Integer)((Integer)result.f0)).isEqualTo((Object)666);
            Assertions.assertThat((Integer)((Integer)result.f1)).isEqualTo((Object)777);
            result = (Tuple2)format.nextRecord((Object)result);
            Assertions.assertThat((Object)result).isNull();
            Assertions.assertThat((boolean)format.reachedEnd()).isTrue();
        }
        catch (Exception ex) {
            Assertions.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    void testReadSparseWithNullFieldsForTypes() {
        try {
            String fileContent = "111|x|222|x|333|x|444|x|555|x|666|x|777|x|888|x|999|x|000|x|\n000|x|999|x|888|x|777|x|666|x|555|x|444|x|333|x|222|x|111|x|";
            FileInputSplit split = this.createTempFile("111|x|222|x|333|x|444|x|555|x|666|x|777|x|888|x|999|x|000|x|\n000|x|999|x|888|x|777|x|666|x|555|x|444|x|333|x|222|x|111|x|");
            TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{Integer.class, Integer.class, Integer.class});
            TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, (TupleTypeInfoBase)typeInfo, new boolean[]{true, false, false, true, false, false, false, true});
            format.setFieldDelimiter("|x|");
            format.configure(new Configuration());
            format.open(split);
            Tuple3 result = new Tuple3();
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((Integer)((Integer)result.f0)).isEqualTo((Object)111);
            Assertions.assertThat((Integer)((Integer)result.f1)).isEqualTo((Object)444);
            Assertions.assertThat((Integer)((Integer)result.f2)).isEqualTo((Object)888);
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((Integer)((Integer)result.f0)).isEqualTo((Object)0);
            Assertions.assertThat((Integer)((Integer)result.f1)).isEqualTo((Object)777);
            Assertions.assertThat((Integer)((Integer)result.f2)).isEqualTo((Object)333);
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((Object)result).isNull();
            Assertions.assertThat((boolean)format.reachedEnd()).isTrue();
        }
        catch (Exception ex) {
            Assertions.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    void testReadSparseWithPositionSetter() {
        try {
            String fileContent = "111|222|333|444|555|666|777|888|999|000|\n000|999|888|777|666|555|444|333|222|111|";
            FileInputSplit split = this.createTempFile("111|222|333|444|555|666|777|888|999|000|\n000|999|888|777|666|555|444|333|222|111|");
            TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{Integer.class, Integer.class, Integer.class});
            TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, (TupleTypeInfoBase)typeInfo, new int[]{0, 3, 7});
            format.setFieldDelimiter("|");
            format.configure(new Configuration());
            format.open(split);
            Tuple3 result = new Tuple3();
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((Integer)((Integer)result.f0)).isEqualTo((Object)111);
            Assertions.assertThat((Integer)((Integer)result.f1)).isEqualTo((Object)444);
            Assertions.assertThat((Integer)((Integer)result.f2)).isEqualTo((Object)888);
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((Integer)((Integer)result.f0)).isEqualTo((Object)0);
            Assertions.assertThat((Integer)((Integer)result.f1)).isEqualTo((Object)777);
            Assertions.assertThat((Integer)((Integer)result.f2)).isEqualTo((Object)333);
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((Object)result).isNull();
            Assertions.assertThat((boolean)format.reachedEnd()).isTrue();
        }
        catch (Exception ex) {
            Assertions.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    void testReadSparseWithMask() {
        try {
            String fileContent = "111&&222&&333&&444&&555&&666&&777&&888&&999&&000&&\n000&&999&&888&&777&&666&&555&&444&&333&&222&&111&&";
            FileInputSplit split = this.createTempFile("111&&222&&333&&444&&555&&666&&777&&888&&999&&000&&\n000&&999&&888&&777&&666&&555&&444&&333&&222&&111&&");
            TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{Integer.class, Integer.class, Integer.class});
            TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, (TupleTypeInfoBase)typeInfo, new boolean[]{true, false, false, true, false, false, false, true});
            format.setFieldDelimiter("&&");
            format.configure(new Configuration());
            format.open(split);
            Tuple3 result = new Tuple3();
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((Integer)((Integer)result.f0)).isEqualTo((Object)111);
            Assertions.assertThat((Integer)((Integer)result.f1)).isEqualTo((Object)444);
            Assertions.assertThat((Integer)((Integer)result.f2)).isEqualTo((Object)888);
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((Integer)((Integer)result.f0)).isEqualTo((Object)0);
            Assertions.assertThat((Integer)((Integer)result.f1)).isEqualTo((Object)777);
            Assertions.assertThat((Integer)((Integer)result.f2)).isEqualTo((Object)333);
            result = (Tuple3)format.nextRecord((Object)result);
            Assertions.assertThat((Object)result).isNull();
            Assertions.assertThat((boolean)format.reachedEnd()).isTrue();
        }
        catch (Exception ex) {
            Assertions.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    @Test
    void testParseStringErrors() {
        Object[][] failures;
        StringParser stringParser = new StringParser();
        stringParser.enableQuotedStringParsing((byte)34);
        for (Object[] failure : failures = new Object[][]{{"\"string\" trailing", FieldParser.ParseErrorState.UNQUOTED_CHARS_AFTER_QUOTED_STRING}, {"\"unterminated ", FieldParser.ParseErrorState.UNTERMINATED_QUOTED_STRING}}) {
            String input = (String)failure[0];
            int result = stringParser.parseField(input.getBytes(ConfigConstants.DEFAULT_CHARSET), 0, input.length(), new byte[]{124}, null);
            Assertions.assertThat((int)result).isEqualTo(-1);
            Assertions.assertThat((Comparable)stringParser.getErrorState()).isSameAs(failure[1]);
        }
    }

    @Disabled(value="Test disabled because we do not support double-quote escaped quotes right now.")
    @Test
    void testParserCorrectness() throws Exception {
        String fileContent = "Year,Make,Model,Description,Price\n1997,Ford,E350,\"ac, abs, moon\",3000.00\n1999,Chevy,\"Venture \"\"Extended Edition\"\"\",\"\",4900.00\n1996,Jeep,Grand Cherokee,\"MUST SELL! air, moon roof, loaded\",4799.00\n1999,Chevy,\"Venture \"\"Extended Edition, Very Large\"\"\",,5000.00\n,,\"Venture \"\"Extended Edition\"\"\",\"\",4900.00";
        FileInputSplit split = this.createTempFile("Year,Make,Model,Description,Price\n1997,Ford,E350,\"ac, abs, moon\",3000.00\n1999,Chevy,\"Venture \"\"Extended Edition\"\"\",\"\",4900.00\n1996,Jeep,Grand Cherokee,\"MUST SELL! air, moon roof, loaded\",4799.00\n1999,Chevy,\"Venture \"\"Extended Edition, Very Large\"\"\",,5000.00\n,,\"Venture \"\"Extended Edition\"\"\",\"\",4900.00");
        TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{Integer.class, String.class, String.class, String.class, Double.class});
        TupleCsvInputFormat format = new TupleCsvInputFormat(PATH, (TupleTypeInfoBase)typeInfo);
        format.setSkipFirstLineAsHeader(true);
        format.setFieldDelimiter(",");
        format.configure(new Configuration());
        format.open(split);
        Tuple5 result = new Tuple5();
        Tuple5[] expectedLines = new Tuple5[]{new Tuple5((Object)1997, (Object)"Ford", (Object)"E350", (Object)"ac, abs, moon", (Object)3000.0), new Tuple5((Object)1999, (Object)"Chevy", (Object)"Venture \"Extended Edition\"", (Object)"", (Object)4900.0), new Tuple5((Object)1996, (Object)"Jeep", (Object)"Grand Cherokee", (Object)"MUST SELL! air, moon roof, loaded", (Object)4799.0), new Tuple5((Object)1999, (Object)"Chevy", (Object)"Venture \"Extended Edition, Very Large\"", (Object)"", (Object)5000.0), new Tuple5((Object)0, (Object)"", (Object)"Venture \"Extended Edition\"", (Object)"", (Object)4900.0)};
        try {
            for (Tuple5 expected : expectedLines) {
                result = (Tuple5)format.nextRecord((Object)result);
                Assertions.assertThat((Object)result).isEqualTo((Object)expected);
            }
            Assertions.assertThat((Object)format.nextRecord((Object)result)).isNull();
            Assertions.assertThat((boolean)format.reachedEnd()).isTrue();
        }
        catch (Exception ex) {
            Assertions.fail((String)("Test failed due to a " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    private FileInputSplit createTempFile(String content) throws IOException {
        File tempFile = File.createTempFile("test_contents", "tmp");
        tempFile.deleteOnExit();
        OutputStreamWriter wrt = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), StandardCharsets.UTF_8);
        wrt.write(content);
        wrt.close();
        return new FileInputSplit(0, new Path(tempFile.toURI().toString()), 0L, tempFile.length(), new String[]{"localhost"});
    }

    @Test
    void testWindowsLineEndRemoval() {
        this.testRemovingTrailingCR("\n", "\n");
        this.testRemovingTrailingCR("\r\n", "\r\n");
        this.testRemovingTrailingCR("\r\n", "\n");
    }

    private void testRemovingTrailingCR(String lineBreakerInFile, String lineBreakerSetup) {
        File tempFile = null;
        String fileContent = FIRST_PART + lineBreakerInFile + SECOND_PART + lineBreakerInFile;
        try {
            tempFile = File.createTempFile("CsvInputFormatTest", "tmp");
            tempFile.deleteOnExit();
            tempFile.setWritable(true);
            OutputStreamWriter wrt = new OutputStreamWriter(new FileOutputStream(tempFile));
            wrt.write(fileContent);
            wrt.close();
            TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{String.class});
            TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(new Path(tempFile.toURI().toString()), (TupleTypeInfoBase)typeInfo);
            Configuration parameters = new Configuration();
            inputFormat.configure(parameters);
            inputFormat.setDelimiter(lineBreakerSetup);
            FileInputSplit[] splits = inputFormat.createInputSplits(1);
            inputFormat.open(splits[0]);
            Tuple1 result = (Tuple1)inputFormat.nextRecord((Object)new Tuple1());
            ((ObjectAssert)Assertions.assertThat((Object)result).as("Expecting to not return null", new Object[0])).isNotNull();
            Assertions.assertThat((String)((String)result.f0)).isEqualTo(FIRST_PART);
            result = (Tuple1)inputFormat.nextRecord((Object)result);
            ((ObjectAssert)Assertions.assertThat((Object)result).as("Expecting to not return null", new Object[0])).isNotNull();
            Assertions.assertThat((String)((String)result.f0)).isEqualTo(SECOND_PART);
        }
        catch (Throwable t) {
            System.err.println("test failed with exception: " + t.getMessage());
            t.printStackTrace(System.err);
            Assertions.fail((String)"Test erroneous");
        }
    }

    private void validatePojoItem(CsvInputFormat<PojoItem> format) throws Exception {
        PojoItem item = new PojoItem();
        format.nextRecord((Object)item);
        Assertions.assertThat((int)item.field1).isEqualTo(123);
        Assertions.assertThat((String)item.field2).isEqualTo("AAA");
        Assertions.assertThat((Double)item.field3).isEqualTo(Double.valueOf(3.123));
        Assertions.assertThat((String)item.field4).isEqualTo("BBB");
        format.nextRecord((Object)item);
        Assertions.assertThat((int)item.field1).isEqualTo(456);
        Assertions.assertThat((String)item.field2).isEqualTo("BBB");
        Assertions.assertThat((Double)item.field3).isEqualTo(Double.valueOf(1.123));
        Assertions.assertThat((String)item.field4).isEqualTo("AAA");
    }

    @Test
    void testPojoType() throws Exception {
        File tempFile = File.createTempFile("CsvReaderPojoType", "tmp");
        tempFile.deleteOnExit();
        tempFile.setWritable(true);
        OutputStreamWriter wrt = new OutputStreamWriter(new FileOutputStream(tempFile));
        wrt.write("123,AAA,3.123,BBB\n");
        wrt.write("456,BBB,1.123,AAA\n");
        wrt.close();
        PojoTypeInfo typeInfo = (PojoTypeInfo)TypeExtractor.createTypeInfo(PojoItem.class);
        PojoCsvInputFormat inputFormat = new PojoCsvInputFormat(new Path(tempFile.toURI().toString()), typeInfo);
        inputFormat.configure(new Configuration());
        FileInputSplit[] splits = inputFormat.createInputSplits(1);
        inputFormat.open(splits[0]);
        this.validatePojoItem((CsvInputFormat<PojoItem>)inputFormat);
    }

    @Test
    void testPojoTypeWithPrivateField() throws Exception {
        File tempFile = File.createTempFile("CsvReaderPojoType", "tmp");
        tempFile.deleteOnExit();
        tempFile.setWritable(true);
        OutputStreamWriter wrt = new OutputStreamWriter(new FileOutputStream(tempFile));
        wrt.write("123,AAA,3.123,BBB\n");
        wrt.write("456,BBB,1.123,AAA\n");
        wrt.close();
        PojoTypeInfo typeInfo = (PojoTypeInfo)TypeExtractor.createTypeInfo(PrivatePojoItem.class);
        PojoCsvInputFormat inputFormat = new PojoCsvInputFormat(new Path(tempFile.toURI().toString()), typeInfo);
        inputFormat.configure(new Configuration());
        FileInputSplit[] splits = inputFormat.createInputSplits(1);
        inputFormat.open(splits[0]);
        PrivatePojoItem item = new PrivatePojoItem();
        inputFormat.nextRecord((Object)item);
        Assertions.assertThat((int)item.field1).isEqualTo(123);
        Assertions.assertThat((String)item.field2).isEqualTo("AAA");
        Assertions.assertThat((Double)item.field3).isEqualTo(Double.valueOf(3.123));
        Assertions.assertThat((String)item.field4).isEqualTo("BBB");
        inputFormat.nextRecord((Object)item);
        Assertions.assertThat((int)item.field1).isEqualTo(456);
        Assertions.assertThat((String)item.field2).isEqualTo("BBB");
        Assertions.assertThat((Double)item.field3).isEqualTo(Double.valueOf(1.123));
        Assertions.assertThat((String)item.field4).isEqualTo("AAA");
    }

    @Test
    void testPojoTypeWithTrailingEmptyFields() throws Exception {
        String fileContent = "123,,3.123,,\n456,BBB,3.23,,";
        FileInputSplit split = this.createTempFile("123,,3.123,,\n456,BBB,3.23,,");
        PojoTypeInfo typeInfo = (PojoTypeInfo)TypeExtractor.createTypeInfo(PrivatePojoItem.class);
        PojoCsvInputFormat inputFormat = new PojoCsvInputFormat(PATH, typeInfo);
        inputFormat.configure(new Configuration());
        inputFormat.open(split);
        PrivatePojoItem item = new PrivatePojoItem();
        inputFormat.nextRecord((Object)item);
        Assertions.assertThat((int)item.field1).isEqualTo(123);
        Assertions.assertThat((String)item.field2).isEmpty();
        Assertions.assertThat((Double)item.field3).isEqualTo(Double.valueOf(3.123));
        Assertions.assertThat((String)item.field4).isEmpty();
        inputFormat.nextRecord((Object)item);
        Assertions.assertThat((int)item.field1).isEqualTo(456);
        Assertions.assertThat((String)item.field2).isEqualTo("BBB");
        Assertions.assertThat((Double)item.field3).isEqualTo(Double.valueOf(3.23));
        Assertions.assertThat((String)item.field4).isEmpty();
    }

    @Test
    void testPojoTypeWithMappingInformation() throws Exception {
        File tempFile = File.createTempFile("CsvReaderPojoType", "tmp");
        tempFile.deleteOnExit();
        tempFile.setWritable(true);
        OutputStreamWriter wrt = new OutputStreamWriter(new FileOutputStream(tempFile));
        wrt.write("123,3.123,AAA,BBB\n");
        wrt.write("456,1.123,BBB,AAA\n");
        wrt.close();
        PojoTypeInfo typeInfo = (PojoTypeInfo)TypeExtractor.createTypeInfo(PojoItem.class);
        PojoCsvInputFormat inputFormat = new PojoCsvInputFormat(new Path(tempFile.toURI().toString()), typeInfo, new String[]{"field1", "field3", "field2", "field4"});
        inputFormat.configure(new Configuration());
        FileInputSplit[] splits = inputFormat.createInputSplits(1);
        inputFormat.open(splits[0]);
        this.validatePojoItem((CsvInputFormat<PojoItem>)inputFormat);
    }

    @Test
    void testPojoTypeWithPartialFieldInCSV() throws Exception {
        File tempFile = File.createTempFile("CsvReaderPojoType", "tmp");
        tempFile.deleteOnExit();
        tempFile.setWritable(true);
        OutputStreamWriter wrt = new OutputStreamWriter(new FileOutputStream(tempFile));
        wrt.write("123,NODATA,AAA,NODATA,3.123,BBB\n");
        wrt.write("456,NODATA,BBB,NODATA,1.123,AAA\n");
        wrt.close();
        PojoTypeInfo typeInfo = (PojoTypeInfo)TypeExtractor.createTypeInfo(PojoItem.class);
        PojoCsvInputFormat inputFormat = new PojoCsvInputFormat(new Path(tempFile.toURI().toString()), typeInfo, new boolean[]{true, false, true, false, true, true});
        inputFormat.configure(new Configuration());
        FileInputSplit[] splits = inputFormat.createInputSplits(1);
        inputFormat.open(splits[0]);
        this.validatePojoItem((CsvInputFormat<PojoItem>)inputFormat);
    }

    @Test
    void testPojoTypeWithMappingInfoAndPartialField() throws Exception {
        File tempFile = File.createTempFile("CsvReaderPojoType", "tmp");
        tempFile.deleteOnExit();
        tempFile.setWritable(true);
        OutputStreamWriter wrt = new OutputStreamWriter(new FileOutputStream(tempFile));
        wrt.write("123,3.123,AAA,BBB\n");
        wrt.write("456,1.123,BBB,AAA\n");
        wrt.close();
        PojoTypeInfo typeInfo = (PojoTypeInfo)TypeExtractor.createTypeInfo(PojoItem.class);
        PojoCsvInputFormat inputFormat = new PojoCsvInputFormat(new Path(tempFile.toURI().toString()), typeInfo, new String[]{"field1", "field4"}, new boolean[]{true, false, false, true});
        inputFormat.configure(new Configuration());
        FileInputSplit[] splits = inputFormat.createInputSplits(1);
        inputFormat.open(splits[0]);
        PojoItem item = new PojoItem();
        inputFormat.nextRecord((Object)item);
        Assertions.assertThat((int)item.field1).isEqualTo(123);
        Assertions.assertThat((String)item.field4).isEqualTo("BBB");
    }

    @Test
    void testPojoTypeWithInvalidFieldMapping() throws Exception {
        File tempFile = File.createTempFile("CsvReaderPojoType", "tmp");
        tempFile.deleteOnExit();
        tempFile.setWritable(true);
        PojoTypeInfo typeInfo = (PojoTypeInfo)TypeExtractor.createTypeInfo(PojoItem.class);
        try {
            new PojoCsvInputFormat(new Path(tempFile.toURI().toString()), typeInfo, new String[]{"field1", "field2"});
            Assertions.fail((String)"The number of POJO fields cannot be same as that of selected CSV fields");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new PojoCsvInputFormat(new Path(tempFile.toURI().toString()), typeInfo, new String[]{"field1", "field2", null, "field4"});
            Assertions.fail((String)"Fields mapping cannot contain null.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new PojoCsvInputFormat(new Path(tempFile.toURI().toString()), typeInfo, new String[]{"field1", "field2", "field3", "field5"});
            Assertions.fail((String)"Invalid field name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    void testQuotedStringParsingWithIncludeFields() throws Exception {
        String fileContent = "\"20:41:52-1-3-2015\"|\"Re: Taskmanager memory error in Eclipse\"|\"Blahblah <blah@blahblah.org>\"|\"blaaa|\"blubb\"";
        File tempFile = File.createTempFile("CsvReaderQuotedString", "tmp");
        tempFile.deleteOnExit();
        tempFile.setWritable(true);
        OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(tempFile));
        writer.write("\"20:41:52-1-3-2015\"|\"Re: Taskmanager memory error in Eclipse\"|\"Blahblah <blah@blahblah.org>\"|\"blaaa|\"blubb\"");
        writer.close();
        TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{String.class, String.class});
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(new Path(tempFile.toURI().toString()), (TupleTypeInfoBase)typeInfo, new boolean[]{true, false, true});
        inputFormat.enableQuotedStringParsing('\"');
        inputFormat.setFieldDelimiter("|");
        inputFormat.setDelimiter('\n');
        inputFormat.configure(new Configuration());
        FileInputSplit[] splits = inputFormat.createInputSplits(1);
        inputFormat.open(splits[0]);
        Tuple2 record = (Tuple2)inputFormat.nextRecord((Object)new Tuple2());
        Assertions.assertThat((String)((String)record.f0)).isEqualTo("20:41:52-1-3-2015");
        Assertions.assertThat((String)((String)record.f1)).isEqualTo("Blahblah <blah@blahblah.org>");
    }

    @Test
    void testQuotedStringParsingWithEscapedQuotes() throws Exception {
        String fileContent = "\"\\\"Hello\\\" World\"|\"We are\\\" young\"";
        File tempFile = File.createTempFile("CsvReaderQuotedString", "tmp");
        tempFile.deleteOnExit();
        tempFile.setWritable(true);
        OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(tempFile));
        writer.write("\"\\\"Hello\\\" World\"|\"We are\\\" young\"");
        writer.close();
        TupleTypeInfo typeInfo = TupleTypeInfo.getBasicTupleTypeInfo((Class[])new Class[]{String.class, String.class});
        TupleCsvInputFormat inputFormat = new TupleCsvInputFormat(new Path(tempFile.toURI().toString()), (TupleTypeInfoBase)typeInfo);
        inputFormat.enableQuotedStringParsing('\"');
        inputFormat.setFieldDelimiter("|");
        inputFormat.setDelimiter('\n');
        inputFormat.configure(new Configuration());
        FileInputSplit[] splits = inputFormat.createInputSplits(1);
        inputFormat.open(splits[0]);
        Tuple2 record = (Tuple2)inputFormat.nextRecord((Object)new Tuple2());
        Assertions.assertThat((String)((String)record.f0)).isEqualTo("\\\"Hello\\\" World");
        Assertions.assertThat((String)((String)record.f1)).isEqualTo("We are\\\" young");
    }

    @Test
    void testPojoSubclassType() throws Exception {
        TwitterPOJO pojo;
        String fileContent = "t1,foobar,tweet2\nt2,barfoo,tweet2";
        File tempFile = File.createTempFile("CsvReaderPOJOSubclass", "tmp");
        tempFile.deleteOnExit();
        OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(tempFile));
        writer.write("t1,foobar,tweet2\nt2,barfoo,tweet2");
        writer.close();
        PojoTypeInfo typeInfo = (PojoTypeInfo)TypeExtractor.createTypeInfo(TwitterPOJO.class);
        PojoCsvInputFormat inputFormat = new PojoCsvInputFormat(new Path(tempFile.toURI().toString()), typeInfo);
        inputFormat.configure(new Configuration());
        FileInputSplit[] splits = inputFormat.createInputSplits(1);
        inputFormat.open(splits[0]);
        ArrayList<TwitterPOJO> expected = new ArrayList<TwitterPOJO>();
        for (String line : "t1,foobar,tweet2\nt2,barfoo,tweet2".split("\n")) {
            String[] elements = line.split(",");
            expected.add(new TwitterPOJO(elements[0], elements[1], elements[2]));
        }
        ArrayList<TwitterPOJO> actual = new ArrayList<TwitterPOJO>();
        while ((pojo = (TwitterPOJO)inputFormat.nextRecord((Object)new TwitterPOJO())) != null) {
            actual.add(pojo);
        }
        Assertions.assertThat(actual).isEqualTo(expected);
    }

    public static class TwitterPOJO
    extends POJO {
        public String tweet;

        public TwitterPOJO() {
            this("", "", "");
        }

        public TwitterPOJO(String table, String time, String tweet) {
            super(table, time);
            this.tweet = tweet;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof TwitterPOJO) {
                TwitterPOJO other = (TwitterPOJO)obj;
                return super.equals(other) && this.tweet.equals(other.tweet);
            }
            return false;
        }
    }

    public static class POJO {
        public String table;
        public String time;

        public POJO() {
            this("", "");
        }

        public POJO(String table, String time) {
            this.table = table;
            this.time = time;
        }

        public boolean equals(Object obj) {
            if (obj instanceof POJO) {
                POJO other = (POJO)obj;
                return this.table.equals(other.table) && this.time.equals(other.time);
            }
            return false;
        }
    }

    public static class PrivatePojoItem {
        private int field1;
        private String field2;
        private Double field3;
        private String field4;

        public int getField1() {
            return this.field1;
        }

        public void setField1(int field1) {
            this.field1 = field1;
        }

        public String getField2() {
            return this.field2;
        }

        public void setField2(String field2) {
            this.field2 = field2;
        }

        public Double getField3() {
            return this.field3;
        }

        public void setField3(Double field3) {
            this.field3 = field3;
        }

        public String getField4() {
            return this.field4;
        }

        public void setField4(String field4) {
            this.field4 = field4;
        }
    }

    public static class PojoItem {
        public int field1;
        public String field2;
        public Double field3;
        public String field4;
    }
}

