/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.io.CollectionInputFormat;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.core.io.GenericInputSplit;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CollectionInputFormatTest {
    CollectionInputFormatTest() {
    }

    @Test
    void testSerializability() {
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();
             ObjectOutputStream out = new ObjectOutputStream(buffer);){
            ArrayList<ElementType> inputCollection = new ArrayList<ElementType>();
            ElementType element1 = new ElementType(1);
            ElementType element2 = new ElementType(2);
            ElementType element3 = new ElementType(3);
            inputCollection.add(element1);
            inputCollection.add(element2);
            inputCollection.add(element3);
            TypeInformation info = TypeExtractor.createTypeInfo(ElementType.class);
            CollectionInputFormat inputFormat = new CollectionInputFormat(inputCollection, info.createSerializer((SerializerConfig)new SerializerConfigImpl()));
            out.writeObject(inputFormat);
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            Object serializationResult = in.readObject();
            Assertions.assertThat((Object)serializationResult).isInstanceOf(CollectionInputFormat.class);
            CollectionInputFormat result = (CollectionInputFormat)serializationResult;
            GenericInputSplit inputSplit = new GenericInputSplit(0, 1);
            inputFormat.open(inputSplit);
            result.open(inputSplit);
            while (!inputFormat.reachedEnd() && !result.reachedEnd()) {
                ElementType expectedElement = (ElementType)inputFormat.nextRecord(null);
                ElementType actualElement = (ElementType)result.nextRecord(null);
                Assertions.assertThat((Object)actualElement).isEqualTo((Object)expectedElement);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.toString());
        }
    }

    @Test
    void testSerializabilityStrings() {
        String[] data = new String[]{"To be, or not to be,--that is the question:--", "Whether 'tis nobler in the mind to suffer", "The slings and arrows of outrageous fortune", "Or to take arms against a sea of troubles,", "And by opposing end them?--To die,--to sleep,--", "No more; and by a sleep to say we end", "The heartache, and the thousand natural shocks", "That flesh is heir to,--'tis a consummation", "Devoutly to be wish'd. To die,--to sleep;--", "To sleep! perchance to dream:--ay, there's the rub;", "For in that sleep of death what dreams may come,", "When we have shuffled off this mortal coil,", "Must give us pause: there's the respect", "That makes calamity of so long life;", "For who would bear the whips and scorns of time,", "The oppressor's wrong, the proud man's contumely,", "The pangs of despis'd love, the law's delay,", "The insolence of office, and the spurns", "That patient merit of the unworthy takes,", "When he himself might his quietus make", "With a bare bodkin? who would these fardels bear,", "To grunt and sweat under a weary life,", "But that the dread of something after death,--", "The undiscover'd country, from whose bourn", "No traveller returns,--puzzles the will,", "And makes us rather bear those ills we have", "Than fly to others that we know not of?", "Thus conscience does make cowards of us all;", "And thus the native hue of resolution", "Is sicklied o'er with the pale cast of thought;", "And enterprises of great pith and moment,", "With this regard, their currents turn awry,", "And lose the name of action.--Soft you now!", "The fair Ophelia!--Nymph, in thy orisons", "Be all my sins remember'd."};
        try {
            List<String> inputCollection = Arrays.asList(data);
            CollectionInputFormat inputFormat = new CollectionInputFormat(inputCollection, BasicTypeInfo.STRING_TYPE_INFO.createSerializer((SerializerConfig)new SerializerConfigImpl()));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(inputFormat);
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object result = ois.readObject();
            Assertions.assertThat((Object)result).isInstanceOf(CollectionInputFormat.class);
            int i = 0;
            CollectionInputFormat in = (CollectionInputFormat)result;
            in.open(new GenericInputSplit(0, 1));
            while (!in.reachedEnd()) {
                Assertions.assertThat((String)((String)in.nextRecord((Object)""))).isEqualTo(data[i++]);
            }
            Assertions.assertThat((int)i).isEqualTo(data.length);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testSerializationFailure() {
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();
             ObjectOutputStream out = new ObjectOutputStream(buffer);){
            CollectionInputFormat inFormat = new CollectionInputFormat(Collections.singleton(new ElementType()), (TypeSerializer)new TestSerializer(false, true));
            try {
                out.writeObject(inFormat);
                Assertions.fail((String)"should throw an exception");
            }
            catch (TestException testException) {
            }
            catch (Exception e) {
                Assertions.fail((String)"Exception not properly forwarded");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testDeserializationFailure() {
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();
             ObjectOutputStream out = new ObjectOutputStream(buffer);){
            CollectionInputFormat inFormat = new CollectionInputFormat(Collections.singleton(new ElementType()), (TypeSerializer)new TestSerializer(true, false));
            out.writeObject(inFormat);
            out.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bais);
            try {
                in.readObject();
                Assertions.fail((String)"should throw an exception");
            }
            catch (Exception e) {
                Assertions.assertThat((Throwable)e).hasCauseInstanceOf(TestException.class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testToStringOnSmallCollection() {
        ArrayList<ElementType> smallList = new ArrayList<ElementType>();
        smallList.add(new ElementType(1));
        smallList.add(new ElementType(2));
        CollectionInputFormat inputFormat = new CollectionInputFormat(smallList, (TypeSerializer)new TestSerializer(true, false));
        Assertions.assertThat((Object)inputFormat).hasToString("[ElementType{id=1}, ElementType{id=2}]");
    }

    @Test
    void testToStringOnBigCollection() {
        ArrayList<ElementType> list = new ArrayList<ElementType>();
        for (int i = 0; i < 10; ++i) {
            list.add(new ElementType(i));
        }
        CollectionInputFormat inputFormat = new CollectionInputFormat(list, (TypeSerializer)new TestSerializer(true, false));
        Assertions.assertThat((Object)inputFormat).hasToString("[ElementType{id=0}, ElementType{id=1}, ElementType{id=2}, ElementType{id=3}, ElementType{id=4}, ElementType{id=5}, ...]");
    }

    private static class TestSerializer
    extends TypeSerializer<ElementType> {
        private static final long serialVersionUID = 1L;
        private final boolean failOnRead;
        private final boolean failOnWrite;

        public TestSerializer(boolean failOnRead, boolean failOnWrite) {
            this.failOnRead = failOnRead;
            this.failOnWrite = failOnWrite;
        }

        public boolean isImmutableType() {
            return true;
        }

        public TestSerializer duplicate() {
            return this;
        }

        public ElementType createInstance() {
            return new ElementType();
        }

        public ElementType copy(ElementType from) {
            return from;
        }

        public ElementType copy(ElementType from, ElementType reuse) {
            return from;
        }

        public int getLength() {
            return 4;
        }

        public void serialize(ElementType record, DataOutputView target) throws IOException {
            if (this.failOnWrite) {
                throw new TestException();
            }
            target.writeInt(record.getId());
        }

        public ElementType deserialize(DataInputView source) throws IOException {
            if (this.failOnRead) {
                throw new TestException();
            }
            return new ElementType(source.readInt());
        }

        public ElementType deserialize(ElementType reuse, DataInputView source) throws IOException {
            if (this.failOnRead) {
                throw new TestException();
            }
            return new ElementType(source.readInt());
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            target.writeInt(source.readInt());
        }

        public boolean equals(Object obj) {
            if (obj instanceof TestSerializer) {
                TestSerializer other = (TestSerializer)((Object)obj);
                return this.failOnRead == other.failOnRead && this.failOnWrite == other.failOnWrite;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.failOnRead, this.failOnWrite);
        }

        public TypeSerializerSnapshot<ElementType> snapshotConfiguration() {
            throw new UnsupportedOperationException();
        }
    }

    private static class TestException
    extends IOException {
        private static final long serialVersionUID = 1L;

        private TestException() {
        }
    }

    private static class ElementType {
        private final int id;

        public ElementType() {
            this(-1);
        }

        public ElementType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ElementType) {
                ElementType et = (ElementType)obj;
                return et.getId() == this.getId();
            }
            return false;
        }

        public int hashCode() {
            return this.id;
        }

        public String toString() {
            return "ElementType{id=" + this.id + '}';
        }
    }
}

