/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.IOException;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.CsvInputFormat;
import org.apache.flink.api.java.io.CsvReader;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.tuple.Tuple8;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.BooleanValue;
import org.apache.flink.types.ByteValue;
import org.apache.flink.types.CharValue;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.FloatValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.ShortValue;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CSVReaderTest {
    CSVReaderTest() {
    }

    @Test
    void testIgnoreHeaderConfigure() {
        CsvReader reader = CSVReaderTest.getCsvReader();
        reader.ignoreFirstLine();
        Assertions.assertThat((boolean)reader.skipFirstLineAsHeader).isTrue();
    }

    @Test
    void testIgnoreInvalidLinesConfigure() {
        CsvReader reader = CSVReaderTest.getCsvReader();
        Assertions.assertThat((boolean)reader.ignoreInvalidLines).isFalse();
        reader.ignoreInvalidLines();
        Assertions.assertThat((boolean)reader.ignoreInvalidLines).isTrue();
    }

    @Test
    void testIgnoreComments() {
        CsvReader reader = CSVReaderTest.getCsvReader();
        Assertions.assertThat((String)reader.commentPrefix).isNull();
        reader.ignoreComments("#");
        Assertions.assertThat((String)reader.commentPrefix).isEqualTo("#");
    }

    @Test
    void testCharset() {
        CsvReader reader = CSVReaderTest.getCsvReader();
        Assertions.assertThat((String)reader.getCharset()).isEqualTo("UTF-8");
        reader.setCharset("US-ASCII");
        Assertions.assertThat((String)reader.getCharset()).isEqualTo("US-ASCII");
    }

    @Test
    void testIncludeFieldsDense() {
        CsvReader reader = CSVReaderTest.getCsvReader();
        reader.includeFields(new boolean[]{true, true, true});
        Assertions.assertThat((boolean[])reader.includedMask).containsExactly(new boolean[]{true, true, true});
        reader = CSVReaderTest.getCsvReader();
        reader.includeFields("ttt");
        Assertions.assertThat((boolean[])reader.includedMask).containsExactly(new boolean[]{true, true, true});
        reader = CSVReaderTest.getCsvReader();
        reader.includeFields("TTT");
        Assertions.assertThat((boolean[])reader.includedMask).containsExactly(new boolean[]{true, true, true});
        reader = CSVReaderTest.getCsvReader();
        reader.includeFields("111");
        Assertions.assertThat((boolean[])reader.includedMask).containsExactly(new boolean[]{true, true, true});
        reader = CSVReaderTest.getCsvReader();
        reader.includeFields(7L);
        Assertions.assertThat((boolean[])reader.includedMask).containsExactly(new boolean[]{true, true, true});
    }

    @Test
    void testIncludeFieldsSparse() {
        CsvReader reader = CSVReaderTest.getCsvReader();
        reader.includeFields(new boolean[]{false, true, true, false, false, true, false, false});
        Assertions.assertThat((boolean[])reader.includedMask).containsExactly(new boolean[]{false, true, true, false, false, true});
        reader = CSVReaderTest.getCsvReader();
        reader.includeFields("fttfftff");
        Assertions.assertThat((boolean[])reader.includedMask).containsExactly(new boolean[]{false, true, true, false, false, true});
        reader = CSVReaderTest.getCsvReader();
        reader.includeFields("FTTFFTFF");
        Assertions.assertThat((boolean[])reader.includedMask).containsExactly(new boolean[]{false, true, true, false, false, true});
        reader = CSVReaderTest.getCsvReader();
        reader.includeFields("01100100");
        Assertions.assertThat((boolean[])reader.includedMask).containsExactly(new boolean[]{false, true, true, false, false, true});
        reader = CSVReaderTest.getCsvReader();
        reader.includeFields("0t1f0TFF");
        Assertions.assertThat((boolean[])reader.includedMask).containsExactly(new boolean[]{false, true, true, false, false, true});
        reader = CSVReaderTest.getCsvReader();
        reader.includeFields(38L);
        Assertions.assertThat((boolean[])reader.includedMask).containsExactly(new boolean[]{false, true, true, false, false, true});
    }

    @Test
    void testIllegalCharInStringMask() {
        CsvReader reader = CSVReaderTest.getCsvReader();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> reader.includeFields("1t0Tfht")).withFailMessage("Reader accepted an invalid mask string", new Object[0])).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testIncludeFieldsErrorWhenExcludingAll() {
        CsvReader reader = CSVReaderTest.getCsvReader();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> reader.includeFields(new boolean[]{false, false, false, false, false, false})).withFailMessage("The reader accepted a fields configuration that excludes all fields.", new Object[0])).isInstanceOf(IllegalArgumentException.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> reader.includeFields(0L)).withFailMessage("The reader accepted a fields configuration that excludes all fields.", new Object[0])).isInstanceOf(IllegalArgumentException.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> reader.includeFields("ffffffffffffff")).withFailMessage("The reader accepted a fields configuration that excludes all fields.", new Object[0])).isInstanceOf(IllegalArgumentException.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> reader.includeFields("00000000000000000")).withFailMessage("The reader accepted a fields configuration that excludes all fields.", new Object[0])).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testReturnType() {
        CsvReader reader = CSVReaderTest.getCsvReader();
        DataSource items = reader.tupleType(Item.class);
        Assertions.assertThat((Class)items.getType().getTypeClass()).isSameAs(Item.class);
    }

    @Test
    void testFieldTypes() {
        CsvReader reader = CSVReaderTest.getCsvReader();
        DataSource items = reader.tupleType(Item.class);
        TypeInformation info = items.getType();
        if (!info.isTupleType()) {
            Assertions.fail((String)"");
        } else {
            TupleTypeInfo tinfo = (TupleTypeInfo)info;
            Assertions.assertThat((Object)tinfo.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
            Assertions.assertThat((Object)tinfo.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
            Assertions.assertThat((Object)tinfo.getTypeAt(2)).isEqualTo((Object)BasicTypeInfo.DOUBLE_TYPE_INFO);
            Assertions.assertThat((Object)tinfo.getTypeAt(3)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        }
        CsvInputFormat inputFormat = (CsvInputFormat)items.getInputFormat();
        Assertions.assertThat((Object[])inputFormat.getFieldTypes()).containsExactly((Object[])new Class[]{Integer.class, String.class, Double.class, String.class});
    }

    @Test
    void testSubClass() {
        CsvReader reader = CSVReaderTest.getCsvReader();
        DataSource sitems = reader.tupleType(SubItem.class);
        TypeInformation info = sitems.getType();
        Assertions.assertThat((boolean)info.isTupleType()).isTrue();
        Assertions.assertThat((Class)info.getTypeClass()).isEqualTo(SubItem.class);
        TupleTypeInfo tinfo = (TupleTypeInfo)info;
        Assertions.assertThat((Object)tinfo.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
        Assertions.assertThat((Object)tinfo.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)tinfo.getTypeAt(2)).isEqualTo((Object)BasicTypeInfo.DOUBLE_TYPE_INFO);
        Assertions.assertThat((Object)tinfo.getTypeAt(3)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        CsvInputFormat inputFormat = (CsvInputFormat)sitems.getInputFormat();
        Assertions.assertThat((Object[])inputFormat.getFieldTypes()).containsExactly((Object[])new Class[]{Integer.class, String.class, Double.class, String.class});
    }

    @Test
    void testSubClassWithPartialsInHierarchie() {
        CsvReader reader = CSVReaderTest.getCsvReader();
        DataSource sitems = reader.tupleType(FinalItem.class);
        TypeInformation info = sitems.getType();
        Assertions.assertThat((boolean)info.isTupleType()).isTrue();
        Assertions.assertThat((Class)info.getTypeClass()).isEqualTo(FinalItem.class);
        TupleTypeInfo tinfo = (TupleTypeInfo)info;
        Assertions.assertThat((Object)tinfo.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
        Assertions.assertThat((Object)tinfo.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)tinfo.getTypeAt(2)).isEqualTo((Object)BasicTypeInfo.DOUBLE_TYPE_INFO);
        Assertions.assertThat(tinfo.getTypeAt(3).getClass()).isEqualTo(ValueTypeInfo.class);
        Assertions.assertThat(tinfo.getTypeAt(4).getClass()).isEqualTo(ValueTypeInfo.class);
        Assertions.assertThat((Class)tinfo.getTypeAt(3).getTypeClass()).isEqualTo(StringValue.class);
        Assertions.assertThat((Class)tinfo.getTypeAt(4).getTypeClass()).isEqualTo(LongValue.class);
        CsvInputFormat inputFormat = (CsvInputFormat)sitems.getInputFormat();
        Assertions.assertThat((Object[])inputFormat.getFieldTypes()).containsExactly((Object[])new Class[]{Integer.class, String.class, Double.class, StringValue.class, LongValue.class});
    }

    @Test
    void testUnsupportedPartialitem() {
        CsvReader reader = CSVReaderTest.getCsvReader();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> reader.tupleType(PartialItem.class)).withFailMessage("tupleType() accepted an underspecified generic class.", new Object[0])).isInstanceOf(Exception.class);
    }

    @Test
    void testWithValueType() {
        CsvReader reader = CSVReaderTest.getCsvReader();
        DataSource items = reader.types(StringValue.class, BooleanValue.class, ByteValue.class, ShortValue.class, IntValue.class, LongValue.class, FloatValue.class, DoubleValue.class);
        TypeInformation info = items.getType();
        Assertions.assertThat((boolean)info.isTupleType()).isTrue();
        Assertions.assertThat((Class)info.getTypeClass()).isEqualTo(Tuple8.class);
    }

    @Test
    void testWithInvalidValueType1() {
        CsvReader reader = CSVReaderTest.getCsvReader();
        Assertions.assertThatThrownBy(() -> reader.types(CharValue.class)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testWithInvalidValueType2() {
        CsvReader reader = CSVReaderTest.getCsvReader();
        Assertions.assertThatThrownBy(() -> reader.types(ValueItem.class)).isInstanceOf(IllegalArgumentException.class);
    }

    private static CsvReader getCsvReader() {
        return new CsvReader("/some/none/existing/path", (ExecutionEnvironment)ExecutionEnvironment.createLocalEnvironment((int)1));
    }

    private static class ValueItem
    implements Value {
        private int v1;

        private ValueItem() {
        }

        public int getV1() {
            return this.v1;
        }

        public void setV1(int v1) {
            this.v1 = v1;
        }

        public void write(DataOutputView out) throws IOException {
            out.writeInt(this.v1);
        }

        public void read(DataInputView in) throws IOException {
            this.v1 = in.readInt();
        }
    }

    private static class FinalItem
    extends PartialItem<String, StringValue, LongValue> {
        private static final long serialVersionUID = 1L;

        private FinalItem() {
        }
    }

    private static class PartialItem<A, B, C>
    extends Tuple5<Integer, A, Double, B, C> {
        private static final long serialVersionUID = 1L;

        private PartialItem() {
        }
    }

    private static class SubItem
    extends Item {
        private static final long serialVersionUID = 1L;

        private SubItem() {
        }
    }

    private static class Item
    extends Tuple4<Integer, String, Double, String> {
        private static final long serialVersionUID = -7444437337392053502L;

        private Item() {
        }
    }
}

