/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.functions;

import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.base.InnerJoinOperatorBase;
import org.apache.flink.api.common.operators.base.MapOperatorBase;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SemanticPropertiesTranslationTest {
    SemanticPropertiesTranslationTest() {
    }

    @Test
    void testUnaryFunctionWildcardForwardedAnnotation() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)"test", (Object)42)});
        input.map(new WildcardForwardedMapper()).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        MapOperatorBase mapper = (MapOperatorBase)sink.getInput();
        SingleInputSemanticProperties semantics = mapper.getSemanticProperties();
        FieldSet fw1 = semantics.getForwardingTargetFields(0, 0);
        FieldSet fw2 = semantics.getForwardingTargetFields(0, 1);
        FieldSet fw3 = semantics.getForwardingTargetFields(0, 2);
        Assertions.assertThat((Iterable)fw1).contains((Object[])new Integer[]{0});
        Assertions.assertThat((Iterable)fw2).contains((Object[])new Integer[]{1});
        Assertions.assertThat((Iterable)fw3).contains((Object[])new Integer[]{2});
    }

    @Test
    void testUnaryFunctionInPlaceForwardedAnnotation() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)"test", (Object)42)});
        input.map(new IndividualForwardedMapper()).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        MapOperatorBase mapper = (MapOperatorBase)sink.getInput();
        SingleInputSemanticProperties semantics = mapper.getSemanticProperties();
        FieldSet fw1 = semantics.getForwardingTargetFields(0, 0);
        FieldSet fw2 = semantics.getForwardingTargetFields(0, 2);
        Assertions.assertThat((Iterable)fw1).contains((Object[])new Integer[]{0});
        Assertions.assertThat((Iterable)fw2).contains((Object[])new Integer[]{2});
    }

    @Test
    void testUnaryFunctionMovingForwardedAnnotation() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)2L, (Object)1L)});
        input.map(new ShufflingMapper()).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        MapOperatorBase mapper = (MapOperatorBase)sink.getInput();
        SingleInputSemanticProperties semantics = mapper.getSemanticProperties();
        FieldSet fw1 = semantics.getForwardingTargetFields(0, 0);
        FieldSet fw2 = semantics.getForwardingTargetFields(0, 1);
        FieldSet fw3 = semantics.getForwardingTargetFields(0, 2);
        Assertions.assertThat((Iterable)fw1).contains((Object[])new Integer[]{2});
        Assertions.assertThat((Iterable)fw2).contains((Object[])new Integer[]{0});
        Assertions.assertThat((Iterable)fw3).contains((Object[])new Integer[]{1});
    }

    @Test
    void testUnaryFunctionForwardedInLine1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)2L, (Object)1L)});
        ((MapOperator)input.map(new NoAnnotationMapper()).withForwardedFields(new String[]{"0->1; 2"})).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        MapOperatorBase mapper = (MapOperatorBase)sink.getInput();
        SingleInputSemanticProperties semantics = mapper.getSemanticProperties();
        FieldSet fw1 = semantics.getForwardingTargetFields(0, 0);
        FieldSet fw2 = semantics.getForwardingTargetFields(0, 2);
        Assertions.assertThat((Iterable)fw1).contains((Object[])new Integer[]{1});
        Assertions.assertThat((Iterable)fw2).contains((Object[])new Integer[]{2});
    }

    @Test
    void testUnaryFunctionForwardedInLine2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)2L, (Object)1L)});
        ((MapOperator)input.map(new ReadSetMapper()).withForwardedFields(new String[]{"0->1; 2"})).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        MapOperatorBase mapper = (MapOperatorBase)sink.getInput();
        SingleInputSemanticProperties semantics = mapper.getSemanticProperties();
        FieldSet fw1 = semantics.getForwardingTargetFields(0, 0);
        FieldSet fw2 = semantics.getForwardingTargetFields(0, 2);
        Assertions.assertThat((Iterable)fw1).contains((Object[])new Integer[]{1});
        Assertions.assertThat((Iterable)fw2).contains((Object[])new Integer[]{2});
    }

    @Test
    void testUnaryFunctionForwardedInLine3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)2L, (Object)1L)});
        ((MapOperator)input.map(new ReadSetMapper()).withForwardedFields(new String[]{"0->1; 2"})).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        MapOperatorBase mapper = (MapOperatorBase)sink.getInput();
        SingleInputSemanticProperties semantics = mapper.getSemanticProperties();
        FieldSet fw1 = semantics.getForwardingTargetFields(0, 0);
        FieldSet fw2 = semantics.getForwardingTargetFields(0, 2);
        Assertions.assertThat((Iterable)fw1).contains((Object[])new Integer[]{1});
        Assertions.assertThat((Iterable)fw2).contains((Object[])new Integer[]{2});
    }

    @Test
    void testUnaryFunctionAllForwardedExceptAnnotation() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)2L, (Object)1L)});
        input.map(new AllForwardedExceptMapper()).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        MapOperatorBase mapper = (MapOperatorBase)sink.getInput();
        SingleInputSemanticProperties semantics = mapper.getSemanticProperties();
        FieldSet fw1 = semantics.getForwardingTargetFields(0, 0);
        FieldSet fw2 = semantics.getForwardingTargetFields(0, 2);
        Assertions.assertThat((Iterable)fw1).contains((Object[])new Integer[]{0});
        Assertions.assertThat((Iterable)fw2).contains((Object[])new Integer[]{2});
    }

    @Test
    void testUnaryFunctionReadFieldsAnnotation() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)2L, (Object)1L)});
        input.map(new ReadSetMapper()).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        MapOperatorBase mapper = (MapOperatorBase)sink.getInput();
        SingleInputSemanticProperties semantics = mapper.getSemanticProperties();
        FieldSet read = semantics.getReadFields(0);
        Assertions.assertThat((Iterable)read).containsExactly((Object[])new Integer[]{0, 2});
    }

    @Test
    void testUnaryForwardedOverwritingInLine1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)2L, (Object)1L)});
        Assertions.assertThatThrownBy(() -> SemanticPropertiesTranslationTest.lambda$testUnaryForwardedOverwritingInLine1$0((DataSet)input)).isInstanceOf(SemanticProperties.InvalidSemanticAnnotationException.class);
    }

    @Test
    void testUnaryForwardedOverwritingInLine2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)2L, (Object)1L)});
        Assertions.assertThatThrownBy(() -> SemanticPropertiesTranslationTest.lambda$testUnaryForwardedOverwritingInLine2$1((DataSet)input)).isInstanceOf(SemanticProperties.InvalidSemanticAnnotationException.class);
    }

    @Test
    void testBinaryForwardedAnnotation() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)"test")});
        DataSource input2 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)3.1415)});
        input1.join((DataSet)input2).where(new int[]{0}).equalTo(new int[]{0}).with(new ForwardedBothAnnotationJoin()).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        InnerJoinOperatorBase join = (InnerJoinOperatorBase)sink.getInput();
        DualInputSemanticProperties semantics = join.getSemanticProperties();
        Assertions.assertThat((Iterable)semantics.getForwardingTargetFields(0, 0)).isEmpty();
        Assertions.assertThat((Iterable)semantics.getForwardingTargetFields(1, 0)).isEmpty();
        Assertions.assertThat((Iterable)semantics.getForwardingTargetFields(0, 1)).containsExactly((Object[])new Integer[]{0});
        Assertions.assertThat((Iterable)semantics.getForwardingTargetFields(1, 1)).containsExactly((Object[])new Integer[]{1});
    }

    @Test
    void testBinaryForwardedInLine1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)4L)});
        DataSource input2 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)2L)});
        ((JoinOperator)((JoinOperator)input1.join((DataSet)input2).where(new int[]{0}).equalTo(new int[]{0}).with(new NoAnnotationJoin()).withForwardedFieldsFirst(new String[]{"0->1; 1->2"})).withForwardedFieldsSecond(new String[]{"1->0"})).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        InnerJoinOperatorBase join = (InnerJoinOperatorBase)sink.getInput();
        DualInputSemanticProperties semantics = join.getSemanticProperties();
        Assertions.assertThat((Iterable)semantics.getForwardingTargetFields(1, 0)).isEmpty();
        Assertions.assertThat((Iterable)semantics.getForwardingTargetFields(0, 0)).containsExactly((Object[])new Integer[]{1});
        Assertions.assertThat((Iterable)semantics.getForwardingTargetFields(0, 1)).containsExactly((Object[])new Integer[]{2});
        Assertions.assertThat((Iterable)semantics.getForwardingTargetFields(1, 1)).containsExactly((Object[])new Integer[]{0});
    }

    @Test
    void testBinaryForwardedInLine2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)4L)});
        DataSource input2 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)2L)});
        ((JoinOperator)((JoinOperator)input1.join((DataSet)input2).where(new int[]{0}).equalTo(new int[]{0}).with(new ReadSetJoin()).withForwardedFieldsFirst(new String[]{"0->1; 1->2"})).withForwardedFieldsSecond(new String[]{"1->0"})).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        InnerJoinOperatorBase join = (InnerJoinOperatorBase)sink.getInput();
        DualInputSemanticProperties semantics = join.getSemanticProperties();
        Assertions.assertThat((Iterable)semantics.getForwardingTargetFields(1, 0)).isEmpty();
        Assertions.assertThat((Iterable)semantics.getForwardingTargetFields(0, 0)).containsExactly((Object[])new Integer[]{1});
        Assertions.assertThat((Iterable)semantics.getForwardingTargetFields(0, 1)).containsExactly((Object[])new Integer[]{2});
        Assertions.assertThat((Iterable)semantics.getForwardingTargetFields(1, 1)).containsExactly((Object[])new Integer[]{0});
        Assertions.assertThat((Iterable)semantics.getReadFields(0)).containsExactly((Object[])new Integer[]{1});
        Assertions.assertThat((Iterable)semantics.getReadFields(1)).containsExactly((Object[])new Integer[]{0});
    }

    @Test
    void testBinaryForwardedAnnotationInLineMixed1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)4L)});
        DataSource input2 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)2L)});
        ((JoinOperator)input1.join((DataSet)input2).where(new int[]{0}).equalTo(new int[]{0}).with(new ForwardedFirstAnnotationJoin()).withForwardedFieldsSecond(new String[]{"1"})).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        InnerJoinOperatorBase join = (InnerJoinOperatorBase)sink.getInput();
        DualInputSemanticProperties semantics = join.getSemanticProperties();
        Assertions.assertThat((Iterable)semantics.getForwardingTargetFields(0, 1)).isEmpty();
        Assertions.assertThat((Iterable)semantics.getForwardingTargetFields(1, 0)).isEmpty();
        Assertions.assertThat((Iterable)semantics.getForwardingTargetFields(0, 0)).containsExactly((Object[])new Integer[]{2});
        Assertions.assertThat((Iterable)semantics.getForwardingTargetFields(1, 1)).containsExactly((Object[])new Integer[]{1});
    }

    @Test
    void testBinaryForwardedAnnotationInLineMixed2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)4L)});
        DataSource input2 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)2L)});
        ((JoinOperator)input1.join((DataSet)input2).where(new int[]{0}).equalTo(new int[]{0}).with(new ForwardedSecondAnnotationJoin()).withForwardedFieldsFirst(new String[]{"0->1"})).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        InnerJoinOperatorBase join = (InnerJoinOperatorBase)sink.getInput();
        DualInputSemanticProperties semantics = join.getSemanticProperties();
        Assertions.assertThat((Iterable)semantics.getForwardingTargetFields(0, 1)).isEmpty();
        Assertions.assertThat((Iterable)semantics.getForwardingTargetFields(1, 0)).isEmpty();
        Assertions.assertThat((Iterable)semantics.getForwardingTargetFields(0, 0)).containsExactly((Object[])new Integer[]{1});
        Assertions.assertThat((Iterable)semantics.getForwardingTargetFields(1, 1)).containsExactly((Object[])new Integer[]{2});
    }

    @Test
    void testBinaryAllForwardedExceptAnnotation() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input1 = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)4L, (Object)5L)});
        DataSource input2 = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)2L, (Object)1L)});
        input1.join((DataSet)input2).where(new int[]{0}).equalTo(new int[]{0}).with(new AllForwardedExceptJoin()).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        InnerJoinOperatorBase join = (InnerJoinOperatorBase)sink.getInput();
        DualInputSemanticProperties semantics = join.getSemanticProperties();
        Assertions.assertThat((Iterable)semantics.getForwardingTargetFields(0, 0)).isEmpty();
        Assertions.assertThat((Iterable)semantics.getForwardingTargetFields(0, 2)).isEmpty();
        Assertions.assertThat((Iterable)semantics.getForwardingTargetFields(1, 0)).isEmpty();
        Assertions.assertThat((Iterable)semantics.getForwardingTargetFields(1, 1)).isEmpty();
        Assertions.assertThat((Iterable)semantics.getForwardingTargetFields(0, 1)).containsExactly((Object[])new Integer[]{1});
        Assertions.assertThat((Iterable)semantics.getForwardingTargetFields(1, 2)).containsExactly((Object[])new Integer[]{2});
    }

    @Test
    void testBinaryReadFieldsAnnotation() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)4L)});
        DataSource input2 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)2L)});
        input1.join((DataSet)input2).where(new int[]{0}).equalTo(new int[]{0}).with(new ReadSetJoin()).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        InnerJoinOperatorBase join = (InnerJoinOperatorBase)sink.getInput();
        DualInputSemanticProperties semantics = join.getSemanticProperties();
        Assertions.assertThat((Iterable)semantics.getReadFields(0)).containsExactly((Object[])new Integer[]{1});
        Assertions.assertThat((Iterable)semantics.getReadFields(1)).containsExactly((Object[])new Integer[]{0});
    }

    @Test
    void testBinaryForwardedOverwritingInLine1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)4L)});
        DataSource input2 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)2L)});
        Assertions.assertThatThrownBy(() -> SemanticPropertiesTranslationTest.lambda$testBinaryForwardedOverwritingInLine1$2((DataSet)input1, (DataSet)input2)).isInstanceOf(SemanticProperties.InvalidSemanticAnnotationException.class);
    }

    @Test
    void testBinaryForwardedOverwritingInLine2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)4L)});
        DataSource input2 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)2L)});
        Assertions.assertThatThrownBy(() -> SemanticPropertiesTranslationTest.lambda$testBinaryForwardedOverwritingInLine2$3((DataSet)input1, (DataSet)input2)).isInstanceOf(SemanticProperties.InvalidSemanticAnnotationException.class);
    }

    @Test
    void testBinaryForwardedOverwritingInLine3() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)4L)});
        DataSource input2 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)2L)});
        Assertions.assertThatThrownBy(() -> SemanticPropertiesTranslationTest.lambda$testBinaryForwardedOverwritingInLine3$4((DataSet)input1, (DataSet)input2)).isInstanceOf(SemanticProperties.InvalidSemanticAnnotationException.class);
    }

    @Test
    void testBinaryForwardedOverwritingInLine4() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input1 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)4L)});
        DataSource input2 = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)3L, (Object)2L)});
        Assertions.assertThatThrownBy(() -> SemanticPropertiesTranslationTest.lambda$testBinaryForwardedOverwritingInLine4$5((DataSet)input1, (DataSet)input2)).isInstanceOf(SemanticProperties.InvalidSemanticAnnotationException.class);
    }

    @Test
    void testBinaryForwardedOverwritingInLine5() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input1 = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)4L, (Object)5L)});
        DataSource input2 = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)2L, (Object)1L)});
        Assertions.assertThatThrownBy(() -> SemanticPropertiesTranslationTest.lambda$testBinaryForwardedOverwritingInLine5$6((DataSet)input1, (DataSet)input2)).isInstanceOf(SemanticProperties.InvalidSemanticAnnotationException.class);
    }

    @Test
    void testBinaryForwardedOverwritingInLine6() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource input1 = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)4L, (Object)5L)});
        DataSource input2 = env.fromElements((Object[])new Tuple3[]{new Tuple3((Object)3L, (Object)2L, (Object)1L)});
        Assertions.assertThatThrownBy(() -> SemanticPropertiesTranslationTest.lambda$testBinaryForwardedOverwritingInLine6$7((DataSet)input1, (DataSet)input2)).isInstanceOf(SemanticProperties.InvalidSemanticAnnotationException.class);
    }

    private static /* synthetic */ void lambda$testBinaryForwardedOverwritingInLine6$7(DataSet input1, DataSet input2) throws Throwable {
        JoinOperator cfr_ignored_0 = (JoinOperator)input1.join(input2).where(new int[]{0}).equalTo(new int[]{0}).with(new AllForwardedExceptJoin()).withForwardedFieldsSecond(new String[]{"0->1;"});
    }

    private static /* synthetic */ void lambda$testBinaryForwardedOverwritingInLine5$6(DataSet input1, DataSet input2) throws Throwable {
        JoinOperator cfr_ignored_0 = (JoinOperator)input1.join(input2).where(new int[]{0}).equalTo(new int[]{0}).with(new AllForwardedExceptJoin()).withForwardedFieldsFirst(new String[]{"0->1;"});
    }

    private static /* synthetic */ void lambda$testBinaryForwardedOverwritingInLine4$5(DataSet input1, DataSet input2) throws Throwable {
        JoinOperator cfr_ignored_0 = (JoinOperator)input1.join(input2).where(new int[]{0}).equalTo(new int[]{0}).with(new ForwardedBothAnnotationJoin()).withForwardedFieldsSecond(new String[]{"0->1;"});
    }

    private static /* synthetic */ void lambda$testBinaryForwardedOverwritingInLine3$4(DataSet input1, DataSet input2) throws Throwable {
        JoinOperator cfr_ignored_0 = (JoinOperator)input1.join(input2).where(new int[]{0}).equalTo(new int[]{0}).with(new ForwardedBothAnnotationJoin()).withForwardedFieldsFirst(new String[]{"0->1;"});
    }

    private static /* synthetic */ void lambda$testBinaryForwardedOverwritingInLine2$3(DataSet input1, DataSet input2) throws Throwable {
        JoinOperator cfr_ignored_0 = (JoinOperator)input1.join(input2).where(new int[]{0}).equalTo(new int[]{0}).with(new ForwardedSecondAnnotationJoin()).withForwardedFieldsSecond(new String[]{"0->1"});
    }

    private static /* synthetic */ void lambda$testBinaryForwardedOverwritingInLine1$2(DataSet input1, DataSet input2) throws Throwable {
        JoinOperator cfr_ignored_0 = (JoinOperator)input1.join(input2).where(new int[]{0}).equalTo(new int[]{0}).with(new ForwardedFirstAnnotationJoin()).withForwardedFieldsFirst(new String[]{"0->1"});
    }

    private static /* synthetic */ void lambda$testUnaryForwardedOverwritingInLine2$1(DataSet input) throws Throwable {
        MapOperator cfr_ignored_0 = (MapOperator)input.map(new AllForwardedExceptMapper()).withForwardedFields(new String[]{"0->1; 2"});
    }

    private static /* synthetic */ void lambda$testUnaryForwardedOverwritingInLine1$0(DataSet input) throws Throwable {
        MapOperator cfr_ignored_0 = (MapOperator)input.map(new WildcardForwardedMapper()).withForwardedFields(new String[]{"0->1; 2"});
    }

    @FunctionAnnotation.ReadFieldsFirst(value={"1"})
    @FunctionAnnotation.ReadFieldsSecond(value={"0"})
    private static class ReadSetJoin<X>
    implements JoinFunction<Tuple2<X, X>, Tuple2<X, X>, Tuple3<X, X, X>> {
        private ReadSetJoin() {
        }

        public Tuple3<X, X, X> join(Tuple2<X, X> first, Tuple2<X, X> second) throws Exception {
            return null;
        }
    }

    @FunctionAnnotation.NonForwardedFieldsFirst(value={"0;2"})
    @FunctionAnnotation.NonForwardedFieldsSecond(value={"0;1"})
    private static class AllForwardedExceptJoin<X>
    implements JoinFunction<Tuple3<X, X, X>, Tuple3<X, X, X>, Tuple3<X, X, X>> {
        private AllForwardedExceptJoin() {
        }

        public Tuple3<X, X, X> join(Tuple3<X, X, X> first, Tuple3<X, X, X> second) throws Exception {
            return null;
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"1 -> 0"})
    @FunctionAnnotation.ForwardedFieldsSecond(value={"1 -> 1"})
    private static class ForwardedBothAnnotationJoin<A, B, C, D>
    implements JoinFunction<Tuple2<A, B>, Tuple2<C, D>, Tuple2<B, D>> {
        private ForwardedBothAnnotationJoin() {
        }

        public Tuple2<B, D> join(Tuple2<A, B> first, Tuple2<C, D> second) {
            return new Tuple2(first.f1, second.f1);
        }
    }

    @FunctionAnnotation.ForwardedFieldsSecond(value={"1->2"})
    private static class ForwardedSecondAnnotationJoin<X>
    implements JoinFunction<Tuple2<X, X>, Tuple2<X, X>, Tuple3<X, X, X>> {
        private ForwardedSecondAnnotationJoin() {
        }

        public Tuple3<X, X, X> join(Tuple2<X, X> first, Tuple2<X, X> second) throws Exception {
            return null;
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"0->2"})
    private static class ForwardedFirstAnnotationJoin<X>
    implements JoinFunction<Tuple2<X, X>, Tuple2<X, X>, Tuple3<X, X, X>> {
        private ForwardedFirstAnnotationJoin() {
        }

        public Tuple3<X, X, X> join(Tuple2<X, X> first, Tuple2<X, X> second) throws Exception {
            return null;
        }
    }

    private static class NoAnnotationJoin<X>
    implements JoinFunction<Tuple2<X, X>, Tuple2<X, X>, Tuple3<X, X, X>> {
        private NoAnnotationJoin() {
        }

        public Tuple3<X, X, X> join(Tuple2<X, X> first, Tuple2<X, X> second) throws Exception {
            return null;
        }
    }

    @FunctionAnnotation.ReadFields(value={"0;2"})
    private static class ReadSetMapper<T>
    implements MapFunction<T, T> {
        private ReadSetMapper() {
        }

        public T map(T value) {
            return value;
        }
    }

    @FunctionAnnotation.NonForwardedFields(value={"1"})
    private static class AllForwardedExceptMapper<T>
    implements MapFunction<T, T> {
        private AllForwardedExceptMapper() {
        }

        public T map(T value) {
            return value;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0->2;1->0;2->1"})
    private static class ShufflingMapper<X>
    implements MapFunction<Tuple3<X, X, X>, Tuple3<X, X, X>> {
        private ShufflingMapper() {
        }

        public Tuple3<X, X, X> map(Tuple3<X, X, X> value) {
            return value;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"0;2"})
    private static class IndividualForwardedMapper<X, Y, Z>
    implements MapFunction<Tuple3<X, Y, Z>, Tuple3<X, Y, Z>> {
        private IndividualForwardedMapper() {
        }

        public Tuple3<X, Y, Z> map(Tuple3<X, Y, Z> value) {
            return value;
        }
    }

    @FunctionAnnotation.ForwardedFields(value={"*"})
    private static class WildcardForwardedMapper<T>
    implements MapFunction<T, T> {
        private WildcardForwardedMapper() {
        }

        public T map(T value) {
            return value;
        }
    }

    private static class NoAnnotationMapper<T>
    implements MapFunction<T, T> {
        private NoAnnotationMapper() {
        }

        public T map(T value) {
            return value;
        }
    }
}

