/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.functions;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.base.CrossOperatorBase;
import org.apache.flink.api.common.operators.base.InnerJoinOperatorBase;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.translation.PlanProjectOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SemanticPropertiesProjectionTest {
    final List<Tuple5<Integer, Long, String, Long, Integer>> emptyTupleData = new ArrayList<Tuple5<Integer, Long, String, Long, Integer>>();
    final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    final List<Tuple4<Integer, Tuple3<String, Integer, Long>, Tuple2<Long, Long>, String>> emptyNestedTupleData = new ArrayList<Tuple4<Integer, Tuple3<String, Integer, Long>, Tuple2<Long, Long>, String>>();
    final TupleTypeInfo<Tuple4<Integer, Tuple3<String, Integer, Long>, Tuple2<Long, Long>, String>> nestedTupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO}), new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO}), BasicTypeInfo.STRING_TYPE_INFO});

    SemanticPropertiesProjectionTest() {
    }

    @Test
    void testProjectionSemProps1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        tupleDs.project(new int[]{1, 3, 2, 0, 3}).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        PlanProjectOperator projectOperator = (PlanProjectOperator)sink.getInput();
        SingleInputSemanticProperties props = projectOperator.getSemanticProperties();
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(0, 0)).containsExactly((Object[])new Integer[]{3});
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(0, 1)).containsExactly((Object[])new Integer[]{0});
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(0, 2)).containsExactly((Object[])new Integer[]{2});
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(0, 3)).containsExactly((Object[])new Integer[]{4, 1});
    }

    @Test
    void testProjectionSemProps2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyNestedTupleData, this.nestedTupleTypeInfo);
        tupleDs.project(new int[]{2, 3, 1, 2}).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        PlanProjectOperator projectOperator = (PlanProjectOperator)sink.getInput();
        SingleInputSemanticProperties props = projectOperator.getSemanticProperties();
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(0, 0)).isEmpty();
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(0, 1)).containsExactly((Object[])new Integer[]{3});
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(0, 2)).containsExactly((Object[])new Integer[]{4});
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(0, 3)).containsExactly((Object[])new Integer[]{5});
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(0, 4)).containsExactly((Object[])new Integer[]{0, 6});
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(0, 5)).containsExactly((Object[])new Integer[]{1, 7});
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(0, 6)).containsExactly((Object[])new Integer[]{2});
    }

    @Test
    void testJoinProjectionSemProps1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        tupleDs.join((DataSet)tupleDs).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{2, 3}).projectSecond(new int[]{1, 4}).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        InnerJoinOperatorBase projectJoinOperator = (InnerJoinOperatorBase)sink.getInput();
        DualInputSemanticProperties props = projectJoinOperator.getSemanticProperties();
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(0, 2)).containsExactly((Object[])new Integer[]{0});
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(0, 3)).containsExactly((Object[])new Integer[]{1});
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(1, 1)).containsExactly((Object[])new Integer[]{2});
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(1, 4)).containsExactly((Object[])new Integer[]{3});
    }

    @Test
    void testJoinProjectionSemProps2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyNestedTupleData, this.nestedTupleTypeInfo);
        tupleDs.join((DataSet)tupleDs).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{2, 0}).projectSecond(new int[]{1, 3}).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        InnerJoinOperatorBase projectJoinOperator = (InnerJoinOperatorBase)sink.getInput();
        DualInputSemanticProperties props = projectJoinOperator.getSemanticProperties();
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(0, 0)).containsExactly((Object[])new Integer[]{2});
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(0, 1)).isEmpty();
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(0, 2)).isEmpty();
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(0, 3)).isEmpty();
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(0, 4)).containsExactly((Object[])new Integer[]{0});
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(0, 5)).containsExactly((Object[])new Integer[]{1});
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(0, 6)).isEmpty();
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(1, 0)).isEmpty();
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(1, 1)).containsExactly((Object[])new Integer[]{3});
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(1, 2)).containsExactly((Object[])new Integer[]{4});
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(1, 3)).containsExactly((Object[])new Integer[]{5});
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(1, 4)).isEmpty();
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(1, 5)).isEmpty();
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(1, 6)).containsExactly((Object[])new Integer[]{6});
    }

    @Test
    void testCrossProjectionSemProps1() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyTupleData, this.tupleTypeInfo);
        tupleDs.cross((DataSet)tupleDs).projectFirst(new int[]{2, 3}).projectSecond(new int[]{1, 4}).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        CrossOperatorBase projectCrossOperator = (CrossOperatorBase)sink.getInput();
        DualInputSemanticProperties props = projectCrossOperator.getSemanticProperties();
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(0, 2)).containsExactly((Object[])new Integer[]{0});
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(0, 3)).containsExactly((Object[])new Integer[]{1});
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(1, 1)).containsExactly((Object[])new Integer[]{2});
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(1, 4)).containsExactly((Object[])new Integer[]{3});
    }

    @Test
    void testCrossProjectionSemProps2() {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        DataSource tupleDs = env.fromCollection(this.emptyNestedTupleData, this.nestedTupleTypeInfo);
        tupleDs.cross((DataSet)tupleDs).projectFirst(new int[]{2, 0}).projectSecond(new int[]{1, 3}).output((OutputFormat)new DiscardingOutputFormat());
        Plan plan = env.createProgramPlan();
        GenericDataSinkBase sink = (GenericDataSinkBase)plan.getDataSinks().iterator().next();
        CrossOperatorBase projectCrossOperator = (CrossOperatorBase)sink.getInput();
        DualInputSemanticProperties props = projectCrossOperator.getSemanticProperties();
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(0, 0)).containsExactly((Object[])new Integer[]{2});
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(0, 1)).isEmpty();
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(0, 2)).isEmpty();
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(0, 3)).isEmpty();
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(0, 4)).containsExactly((Object[])new Integer[]{0});
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(0, 5)).containsExactly((Object[])new Integer[]{1});
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(0, 6)).isEmpty();
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(1, 0)).isEmpty();
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(1, 1)).containsExactly((Object[])new Integer[]{3});
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(1, 2)).containsExactly((Object[])new Integer[]{4});
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(1, 3)).containsExactly((Object[])new Integer[]{5});
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(1, 4)).isEmpty();
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(1, 5)).isEmpty();
        Assertions.assertThat((Iterable)props.getForwardingTargetFields(1, 6)).containsExactly((Object[])new Integer[]{6});
    }
}

