/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.functions;

import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.SelectByMaxFunction;
import org.apache.flink.api.java.functions.SelectByMinFunction;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class SelectByFunctionsTest {
    private final TupleTypeInfo<Tuple5<Integer, Long, String, Long, Integer>> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private final Tuple5<Integer, Long, String, Long, Integer> bigger = new Tuple5((Object)10, (Object)100L, (Object)"HelloWorld", (Object)200L, (Object)20);
    private final Tuple5<Integer, Long, String, Long, Integer> smaller = new Tuple5((Object)5, (Object)50L, (Object)"Hello", (Object)50L, (Object)15);
    private final Tuple5<Integer, Long, String, Long, Integer> specialCaseBigger = new Tuple5((Object)10, (Object)100L, (Object)"HelloWorld", (Object)200L, (Object)17);
    private final Tuple5<Integer, Long, String, Long, Integer> specialCaseSmaller = new Tuple5((Object)5, (Object)50L, (Object)"Hello", (Object)50L, (Object)17);

    SelectByFunctionsTest() {
    }

    @Test
    void testMaxByComparison() {
        SelectByMaxFunction maxByTuple = new SelectByMaxFunction(this.tupleTypeInfo, new int[]{0});
        try {
            ((ObjectAssert)Assertions.assertThat((Object)maxByTuple.reduce(this.smaller, this.bigger)).as("SelectByMax must return bigger tuple", new Object[0])).isSameAs(this.bigger);
            ((ObjectAssert)Assertions.assertThat((Object)maxByTuple.reduce(this.bigger, this.smaller)).as("SelectByMax must return bigger tuple", new Object[0])).isSameAs(this.bigger);
        }
        catch (Exception e) {
            Assertions.fail((String)"No exception should be thrown while comparing both tuples");
        }
    }

    @Test
    void testMaxByComparisonSpecialCase1() {
        SelectByMaxFunction maxByTuple = new SelectByMaxFunction(this.tupleTypeInfo, new int[]{0, 3});
        try {
            ((ObjectAssert)Assertions.assertThat((Object)maxByTuple.reduce(this.specialCaseBigger, this.bigger)).as("SelectByMax must return the first given tuple", new Object[0])).isSameAs(this.specialCaseBigger);
            ((ObjectAssert)Assertions.assertThat((Object)maxByTuple.reduce(this.bigger, this.specialCaseBigger)).as("SelectByMax must return the first given tuple", new Object[0])).isSameAs(this.bigger);
        }
        catch (Exception e) {
            Assertions.fail((String)"No exception should be thrown while comparing both tuples");
        }
    }

    @Test
    void testMaxByComparisonSpecialCase2() {
        SelectByMaxFunction maxByTuple = new SelectByMaxFunction(this.tupleTypeInfo, new int[]{0, 2, 1, 4, 3});
        try {
            ((ObjectAssert)Assertions.assertThat((Object)maxByTuple.reduce(this.specialCaseBigger, this.bigger)).as("SelectByMax must return bigger tuple", new Object[0])).isSameAs(this.bigger);
            ((ObjectAssert)Assertions.assertThat((Object)maxByTuple.reduce(this.bigger, this.specialCaseBigger)).as("SelectByMax must return bigger tuple", new Object[0])).isSameAs(this.bigger);
        }
        catch (Exception e) {
            Assertions.fail((String)"No exception should be thrown while comparing both tuples");
        }
    }

    @Test
    void testMaxByComparisonMultiple() {
        SelectByMaxFunction maxByTuple = new SelectByMaxFunction(this.tupleTypeInfo, new int[]{0, 1, 2, 3, 4});
        try {
            ((ObjectAssert)Assertions.assertThat((Object)maxByTuple.reduce(this.smaller, this.bigger)).as("SelectByMax must return bigger tuple", new Object[0])).isSameAs(this.bigger);
            ((ObjectAssert)Assertions.assertThat((Object)maxByTuple.reduce(this.bigger, this.smaller)).as("SelectByMax must return bigger tuple", new Object[0])).isSameAs(this.bigger);
        }
        catch (Exception e) {
            Assertions.fail((String)"No exception should be thrown while comparing both tuples");
        }
    }

    @Test
    void testMaxByComparisonMustReturnATuple() {
        SelectByMaxFunction maxByTuple = new SelectByMaxFunction(this.tupleTypeInfo, new int[]{0});
        try {
            ((ObjectAssert)Assertions.assertThat((Object)maxByTuple.reduce(this.bigger, this.bigger)).as("SelectByMax must return bigger tuple", new Object[0])).isSameAs(this.bigger);
            ((ObjectAssert)Assertions.assertThat((Object)maxByTuple.reduce(this.smaller, this.smaller)).as("SelectByMax must return smaller tuple", new Object[0])).isSameAs(this.smaller);
        }
        catch (Exception e) {
            Assertions.fail((String)"No exception should be thrown while comparing both tuples");
        }
    }

    @Test
    void testMinByComparison() {
        SelectByMinFunction minByTuple = new SelectByMinFunction(this.tupleTypeInfo, new int[]{0});
        try {
            ((ObjectAssert)Assertions.assertThat((Object)minByTuple.reduce(this.smaller, this.bigger)).as("SelectByMin must return smaller tuple", new Object[0])).isSameAs(this.smaller);
            ((ObjectAssert)Assertions.assertThat((Object)minByTuple.reduce(this.bigger, this.smaller)).as("SelectByMin must return smaller tuple", new Object[0])).isSameAs(this.smaller);
        }
        catch (Exception e) {
            Assertions.fail((String)"No exception should be thrown while comparing both tuples");
        }
    }

    @Test
    void testMinByComparisonSpecialCase1() {
        SelectByMinFunction minByTuple = new SelectByMinFunction(this.tupleTypeInfo, new int[]{0, 3});
        try {
            ((ObjectAssert)Assertions.assertThat((Object)minByTuple.reduce(this.specialCaseBigger, this.bigger)).as("SelectByMin must return the first given tuple", new Object[0])).isSameAs(this.specialCaseBigger);
            ((ObjectAssert)Assertions.assertThat((Object)minByTuple.reduce(this.bigger, this.specialCaseBigger)).as("SelectByMin must return the first given tuple", new Object[0])).isSameAs(this.bigger);
        }
        catch (Exception e) {
            Assertions.fail((String)"No exception should be thrown while comparing both tuples");
        }
    }

    @Test
    void testMinByComparisonSpecialCase2() {
        SelectByMinFunction minByTuple = new SelectByMinFunction(this.tupleTypeInfo, new int[]{0, 2, 1, 4, 3});
        try {
            ((ObjectAssert)Assertions.assertThat((Object)minByTuple.reduce(this.specialCaseSmaller, this.smaller)).as("SelectByMin must return smaller tuple", new Object[0])).isSameAs(this.smaller);
            ((ObjectAssert)Assertions.assertThat((Object)minByTuple.reduce(this.smaller, this.specialCaseSmaller)).as("SelectByMin must return smaller tuple", new Object[0])).isSameAs(this.smaller);
        }
        catch (Exception e) {
            Assertions.fail((String)"No exception should be thrown while comparing both tuples");
        }
    }

    @Test
    void testMinByComparisonMultiple() {
        SelectByMinFunction minByTuple = new SelectByMinFunction(this.tupleTypeInfo, new int[]{0, 1, 2, 3, 4});
        try {
            ((ObjectAssert)Assertions.assertThat((Object)minByTuple.reduce(this.smaller, this.bigger)).as("SelectByMin must return smaller tuple", new Object[0])).isSameAs(this.smaller);
            ((ObjectAssert)Assertions.assertThat((Object)minByTuple.reduce(this.bigger, this.smaller)).as("SelectByMin must return smaller tuple", new Object[0])).isSameAs(this.smaller);
        }
        catch (Exception e) {
            Assertions.fail((String)"No exception should be thrown while comparing both tuples");
        }
    }
}

