/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.TaskInfoImpl;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichReduceFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.RuntimeUDFContext;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.ReduceOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ReduceOperatorTest
implements Serializable {
    private static final TypeInformation<Tuple2<String, Integer>> STRING_INT_TUPLE = TypeInformation.of((TypeHint)new TypeHint<Tuple2<String, Integer>>(){});

    ReduceOperatorTest() {
    }

    @Test
    void testReduceCollection() {
        try {
            ReduceFunction & Serializable reducer = (ReduceFunction & Serializable)(value1, value2) -> new Tuple2(value1.f0, (Object)((Integer)value1.f1 + (Integer)value2.f1));
            ReduceOperatorBase op = new ReduceOperatorBase((ReduceFunction)reducer, new UnaryOperatorInformation(STRING_INT_TUPLE, STRING_INT_TUPLE), new int[]{0}, "TestReducer");
            ArrayList<Tuple2> input = new ArrayList<Tuple2>(Arrays.asList(new Tuple2((Object)"foo", (Object)1), new Tuple2((Object)"foo", (Object)3), new Tuple2((Object)"bar", (Object)2), new Tuple2((Object)"bar", (Object)4)));
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.disableObjectReuse();
            List resultMutableSafe = op.executeOnCollections(input, null, executionConfig);
            executionConfig.enableObjectReuse();
            List resultRegular = op.executeOnCollections(input, null, executionConfig);
            HashSet resultSetMutableSafe = new HashSet(resultMutableSafe);
            HashSet resultSetRegular = new HashSet(resultRegular);
            HashSet<Tuple2> expectedResult = new HashSet<Tuple2>(Arrays.asList(new Tuple2((Object)"foo", (Object)4), new Tuple2((Object)"bar", (Object)6)));
            Assertions.assertThat(resultSetMutableSafe).isEqualTo(expectedResult);
            Assertions.assertThat(resultSetRegular).isEqualTo(expectedResult);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void testReduceCollectionWithRuntimeContext() {
        try {
            String taskName = "Test Task";
            final AtomicBoolean opened = new AtomicBoolean();
            final AtomicBoolean closed = new AtomicBoolean();
            RichReduceFunction<Tuple2<String, Integer>> reducer = new RichReduceFunction<Tuple2<String, Integer>>(){

                public Tuple2<String, Integer> reduce(Tuple2<String, Integer> value1, Tuple2<String, Integer> value2) throws Exception {
                    return new Tuple2(value1.f0, (Object)((Integer)value1.f1 + (Integer)value2.f1));
                }

                public void open(OpenContext openContext) throws Exception {
                    opened.set(true);
                    RuntimeContext ctx = this.getRuntimeContext();
                    Assertions.assertThat((int)ctx.getTaskInfo().getIndexOfThisSubtask()).isZero();
                    Assertions.assertThat((int)ctx.getTaskInfo().getNumberOfParallelSubtasks()).isOne();
                    Assertions.assertThat((String)ctx.getTaskInfo().getTaskName()).isEqualTo("Test Task");
                }

                public void close() throws Exception {
                    closed.set(true);
                }
            };
            ReduceOperatorBase op = new ReduceOperatorBase((ReduceFunction)reducer, new UnaryOperatorInformation(STRING_INT_TUPLE, STRING_INT_TUPLE), new int[]{0}, "TestReducer");
            ArrayList<Tuple2> input = new ArrayList<Tuple2>(Arrays.asList(new Tuple2((Object)"foo", (Object)1), new Tuple2((Object)"foo", (Object)3), new Tuple2((Object)"bar", (Object)2), new Tuple2((Object)"bar", (Object)4)));
            TaskInfoImpl taskInfo = new TaskInfoImpl("Test Task", 1, 0, 1, 0);
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.disableObjectReuse();
            List resultMutableSafe = op.executeOnCollections(input, (RuntimeContext)new RuntimeUDFContext((TaskInfo)taskInfo, null, executionConfig, new HashMap(), new HashMap(), UnregisteredMetricsGroup.createOperatorMetricGroup()), executionConfig);
            executionConfig.enableObjectReuse();
            List resultRegular = op.executeOnCollections(input, (RuntimeContext)new RuntimeUDFContext((TaskInfo)taskInfo, null, executionConfig, new HashMap(), new HashMap(), UnregisteredMetricsGroup.createOperatorMetricGroup()), executionConfig);
            HashSet resultSetMutableSafe = new HashSet(resultMutableSafe);
            HashSet resultSetRegular = new HashSet(resultRegular);
            HashSet<Tuple2> expectedResult = new HashSet<Tuple2>(Arrays.asList(new Tuple2((Object)"foo", (Object)4), new Tuple2((Object)"bar", (Object)6)));
            Assertions.assertThat(resultSetMutableSafe).isEqualTo(expectedResult);
            Assertions.assertThat(resultSetRegular).isEqualTo(expectedResult);
            Assertions.assertThat((boolean)opened.get()).isTrue();
            Assertions.assertThat((boolean)closed.get()).isTrue();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }
}

