/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.accumulators.IntCounter;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.CollectionEnvironment;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CollectionExecutionAccumulatorsTest {
    private static final String ACCUMULATOR_NAME = "TEST ACC";

    CollectionExecutionAccumulatorsTest() {
    }

    @Test
    void testAccumulator() {
        try {
            int numElements = 100;
            CollectionEnvironment env = ExecutionEnvironment.createCollectionsEnvironment();
            env.generateSequence(1L, 100L).map((MapFunction)new CountingMapper()).output((OutputFormat)new DiscardingOutputFormat());
            JobExecutionResult result = env.execute();
            Assertions.assertThat((long)result.getNetRuntime()).isGreaterThanOrEqualTo(0L);
            Assertions.assertThat((int)((Integer)result.getAccumulatorResult(ACCUMULATOR_NAME))).isEqualTo(100);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    private static class CountingMapper
    extends RichMapFunction<Long, Long> {
        private IntCounter accumulator;

        private CountingMapper() {
        }

        public void open(OpenContext openContext) {
            this.accumulator = this.getRuntimeContext().getIntCounter(CollectionExecutionAccumulatorsTest.ACCUMULATOR_NAME);
        }

        public Long map(Long value) {
            this.accumulator.add(1);
            return value;
        }
    }
}

