/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.summarize.aggregation.Aggregator;
import org.apache.flink.api.java.summarize.aggregation.NumericSummaryAggregator;

@Internal
public class LongSummaryAggregator
extends NumericSummaryAggregator<Long> {
    private static final long serialVersionUID = 1L;

    @Override
    protected Aggregator<Long, Long> initMin() {
        return new MinLongAggregator();
    }

    @Override
    protected Aggregator<Long, Long> initMax() {
        return new MaxLongAggregator();
    }

    @Override
    protected Aggregator<Long, Long> initSum() {
        return new SumLongAggregator();
    }

    @Override
    protected boolean isNan(Long number) {
        return false;
    }

    @Override
    protected boolean isInfinite(Long number) {
        return false;
    }

    public static class SumLongAggregator
    implements Aggregator<Long, Long> {
        private long sum = 0L;

        @Override
        public void aggregate(Long value) {
            this.sum += value.longValue();
        }

        @Override
        public void combine(Aggregator<Long, Long> other) {
            this.sum += ((SumLongAggregator)other).sum;
        }

        @Override
        public Long result() {
            return this.sum;
        }
    }

    public static class MaxLongAggregator
    implements Aggregator<Long, Long> {
        private long max = Long.MIN_VALUE;

        @Override
        public void aggregate(Long value) {
            this.max = Math.max(this.max, value);
        }

        @Override
        public void combine(Aggregator<Long, Long> other) {
            this.max = Math.max(this.max, ((MaxLongAggregator)other).max);
        }

        @Override
        public Long result() {
            return this.max;
        }
    }

    public static class MinLongAggregator
    implements Aggregator<Long, Long> {
        private long min = Long.MAX_VALUE;

        @Override
        public void aggregate(Long value) {
            this.min = Math.min(this.min, value);
        }

        @Override
        public void combine(Aggregator<Long, Long> other) {
            this.min = Math.min(this.min, ((MinLongAggregator)other).min);
        }

        @Override
        public Long result() {
            return this.min;
        }
    }
}

