/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.CodeAnalysisMode;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.operators.Keys;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.operators.TwoInputUdfOperator;
import org.apache.flink.api.java.sca.CodeAnalyzerException;
import org.apache.flink.api.java.sca.UdfAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class UdfOperatorUtils {
    private static final Logger LOG = LoggerFactory.getLogger(UdfOperatorUtils.class);

    public static void analyzeSingleInputUdf(SingleInputUdfOperator<?, ?, ?> operator, Class<?> udfBaseClass, String defaultName, Function udf, Keys<?> key) {
        CodeAnalysisMode mode = operator.getExecutionEnvironment().getConfig().getCodeAnalysisMode();
        if (mode != CodeAnalysisMode.DISABLE && !udf.getClass().isAnnotationPresent(FunctionAnnotation.SkipCodeAnalysis.class)) {
            String operatorName = operator.getName() != null ? operator.getName() : udfBaseClass.getSimpleName() + " at " + defaultName;
            try {
                UdfAnalyzer analyzer = new UdfAnalyzer(udfBaseClass, udf.getClass(), operatorName, operator.getInputType(), null, operator.getResultType(), key, null, mode == CodeAnalysisMode.OPTIMIZE);
                boolean success = analyzer.analyze();
                if (success) {
                    if (mode == CodeAnalysisMode.OPTIMIZE && !operator.udfWithForwardedFieldsAnnotation(udf.getClass())) {
                        analyzer.addSemanticPropertiesHints();
                        operator.setSemanticProperties((SingleInputSemanticProperties)analyzer.getSemanticProperties());
                        operator.setAnalyzedUdfSemanticsFlag();
                    } else if (mode == CodeAnalysisMode.HINT) {
                        analyzer.addSemanticPropertiesHints();
                    }
                    analyzer.printToLogger(LOG);
                }
            }
            catch (InvalidTypesException e) {
                LOG.debug("Unable to do code analysis due to missing type information.", (Throwable)e);
            }
            catch (CodeAnalyzerException e) {
                LOG.debug("Code analysis failed.", (Throwable)e);
            }
        }
    }

    public static void analyzeDualInputUdf(TwoInputUdfOperator<?, ?, ?, ?> operator, Class<?> udfBaseClass, String defaultName, Function udf, Keys<?> key1, Keys<?> key2) {
        CodeAnalysisMode mode = operator.getExecutionEnvironment().getConfig().getCodeAnalysisMode();
        if (mode != CodeAnalysisMode.DISABLE && !udf.getClass().isAnnotationPresent(FunctionAnnotation.SkipCodeAnalysis.class)) {
            String operatorName = operator.getName() != null ? operator.getName() : udfBaseClass.getSimpleName() + " at " + defaultName;
            try {
                UdfAnalyzer analyzer = new UdfAnalyzer(udfBaseClass, udf.getClass(), operatorName, operator.getInput1Type(), operator.getInput2Type(), operator.getResultType(), key1, key2, mode == CodeAnalysisMode.OPTIMIZE);
                boolean success = analyzer.analyze();
                if (success) {
                    if (mode == CodeAnalysisMode.OPTIMIZE && !operator.udfWithForwardedFieldsFirstAnnotation(udf.getClass()) && !operator.udfWithForwardedFieldsSecondAnnotation(udf.getClass())) {
                        analyzer.addSemanticPropertiesHints();
                        operator.setSemanticProperties((DualInputSemanticProperties)analyzer.getSemanticProperties());
                        operator.setAnalyzedUdfSemanticsFlag();
                    } else if (mode == CodeAnalysisMode.HINT) {
                        analyzer.addSemanticPropertiesHints();
                    }
                    analyzer.printToLogger(LOG);
                }
            }
            catch (InvalidTypesException e) {
                LOG.debug("Unable to do code analysis due to missing type information.", (Throwable)e);
            }
            catch (CodeAnalyzerException e) {
                LOG.debug("Code analysis failed.", (Throwable)e);
            }
        }
    }

    private UdfOperatorUtils() {
        throw new RuntimeException();
    }
}

