/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class PojoSerializer<T>
extends TypeSerializer<T> {
    private static byte IS_NULL = 1;
    private static byte NO_SUBCLASS = (byte)2;
    private static byte IS_SUBCLASS = (byte)4;
    private static byte IS_TAGGED_SUBCLASS = (byte)8;
    private static final long serialVersionUID = 1L;
    private final Class<T> clazz;
    private TypeSerializer<Object>[] fieldSerializers;
    private transient Field[] fields;
    private int numFields;
    private transient Map<Class<?>, TypeSerializer<?>> subclassSerializerCache;
    private transient ClassLoader cl;
    private Map<Class<?>, Integer> registeredClasses;
    private TypeSerializer<?>[] registeredSerializers;
    private final ExecutionConfig executionConfig;

    public PojoSerializer(Class<T> clazz, TypeSerializer<?>[] fieldSerializers, Field[] fields, ExecutionConfig executionConfig) {
        this.clazz = clazz;
        this.fieldSerializers = fieldSerializers;
        this.fields = fields;
        this.numFields = fieldSerializers.length;
        this.executionConfig = executionConfig;
        LinkedHashSet registeredPojoTypes = executionConfig.getRegisteredPojoTypes();
        for (int i = 0; i < this.numFields; ++i) {
            this.fields[i].setAccessible(true);
        }
        this.cl = Thread.currentThread().getContextClassLoader();
        this.subclassSerializerCache = new HashMap();
        ArrayList<Class> cleanedTaggedClasses = new ArrayList<Class>(registeredPojoTypes.size());
        for (Class registeredClass : registeredPojoTypes) {
            if (registeredClass.equals(clazz) || !clazz.isAssignableFrom(registeredClass)) continue;
            cleanedTaggedClasses.add(registeredClass);
        }
        this.registeredClasses = new LinkedHashMap(cleanedTaggedClasses.size());
        this.registeredSerializers = new TypeSerializer[cleanedTaggedClasses.size()];
        int id = 0;
        for (Class registeredClass : cleanedTaggedClasses) {
            this.registeredClasses.put(registeredClass, id);
            TypeInformation<?> typeInfo = TypeExtractor.createTypeInfo(registeredClass);
            this.registeredSerializers[id] = typeInfo.createSerializer(executionConfig);
            ++id;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        out.defaultWriteObject();
        out.writeInt(this.fields.length);
        for (Field field : this.fields) {
            out.writeObject(field.getDeclaringClass());
            out.writeUTF(field.getName());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int numFields = in.readInt();
        this.fields = new Field[numFields];
        for (int i = 0; i < numFields; ++i) {
            String fieldName = in.readUTF();
            this.fields[i] = null;
            for (Class clazz = (Class)in.readObject(); clazz != null; clazz = clazz.getSuperclass()) {
                try {
                    this.fields[i] = clazz.getDeclaredField(fieldName);
                    this.fields[i].setAccessible(true);
                    break;
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
            }
            if (this.fields[i] != null) continue;
            throw new RuntimeException("Class resolved at TaskManager is not compatible with class read during Plan setup. (" + fieldName + ")");
        }
        this.cl = Thread.currentThread().getContextClassLoader();
        this.subclassSerializerCache = new HashMap();
    }

    private TypeSerializer<?> getSubclassSerializer(Class<?> subclass) {
        TypeSerializer result = this.subclassSerializerCache.get(subclass);
        if (result == null) {
            TypeInformation<?> typeInfo = TypeExtractor.createTypeInfo(subclass);
            result = typeInfo.createSerializer(this.executionConfig);
            if (result instanceof PojoSerializer) {
                PojoSerializer subclassSerializer = (PojoSerializer)result;
                subclassSerializer.copyBaseFieldOrder(this);
            }
            this.subclassSerializerCache.put(subclass, result);
        }
        return result;
    }

    private boolean hasField(Field f) {
        for (Field field : this.fields) {
            if (!f.equals(field)) continue;
            return true;
        }
        return false;
    }

    private void copyBaseFieldOrder(PojoSerializer<?> baseSerializer) {
    }

    public boolean isImmutableType() {
        return false;
    }

    public PojoSerializer<T> duplicate() {
        boolean stateful = false;
        TypeSerializer[] duplicateFieldSerializers = new TypeSerializer[this.fieldSerializers.length];
        for (int i = 0; i < this.fieldSerializers.length; ++i) {
            duplicateFieldSerializers[i] = this.fieldSerializers[i].duplicate();
            if (duplicateFieldSerializers[i] == this.fieldSerializers[i]) continue;
            stateful = true;
        }
        if (stateful) {
            return new PojoSerializer<T>(this.clazz, duplicateFieldSerializers, this.fields, this.executionConfig);
        }
        return this;
    }

    public T createInstance() {
        if (this.clazz.isInterface() || Modifier.isAbstract(this.clazz.getModifiers())) {
            return null;
        }
        try {
            T t = this.clazz.newInstance();
            this.initializeFields(t);
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate class.", e);
        }
    }

    protected void initializeFields(T t) {
        for (int i = 0; i < this.numFields; ++i) {
            try {
                this.fields[i].set(t, this.fieldSerializers[i].createInstance());
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Cannot initialize fields.", e);
            }
        }
    }

    public T copy(T from) {
        if (from == null) {
            return null;
        }
        Class<?> actualType = from.getClass();
        if (actualType == this.clazz) {
            Object target;
            try {
                target = from.getClass().newInstance();
            }
            catch (Throwable t) {
                throw new RuntimeException("Cannot instantiate class.", t);
            }
            try {
                for (int i = 0; i < this.numFields; ++i) {
                    Object value = this.fields[i].get(from);
                    if (value != null) {
                        Object copy = this.fieldSerializers[i].copy(value);
                        this.fields[i].set(target, copy);
                        continue;
                    }
                    this.fields[i].set(target, null);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error during POJO copy, this should not happen since we check the fields before.");
            }
            return (T)target;
        }
        TypeSerializer<?> subclassSerializer = this.getSubclassSerializer(actualType);
        return (T)subclassSerializer.copy(from);
    }

    public T copy(T from, T reuse) {
        if (from == null) {
            return null;
        }
        Class<?> actualType = from.getClass();
        if (reuse == null || actualType != reuse.getClass()) {
            return this.copy(from);
        }
        if (actualType == this.clazz) {
            try {
                for (int i = 0; i < this.numFields; ++i) {
                    Object value = this.fields[i].get(from);
                    if (value != null) {
                        Object reuseValue = this.fields[i].get(reuse);
                        Object copy = reuseValue != null ? this.fieldSerializers[i].copy(value, reuseValue) : this.fieldSerializers[i].copy(value);
                        this.fields[i].set(reuse, copy);
                        continue;
                    }
                    this.fields[i].set(reuse, null);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error during POJO copy, this should not happen since we check the fieldsbefore.");
            }
        } else {
            TypeSerializer<?> subclassSerializer = this.getSubclassSerializer(actualType);
            reuse = subclassSerializer.copy(from, reuse);
        }
        return reuse;
    }

    public int getLength() {
        return -1;
    }

    public void serialize(T value, DataOutputView target) throws IOException {
        int flags = 0;
        if (value == null) {
            target.writeByte(flags |= IS_NULL);
            return;
        }
        Integer subclassTag = -1;
        Class<?> actualClass = value.getClass();
        TypeSerializer<?> subclassSerializer = null;
        if (this.clazz != actualClass) {
            subclassTag = this.registeredClasses.get(actualClass);
            if (subclassTag != null) {
                flags |= IS_TAGGED_SUBCLASS;
                subclassSerializer = this.registeredSerializers[subclassTag];
            } else {
                flags |= IS_SUBCLASS;
                subclassSerializer = this.getSubclassSerializer(actualClass);
            }
        } else {
            flags |= NO_SUBCLASS;
        }
        target.writeByte(flags);
        if ((flags & IS_SUBCLASS) != 0) {
            target.writeUTF(actualClass.getName());
        } else if ((flags & IS_TAGGED_SUBCLASS) != 0) {
            target.writeByte(subclassTag.intValue());
        }
        if ((flags & NO_SUBCLASS) != 0) {
            try {
                for (int i = 0; i < this.numFields; ++i) {
                    Object o = this.fields[i].get(value);
                    if (o == null) {
                        target.writeBoolean(true);
                        continue;
                    }
                    target.writeBoolean(false);
                    this.fieldSerializers[i].serialize(o, target);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error during POJO copy, this should not happen since we check the fieldsbefore.");
            }
        } else if (subclassSerializer != null) {
            subclassSerializer.serialize(value, target);
        }
    }

    public T deserialize(DataInputView source) throws IOException {
        Object target;
        byte flags = source.readByte();
        if ((flags & IS_NULL) != 0) {
            return null;
        }
        Class<?> actualSubclass = null;
        TypeSerializer<?> subclassSerializer = null;
        if ((flags & IS_SUBCLASS) != 0) {
            String subclassName = source.readUTF();
            try {
                actualSubclass = Class.forName(subclassName, true, this.cl);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Cannot instantiate class.", e);
            }
            subclassSerializer = this.getSubclassSerializer(actualSubclass);
            target = subclassSerializer.createInstance();
            this.initializeFields(target);
        } else if ((flags & IS_TAGGED_SUBCLASS) != 0) {
            byte subclassTag = source.readByte();
            subclassSerializer = this.registeredSerializers[subclassTag];
            target = subclassSerializer.createInstance();
            this.initializeFields(target);
        } else {
            target = this.createInstance();
        }
        if ((flags & NO_SUBCLASS) != 0) {
            try {
                for (int i = 0; i < this.numFields; ++i) {
                    boolean isNull = source.readBoolean();
                    if (isNull) {
                        this.fields[i].set(target, null);
                        continue;
                    }
                    Object field = this.fieldSerializers[i].deserialize(source);
                    this.fields[i].set(target, field);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error during POJO copy, this should not happen since we check the fieldsbefore.");
            }
        } else if (subclassSerializer != null) {
            target = subclassSerializer.deserialize(target, source);
        }
        return target;
    }

    public T deserialize(T reuse, DataInputView source) throws IOException {
        byte flags = source.readByte();
        if ((flags & IS_NULL) != 0) {
            return null;
        }
        Class<?> subclass = null;
        TypeSerializer<?> subclassSerializer = null;
        if ((flags & IS_SUBCLASS) != 0) {
            String subclassName = source.readUTF();
            try {
                subclass = Class.forName(subclassName, true, this.cl);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Cannot instantiate class.", e);
            }
            subclassSerializer = this.getSubclassSerializer(subclass);
            if (reuse == null || subclass != reuse.getClass()) {
                reuse = subclassSerializer.createInstance();
                this.initializeFields(reuse);
            }
        } else if ((flags & IS_TAGGED_SUBCLASS) != 0) {
            byte subclassTag = source.readByte();
            subclassSerializer = this.registeredSerializers[subclassTag];
            if (reuse == null || ((PojoSerializer)subclassSerializer).clazz != reuse.getClass()) {
                reuse = subclassSerializer.createInstance();
                this.initializeFields(reuse);
            }
        } else if (reuse == null || this.clazz != reuse.getClass()) {
            reuse = this.createInstance();
        }
        if ((flags & NO_SUBCLASS) != 0) {
            try {
                for (int i = 0; i < this.numFields; ++i) {
                    boolean isNull = source.readBoolean();
                    if (isNull) {
                        this.fields[i].set(reuse, null);
                        continue;
                    }
                    Object reuseField = this.fields[i].get(reuse);
                    Object field = reuseField != null ? this.fieldSerializers[i].deserialize(reuseField, source) : this.fieldSerializers[i].deserialize(source);
                    this.fields[i].set(reuse, field);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error during POJO copy, this should not happen since we check the fields before.");
            }
        } else if (subclassSerializer != null) {
            reuse = subclassSerializer.deserialize(reuse, source);
        }
        return (T)reuse;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        byte flags = source.readByte();
        target.writeByte((int)flags);
        if ((flags & IS_NULL) != 0) {
            return;
        }
        TypeSerializer<?> subclassSerializer = null;
        if ((flags & IS_SUBCLASS) != 0) {
            String className = source.readUTF();
            target.writeUTF(className);
            try {
                Class<?> subclass = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
                subclassSerializer = this.getSubclassSerializer(subclass);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Cannot instantiate class.", e);
            }
        } else if ((flags & IS_TAGGED_SUBCLASS) != 0) {
            byte subclassTag = source.readByte();
            target.writeByte((int)subclassTag);
            subclassSerializer = this.registeredSerializers[subclassTag];
        }
        if ((flags & NO_SUBCLASS) != 0) {
            for (int i = 0; i < this.numFields; ++i) {
                boolean isNull = source.readBoolean();
                target.writeBoolean(isNull);
                if (isNull) continue;
                this.fieldSerializers[i].copy(source, target);
            }
        } else if (subclassSerializer != null) {
            subclassSerializer.copy(source, target);
        }
    }

    public int hashCode() {
        int hashCode = this.numFields * 47;
        for (TypeSerializer<Object> ser : this.fieldSerializers) {
            hashCode = hashCode << 7 | hashCode >>> -7;
            hashCode += ser.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof PojoSerializer) {
            PojoSerializer otherTS = (PojoSerializer)((Object)obj);
            return otherTS.clazz == this.clazz && Arrays.deepEquals(this.fieldSerializers, otherTS.fieldSerializers);
        }
        return false;
    }
}

