/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import java.util.Arrays;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.SortPartitionOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.Keys;
import org.apache.flink.api.java.operators.SingleInputOperator;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;

public class SortPartitionOperator<T>
extends SingleInputOperator<T, T, SortPartitionOperator<T>> {
    private int[] sortKeyPositions;
    private Order[] sortOrders;
    private final String sortLocationName;

    public SortPartitionOperator(DataSet<T> dataSet, int sortField, Order sortOrder, String sortLocationName) {
        super(dataSet, dataSet.getType());
        this.sortLocationName = sortLocationName;
        int[] flatOrderKeys = this.getFlatFields(sortField);
        this.appendSorting(flatOrderKeys, sortOrder);
    }

    public SortPartitionOperator(DataSet<T> dataSet, String sortField, Order sortOrder, String sortLocationName) {
        super(dataSet, dataSet.getType());
        this.sortLocationName = sortLocationName;
        int[] flatOrderKeys = this.getFlatFields(sortField);
        this.appendSorting(flatOrderKeys, sortOrder);
    }

    @Override
    public SortPartitionOperator<T> sortPartition(int field, Order order) {
        int[] flatOrderKeys = this.getFlatFields(field);
        this.appendSorting(flatOrderKeys, order);
        return this;
    }

    @Override
    public SortPartitionOperator<T> sortPartition(String field, Order order) {
        int[] flatOrderKeys = this.getFlatFields(field);
        this.appendSorting(flatOrderKeys, order);
        return this;
    }

    private int[] getFlatFields(int field) {
        Keys.ExpressionKeys ek;
        if (!(super.getType() instanceof TupleTypeInfoBase)) {
            throw new InvalidProgramException("Field positions can only be specified on Tuple or Case Class types.");
        }
        TypeInformation sortKeyType = ((TupleTypeInfoBase)super.getType()).getTypeAt(field);
        if (!sortKeyType.isSortKeyType()) {
            throw new InvalidProgramException("Selected sort key is not a sortable type " + sortKeyType);
        }
        try {
            ek = new Keys.ExpressionKeys(new int[]{field}, super.getType());
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidProgramException("Invalid specification of field position.", (Throwable)iae);
        }
        return ek.computeLogicalKeyPositions();
    }

    private int[] getFlatFields(String fields) {
        if (super.getType() instanceof CompositeType) {
            Keys.ExpressionKeys ek;
            TypeInformation sortKeyType = ((CompositeType)super.getType()).getTypeAt(fields);
            if (!sortKeyType.isSortKeyType()) {
                throw new InvalidProgramException("Selected sort key is not a sortable type " + sortKeyType);
            }
            try {
                ek = new Keys.ExpressionKeys(new String[]{fields}, super.getType());
            }
            catch (IllegalArgumentException iae) {
                throw new InvalidProgramException("Invalid specification of field expression.", (Throwable)iae);
            }
            return ek.computeLogicalKeyPositions();
        }
        if (!(fields = fields.trim()).equals("*") && !fields.equals("_")) {
            throw new InvalidProgramException("Output sorting of non-composite types can only be defined on the full type. Use a field wildcard for that (\"*\" or \"_\")");
        }
        if (!super.getType().isSortKeyType()) {
            throw new InvalidProgramException("Selected sort key cannot be sorted: " + super.getType());
        }
        return new int[]{0};
    }

    private void appendSorting(int[] flatOrderFields, Order order) {
        if (this.sortKeyPositions == null) {
            this.sortKeyPositions = flatOrderFields;
            this.sortOrders = new Order[flatOrderFields.length];
            Arrays.fill(this.sortOrders, order);
        } else {
            int oldLength = this.sortKeyPositions.length;
            int newLength = oldLength + flatOrderFields.length;
            this.sortKeyPositions = Arrays.copyOf(this.sortKeyPositions, newLength);
            this.sortOrders = Arrays.copyOf(this.sortOrders, newLength);
            for (int i = 0; i < flatOrderFields.length; ++i) {
                this.sortKeyPositions[oldLength + i] = flatOrderFields[i];
                this.sortOrders[oldLength + i] = order;
            }
        }
    }

    protected org.apache.flink.api.common.operators.SingleInputOperator<?, T, ?> translateToDataFlow(Operator<T> input) {
        String name = "Sort at " + this.sortLocationName;
        Ordering partitionOrdering = new Ordering();
        for (int i = 0; i < this.sortKeyPositions.length; ++i) {
            partitionOrdering.appendOrdering(Integer.valueOf(this.sortKeyPositions[i]), null, this.sortOrders[i]);
        }
        UnaryOperatorInformation operatorInfo = new UnaryOperatorInformation(this.getType(), this.getType());
        SortPartitionOperatorBase noop = new SortPartitionOperatorBase(operatorInfo, partitionOrdering, name);
        noop.setInput(input);
        if (this.getParallelism() < 0) {
            noop.setParallelism(input.getParallelism());
        } else {
            noop.setParallelism(this.getParallelism());
        }
        return noop;
    }
}

