/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.functions.SemanticPropUtil;
import org.apache.flink.api.java.operators.SingleInputOperator;
import org.apache.flink.api.java.operators.UdfOperator;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.TypeInfoParser;
import org.apache.flink.configuration.Configuration;

public abstract class SingleInputUdfOperator<IN, OUT, O extends SingleInputUdfOperator<IN, OUT, O>>
extends SingleInputOperator<IN, OUT, O>
implements UdfOperator<O> {
    private Configuration parameters;
    private Map<String, DataSet<?>> broadcastVariables;
    private SingleInputSemanticProperties udfSemantics;
    private boolean analyzedUdfSemantics;

    protected SingleInputUdfOperator(DataSet<IN> input, TypeInformation<OUT> resultType) {
        super(input, resultType);
    }

    protected abstract Function getFunction();

    @Override
    public O withParameters(Configuration parameters) {
        this.parameters = parameters;
        SingleInputUdfOperator returnType = this;
        return (O)returnType;
    }

    @Override
    public O withBroadcastSet(DataSet<?> data, String name) {
        if (data == null) {
            throw new IllegalArgumentException("Broadcast variable data must not be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Broadcast variable name must not be null.");
        }
        if (this.broadcastVariables == null) {
            this.broadcastVariables = new HashMap();
        }
        this.broadcastVariables.put(name, data);
        SingleInputUdfOperator returnType = this;
        return (O)returnType;
    }

    public O withForwardedFields(String ... forwardedFields) {
        if (this.udfSemantics == null) {
            this.setSemanticProperties(this.extractSemanticAnnotations(this.getFunction().getClass()));
        }
        if (this.udfSemantics == null || this.analyzedUdfSemantics) {
            this.setSemanticProperties(new SingleInputSemanticProperties());
            SemanticPropUtil.getSemanticPropsSingleFromString(this.udfSemantics, forwardedFields, null, null, this.getInputType(), this.getResultType());
        } else {
            if (this.udfWithForwardedFieldsAnnotation(this.getFunction().getClass())) {
                throw new SemanticProperties.InvalidSemanticAnnotationException("Forwarded field information has already been added by a function annotation for this operator. Cannot overwrite function annotations.");
            }
            SemanticPropUtil.getSemanticPropsSingleFromString(this.udfSemantics, forwardedFields, null, null, this.getInputType(), this.getResultType());
        }
        SingleInputUdfOperator returnType = this;
        return (O)returnType;
    }

    public O returns(String typeInfoString) {
        if (typeInfoString == null) {
            throw new IllegalArgumentException("Type information string must not be null.");
        }
        return this.returns(TypeInfoParser.parse(typeInfoString));
    }

    public O returns(TypeInformation<OUT> typeInfo) {
        if (typeInfo == null) {
            throw new IllegalArgumentException("Type information must not be null.");
        }
        this.fillInType(typeInfo);
        SingleInputUdfOperator returnType = this;
        return (O)returnType;
    }

    public O returns(Class<OUT> typeClass) {
        if (typeClass == null) {
            throw new IllegalArgumentException("Type class must not be null.");
        }
        try {
            TypeInformation<?> ti = TypeExtractor.createTypeInfo(typeClass);
            return this.returns(ti);
        }
        catch (InvalidTypesException e) {
            throw new InvalidTypesException("The given class is not suited for providing necessary type information.", (Throwable)e);
        }
    }

    @Override
    public Map<String, DataSet<?>> getBroadcastSets() {
        return this.broadcastVariables == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.broadcastVariables);
    }

    @Override
    public Configuration getParameters() {
        return this.parameters;
    }

    public SingleInputSemanticProperties getSemanticProperties() {
        SingleInputSemanticProperties props;
        if ((this.udfSemantics == null || this.analyzedUdfSemantics) && (props = this.extractSemanticAnnotations(this.getFunction().getClass())) != null) {
            this.setSemanticProperties(props);
        }
        if (this.udfSemantics == null) {
            this.setSemanticProperties(new SingleInputSemanticProperties());
        }
        return this.udfSemantics;
    }

    public void setSemanticProperties(SingleInputSemanticProperties properties) {
        this.udfSemantics = properties;
        this.analyzedUdfSemantics = false;
    }

    protected boolean getAnalyzedUdfSemanticsFlag() {
        return this.analyzedUdfSemantics;
    }

    protected void setAnalyzedUdfSemanticsFlag() {
        this.analyzedUdfSemantics = true;
    }

    protected SingleInputSemanticProperties extractSemanticAnnotations(Class<?> udfClass) {
        Set<Annotation> annotations = FunctionAnnotation.readSingleForwardAnnotations(udfClass);
        return SemanticPropUtil.getSemanticPropsSingle(annotations, this.getInputType(), this.getResultType());
    }

    protected boolean udfWithForwardedFieldsAnnotation(Class<?> udfClass) {
        return udfClass.getAnnotation(FunctionAnnotation.ForwardedFields.class) != null || udfClass.getAnnotation(FunctionAnnotation.NonForwardedFields.class) != null;
    }
}

