/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.util.Arrays;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.Keys;

public class SplitDataProperties<T>
implements GenericDataSourceBase.SplitDataProperties<T> {
    private TypeInformation<T> type;
    private int[] splitPartitionKeys;
    private Partitioner<T> splitPartitioner;
    private int[] splitGroupKeys;
    private Ordering splitOrdering;

    public SplitDataProperties(TypeInformation<T> type) {
        this.type = type;
    }

    public SplitDataProperties(DataSource<T> source) {
        this.type = source.getType();
    }

    public SplitDataProperties<T> splitsPartitionedBy(int ... partitionFields) {
        return this.splitsPartitionedBy(null, partitionFields);
    }

    public SplitDataProperties<T> splitsPartitionedBy(String partitionMethodId, int ... partitionFields) {
        if (partitionFields == null) {
            throw new InvalidProgramException("PartitionFields may not be null.");
        }
        if (partitionFields.length == 0) {
            throw new InvalidProgramException("PartitionFields may not be empty.");
        }
        this.splitPartitionKeys = this.getAllFlatKeys(partitionFields);
        this.splitPartitioner = partitionMethodId != null ? new SourcePartitionerMarker(partitionMethodId) : null;
        return this;
    }

    public SplitDataProperties<T> splitsPartitionedBy(String partitionFields) {
        return this.splitsPartitionedBy(null, partitionFields);
    }

    public SplitDataProperties<T> splitsPartitionedBy(String partitionMethodId, String partitionFields) {
        if (partitionFields == null) {
            throw new InvalidProgramException("PartitionFields may not be null.");
        }
        String[] partitionKeysA = partitionFields.split(";");
        if (partitionKeysA.length == 0) {
            throw new InvalidProgramException("PartitionFields may not be empty.");
        }
        this.splitPartitionKeys = this.getAllFlatKeys(partitionKeysA);
        this.splitPartitioner = partitionMethodId != null ? new SourcePartitionerMarker(partitionMethodId) : null;
        return this;
    }

    public SplitDataProperties<T> splitsGroupedBy(int ... groupFields) {
        if (groupFields == null) {
            throw new InvalidProgramException("GroupFields may not be null.");
        }
        if (groupFields.length == 0) {
            throw new InvalidProgramException("GroupFields may not be empty.");
        }
        if (this.splitOrdering != null) {
            throw new InvalidProgramException("DataSource may either be grouped or sorted.");
        }
        this.splitGroupKeys = this.getAllFlatKeys(groupFields);
        return this;
    }

    public SplitDataProperties<T> splitsGroupedBy(String groupFields) {
        if (groupFields == null) {
            throw new InvalidProgramException("GroupFields may not be null.");
        }
        String[] groupKeysA = groupFields.split(";");
        if (groupKeysA.length == 0) {
            throw new InvalidProgramException("GroupFields may not be empty.");
        }
        if (this.splitOrdering != null) {
            throw new InvalidProgramException("DataSource may either be grouped or sorted.");
        }
        this.splitGroupKeys = this.getAllFlatKeys(groupKeysA);
        return this;
    }

    public SplitDataProperties<T> splitsOrderedBy(int[] orderFields, Order[] orders) {
        if (orderFields == null || orders == null) {
            throw new InvalidProgramException("OrderFields or Orders may not be null.");
        }
        if (orderFields.length == 0) {
            throw new InvalidProgramException("OrderFields may not be empty.");
        }
        if (orders.length == 0) {
            throw new InvalidProgramException("Orders may not be empty");
        }
        if (orderFields.length != orders.length) {
            throw new InvalidProgramException("Number of OrderFields and Orders must match.");
        }
        if (this.splitGroupKeys != null) {
            throw new InvalidProgramException("DataSource may either be grouped or sorted.");
        }
        this.splitOrdering = new Ordering();
        for (int i = 0; i < orderFields.length; ++i) {
            int[] flatKeys;
            int pos = orderFields[i];
            for (int key : flatKeys = this.getAllFlatKeys(new int[]{pos})) {
                for (int okey : this.splitOrdering.getFieldPositions()) {
                    if (key != okey) continue;
                    throw new InvalidProgramException("Duplicate field in the field expression " + pos);
                }
                this.splitOrdering.appendOrdering(Integer.valueOf(key), null, orders[i]);
            }
        }
        return this;
    }

    public SplitDataProperties<T> splitsOrderedBy(String orderFields, Order[] orders) {
        if (orderFields == null || orders == null) {
            throw new InvalidProgramException("OrderFields or Orders may not be null.");
        }
        String[] orderKeysA = orderFields.split(";");
        if (orderKeysA.length == 0) {
            throw new InvalidProgramException("OrderFields may not be empty.");
        }
        if (orders.length == 0) {
            throw new InvalidProgramException("Orders may not be empty");
        }
        if (orderKeysA.length != orders.length) {
            throw new InvalidProgramException("Number of OrderFields and Orders must match.");
        }
        if (this.splitGroupKeys != null) {
            throw new InvalidProgramException("DataSource may either be grouped or sorted.");
        }
        this.splitOrdering = new Ordering();
        for (int i = 0; i < orderKeysA.length; ++i) {
            int[] flatKeys;
            String keyExp = orderKeysA[i];
            for (int key : flatKeys = this.computeFlatKeys(keyExp)) {
                for (int okey : this.splitOrdering.getFieldPositions()) {
                    if (key != okey) continue;
                    throw new InvalidProgramException("Duplicate field in field expression " + keyExp);
                }
                this.splitOrdering.appendOrdering(Integer.valueOf(key), null, orders[i]);
            }
        }
        return this;
    }

    public int[] getSplitPartitionKeys() {
        return this.splitPartitionKeys;
    }

    public Partitioner<T> getSplitPartitioner() {
        return this.splitPartitioner;
    }

    public int[] getSplitGroupKeys() {
        return this.splitGroupKeys;
    }

    public Ordering getSplitOrder() {
        return this.splitOrdering;
    }

    private int[] getAllFlatKeys(String[] fieldExpressions) {
        int[] allKeys = null;
        for (String keyExp : fieldExpressions) {
            int[] flatKeys = this.computeFlatKeys(keyExp);
            if (allKeys == null) {
                allKeys = flatKeys;
                continue;
            }
            for (int key1 : flatKeys) {
                for (int key2 : allKeys) {
                    if (key1 != key2) continue;
                    throw new InvalidProgramException("Duplicate fields in field expression " + keyExp);
                }
            }
            int oldLength = allKeys.length;
            int newLength = oldLength + flatKeys.length;
            allKeys = Arrays.copyOf(allKeys, newLength);
            for (int i = 0; i < flatKeys.length; ++i) {
                allKeys[oldLength + i] = flatKeys[i];
            }
        }
        return allKeys;
    }

    private int[] getAllFlatKeys(int[] fieldPositions) {
        Keys.ExpressionKeys<T> ek;
        try {
            ek = new Keys.ExpressionKeys<T>(fieldPositions, this.type);
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidProgramException("Invalid specification of field expression.", (Throwable)iae);
        }
        return ek.computeLogicalKeyPositions();
    }

    private int[] computeFlatKeys(String fieldExpression) {
        fieldExpression = fieldExpression.trim();
        if (this.type instanceof CompositeType) {
            Keys.ExpressionKeys<T> ek;
            try {
                ek = new Keys.ExpressionKeys<T>(new String[]{fieldExpression}, this.type);
            }
            catch (IllegalArgumentException iae) {
                throw new InvalidProgramException("Invalid specification of field expression.", (Throwable)iae);
            }
            return ek.computeLogicalKeyPositions();
        }
        if (!(fieldExpression = fieldExpression.trim()).equals("*") && !fieldExpression.equals("_")) {
            throw new InvalidProgramException("Data properties on non-composite types can only be defined on the full type. Use a field wildcard for that (\"*\" or \"_\")");
        }
        return new int[]{0};
    }

    public static class SourcePartitionerMarker<T>
    implements Partitioner<T> {
        String partitionMarker;

        public SourcePartitionerMarker(String partitionMarker) {
            this.partitionMarker = partitionMarker;
        }

        public int partition(T key, int numPartitions) {
            throw new UnsupportedOperationException("The SourcePartitionerMarker is only used as a marker for compatible partitioning. It must not be invoked.");
        }

        public boolean equals(Object o) {
            if (o instanceof SourcePartitionerMarker) {
                return this.partitionMarker.equals(((SourcePartitionerMarker)o).partitionMarker);
            }
            return false;
        }
    }
}

