/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.MapOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;

public class MapOperator<IN, OUT>
extends SingleInputUdfOperator<IN, OUT, MapOperator<IN, OUT>> {
    protected final MapFunction<IN, OUT> function;
    protected final String defaultName;

    public MapOperator(DataSet<IN> input, TypeInformation<OUT> resultType, MapFunction<IN, OUT> function, String defaultName) {
        super(input, resultType);
        this.defaultName = defaultName;
        this.function = function;
        this.extractSemanticAnnotationsFromUdf(function.getClass());
    }

    @Override
    protected MapOperatorBase<IN, OUT, MapFunction<IN, OUT>> translateToDataFlow(Operator<IN> input) {
        String name = this.getName() != null ? this.getName() : "Map at " + this.defaultName;
        MapOperatorBase po = new MapOperatorBase(this.function, new UnaryOperatorInformation(this.getInputType(), this.getResultType()), name);
        po.setInput(input);
        if (this.getParallelism() > 0) {
            po.setDegreeOfParallelism(this.getParallelism());
        } else {
            po.setDegreeOfParallelism(input.getDegreeOfParallelism());
        }
        return po;
    }
}

