/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.flink.core.fs.AbstractRecoverableWriterTest;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.mock.Whitebox;
import org.apache.flink.runtime.fs.hdfs.HadoopFileSystem;
import org.apache.flink.runtime.fs.hdfs.HadoopRecoverableWriter;
import org.apache.flink.runtime.util.HadoopUtils;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.util.OperatingSystem;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;

class HadoopRecoverableWriterTest
extends AbstractRecoverableWriterTest {
    @TempDir
    private static java.nio.file.Path tempFolder;
    private static MiniDFSCluster hdfsCluster;
    private static FileSystem fileSystem;
    private static Path basePath;

    HadoopRecoverableWriterTest() {
    }

    @BeforeAll
    static void testHadoopVersion() {
        Assumptions.assumeThat((boolean)HadoopUtils.isMinHadoopVersion((int)2, (int)6)).isTrue();
    }

    @BeforeAll
    static void verifyOS() {
        Assumptions.assumeThat((boolean)OperatingSystem.isWindows()).isFalse();
    }

    @BeforeAll
    static void createHDFS() throws Exception {
        File baseDir = TempDirUtils.newFolder((java.nio.file.Path)tempFolder);
        Configuration hdConf = new Configuration();
        hdConf.set("hdfs.minidfs.basedir", baseDir.getAbsolutePath());
        hdConf.set("dfs.replication", "2");
        hdConf.set("dfs.blocksize", String.valueOf(512));
        hdConf.set("dfs.namenode.fs-limits.min-block-size", String.valueOf(512));
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(hdConf).numDataNodes(3);
        hdfsCluster = builder.build();
        DistributedFileSystem hdfs = hdfsCluster.getFileSystem();
        fileSystem = new HadoopFileSystem((org.apache.hadoop.fs.FileSystem)hdfs);
        basePath = new Path(hdfs.getUri() + "/tests");
    }

    @AfterAll
    static void destroyHDFS() throws Exception {
        if (hdfsCluster != null) {
            hdfsCluster.getFileSystem().delete(new org.apache.hadoop.fs.Path(basePath.toUri()), true);
            hdfsCluster.shutdown();
        }
    }

    private RecoverableWriter getNoLocalWriteFileSystemWriter() throws Exception {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("fs.hdfs.no-local-write", "true");
        return fileSystem.createRecoverableWriter(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testNoLocalWriteFlag() throws Exception {
        HadoopRecoverableWriterTest.createHDFS();
        HadoopRecoverableWriter writer = (HadoopRecoverableWriter)this.getNoLocalWriteFileSystemWriter();
        BlockManager bm = hdfsCluster.getNameNode().getNamesystem().getBlockManager();
        DatanodeManager dm = bm.getDatanodeManager();
        try (RecoverableFsDataOutputStream os = writer.open(new Path("/tests/test-no-local"));){
            DatanodeManager spyDm = (DatanodeManager)Mockito.spy((Object)dm);
            DatanodeDescriptor dn1 = (DatanodeDescriptor)dm.getDatanodeListForReport(HdfsConstants.DatanodeReportType.LIVE).get(0);
            ((DatanodeManager)Mockito.doReturn((Object)dn1).when((Object)spyDm)).getDatanodeByHost("127.0.0.1");
            Whitebox.setInternalState((Object)bm, (String)"datanodeManager", (Object)spyDm);
            byte[] buf = new byte[8192];
            new Random().nextBytes(buf);
            os.write(buf);
        }
        finally {
            Whitebox.setInternalState((Object)bm, (String)"datanodeManager", (Object)dm);
        }
        hdfsCluster.triggerBlockReports();
        String bpid = hdfsCluster.getNamesystem().getBlockPoolId();
        Assertions.assertEquals((int)3, (int)hdfsCluster.getAllBlockReports(bpid).size());
        int numDataNodesWithData = 0;
        block8: for (Map dnBlocks : hdfsCluster.getAllBlockReports(bpid)) {
            for (BlockListAsLongs blocks : dnBlocks.values()) {
                if (blocks.getNumberOfBlocks() <= 0) continue;
                ++numDataNodesWithData;
                continue block8;
            }
        }
        Assertions.assertEquals((int)1, (int)(3 - numDataNodesWithData));
    }

    public Path getBasePath() {
        return basePath;
    }

    public FileSystem initializeFileSystem() {
        return fileSystem;
    }
}

