/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.core.memory.ByteArrayInputStreamWithPos;
import org.apache.flink.runtime.fs.hdfs.HadoopDataInputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class HadoopDataInputStreamTest {
    private FSDataInputStream verifyInputStream;
    private HadoopDataInputStream testInputStream;

    HadoopDataInputStreamTest() {
    }

    @Test
    void testSeekSkip() throws IOException {
        this.verifyInputStream = (FSDataInputStream)Mockito.spy((Object)new FSDataInputStream((InputStream)((Object)new SeekableByteArrayInputStream(new byte[0x200000]))));
        this.testInputStream = new HadoopDataInputStream(this.verifyInputStream);
        this.seekAndAssert(10L);
        this.seekAndAssert(0x10000BL);
        this.seekAndAssert(this.testInputStream.getPos() - 1L);
        this.seekAndAssert(this.testInputStream.getPos() + 1L);
        this.seekAndAssert(this.testInputStream.getPos() - 0x100000L);
        this.seekAndAssert(this.testInputStream.getPos());
        this.seekAndAssert(0L);
        this.seekAndAssert(this.testInputStream.getPos() + 0x100000L);
        this.seekAndAssert(this.testInputStream.getPos() + 0x100000L - 1L);
        Assertions.assertThatThrownBy(() -> this.seekAndAssert(-1L)).isInstanceOf(Exception.class);
        Assertions.assertThatThrownBy(() -> this.seekAndAssert(-1048577L)).isInstanceOf(Exception.class);
    }

    private void seekAndAssert(long seekPos) throws IOException {
        Assertions.assertThat((long)this.testInputStream.getPos()).isEqualTo(this.verifyInputStream.getPos());
        long delta = seekPos - this.testInputStream.getPos();
        this.testInputStream.seek(seekPos);
        if (delta > 0L && delta <= 0x100000L) {
            ((FSDataInputStream)Mockito.verify((Object)this.verifyInputStream, (VerificationMode)Mockito.atLeastOnce())).skip(Matchers.anyLong());
            ((FSDataInputStream)Mockito.verify((Object)this.verifyInputStream, (VerificationMode)Mockito.never())).seek(Matchers.anyLong());
        } else if (delta != 0L) {
            ((FSDataInputStream)Mockito.verify((Object)this.verifyInputStream, (VerificationMode)Mockito.atLeastOnce())).seek(seekPos);
            ((FSDataInputStream)Mockito.verify((Object)this.verifyInputStream, (VerificationMode)Mockito.never())).skip(Matchers.anyLong());
        } else {
            ((FSDataInputStream)Mockito.verify((Object)this.verifyInputStream, (VerificationMode)Mockito.never())).seek(Matchers.anyLong());
            ((FSDataInputStream)Mockito.verify((Object)this.verifyInputStream, (VerificationMode)Mockito.never())).skip(Matchers.anyLong());
        }
        Assertions.assertThat((long)this.verifyInputStream.getPos()).isEqualTo(seekPos);
        Mockito.reset((Object[])new FSDataInputStream[]{this.verifyInputStream});
    }

    private static final class SeekableByteArrayInputStream
    extends ByteArrayInputStreamWithPos
    implements Seekable,
    PositionedReadable {
        public SeekableByteArrayInputStream(byte[] buffer) {
            super(buffer);
        }

        public void seek(long pos) throws IOException {
            this.setPosition((int)pos);
        }

        public long getPos() throws IOException {
            return this.getPosition();
        }

        public boolean seekToNewSource(long targetPos) throws IOException {
            return false;
        }

        public int read(long position, byte[] buffer, int offset, int length) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void readFully(long position, byte[] buffer) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

