/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Test;

public class HadoopFreeFsFactoryTest
extends TestLogger {
    @Test
    public void testHadoopFactoryInstantiationWithoutHadoop() throws Exception {
        String testClassName = "org.apache.flink.runtime.fs.hdfs.HadoopFreeTests";
        URLClassLoader parent = (URLClassLoader)((Object)((Object)this)).getClass().getClassLoader();
        HadoopFreeClassLoader hadoopFreeClassLoader = new HadoopFreeClassLoader(parent);
        Class<?> testClass = Class.forName("org.apache.flink.runtime.fs.hdfs.HadoopFreeTests", false, hadoopFreeClassLoader);
        Method m = testClass.getDeclaredMethod("test", new Class[0]);
        try {
            m.invoke(null, new Object[0]);
        }
        catch (InvocationTargetException e) {
            ExceptionUtils.rethrowException((Throwable)e.getTargetException(), (String)"exception in method");
        }
    }

    private static final class HadoopFreeClassLoader
    extends URLClassLoader {
        private final ClassLoader properParent;

        HadoopFreeClassLoader(URLClassLoader parent) {
            super(parent.getURLs(), (ClassLoader)null);
            this.properParent = parent;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (name.startsWith("org.apache.hadoop")) {
                throw new ClassNotFoundException(name);
            }
            if (name.startsWith("org.apache.log4j")) {
                return this.properParent.loadClass(name);
            }
            return super.loadClass(name);
        }
    }
}

