/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.util.HadoopUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class HadoopConfigLoadingTest {
    private static final String IN_CP_CONFIG_KEY = "cp_conf_key";
    private static final String IN_CP_CONFIG_VALUE = "oompf!";
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void loadFromClasspathByDefault() {
        org.apache.hadoop.conf.Configuration hadoopConf = HadoopUtils.getHadoopConfiguration((Configuration)new Configuration());
        Assert.assertEquals((Object)IN_CP_CONFIG_VALUE, (Object)hadoopConf.get(IN_CP_CONFIG_KEY, null));
    }

    @Test
    public void loadFromLegacyConfigEntries() throws Exception {
        String k1 = "shipmate";
        String v1 = "smooth sailing";
        String k2 = "pirate";
        String v2 = "Arrg, yer scurvy dog!";
        File file1 = this.tempFolder.newFile("core-site.xml");
        File file2 = this.tempFolder.newFile("hdfs-site.xml");
        HadoopConfigLoadingTest.printConfig(file1, "shipmate", "smooth sailing");
        HadoopConfigLoadingTest.printConfig(file2, "pirate", "Arrg, yer scurvy dog!");
        Configuration cfg = new Configuration();
        cfg.setString("fs.hdfs.hdfsdefault", file1.getAbsolutePath());
        cfg.setString("fs.hdfs.hdfssite", file2.getAbsolutePath());
        org.apache.hadoop.conf.Configuration hadoopConf = HadoopUtils.getHadoopConfiguration((Configuration)cfg);
        Assert.assertEquals((Object)"smooth sailing", (Object)hadoopConf.get("shipmate", null));
        Assert.assertEquals((Object)"Arrg, yer scurvy dog!", (Object)hadoopConf.get("pirate", null));
        Assert.assertEquals((Object)IN_CP_CONFIG_VALUE, (Object)hadoopConf.get(IN_CP_CONFIG_KEY, null));
    }

    @Test
    public void loadFromHadoopConfEntry() throws Exception {
        String k1 = "singing?";
        String v1 = "rain!";
        String k2 = "dancing?";
        String v2 = "shower!";
        File confDir = this.tempFolder.newFolder();
        File file1 = new File(confDir, "core-site.xml");
        File file2 = new File(confDir, "hdfs-site.xml");
        HadoopConfigLoadingTest.printConfig(file1, "singing?", "rain!");
        HadoopConfigLoadingTest.printConfig(file2, "dancing?", "shower!");
        Configuration cfg = new Configuration();
        cfg.setString("fs.hdfs.hadoopconf", confDir.getAbsolutePath());
        org.apache.hadoop.conf.Configuration hadoopConf = HadoopUtils.getHadoopConfiguration((Configuration)cfg);
        Assert.assertEquals((Object)"rain!", (Object)hadoopConf.get("singing?", null));
        Assert.assertEquals((Object)"shower!", (Object)hadoopConf.get("dancing?", null));
        Assert.assertEquals((Object)IN_CP_CONFIG_VALUE, (Object)hadoopConf.get(IN_CP_CONFIG_KEY, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void loadFromEnvVariables() throws Exception {
        org.apache.hadoop.conf.Configuration hadoopConf;
        String k1 = "where?";
        String v1 = "I'm on a boat";
        String k2 = "when?";
        String v2 = "midnight";
        String k3 = "why?";
        String v3 = "what do you think?";
        String k4 = "which way?";
        String v4 = "south, always south...";
        String k5 = "how long?";
        String v5 = "an eternity";
        String k6 = "for real?";
        String v6 = "quite so...";
        File hadoopConfDir = this.tempFolder.newFolder();
        File hadoopHome = this.tempFolder.newFolder();
        File hadoopHomeConf = new File(hadoopHome, "conf");
        File hadoopHomeEtc = new File(hadoopHome, "etc/hadoop");
        Assert.assertTrue((boolean)hadoopHomeConf.mkdirs());
        Assert.assertTrue((boolean)hadoopHomeEtc.mkdirs());
        File file1 = new File(hadoopConfDir, "core-site.xml");
        File file2 = new File(hadoopConfDir, "hdfs-site.xml");
        File file3 = new File(hadoopHomeConf, "core-site.xml");
        File file4 = new File(hadoopHomeConf, "hdfs-site.xml");
        File file5 = new File(hadoopHomeEtc, "core-site.xml");
        File file6 = new File(hadoopHomeEtc, "hdfs-site.xml");
        HadoopConfigLoadingTest.printConfig(file1, "where?", "I'm on a boat");
        HadoopConfigLoadingTest.printConfig(file2, "when?", "midnight");
        HadoopConfigLoadingTest.printConfig(file3, "why?", "what do you think?");
        HadoopConfigLoadingTest.printConfig(file4, "which way?", "south, always south...");
        HadoopConfigLoadingTest.printConfig(file5, "how long?", "an eternity");
        HadoopConfigLoadingTest.printConfig(file6, "for real?", "quite so...");
        Map<String, String> originalEnv = System.getenv();
        HashMap<String, String> newEnv = new HashMap<String, String>(originalEnv);
        newEnv.put("HADOOP_CONF_DIR", hadoopConfDir.getAbsolutePath());
        newEnv.put("HADOOP_HOME", hadoopHome.getAbsolutePath());
        try {
            CommonTestUtils.setEnv(newEnv);
            hadoopConf = HadoopUtils.getHadoopConfiguration((Configuration)new Configuration());
        }
        finally {
            CommonTestUtils.setEnv(originalEnv);
        }
        Assert.assertEquals((Object)"I'm on a boat", (Object)hadoopConf.get("where?", null));
        Assert.assertEquals((Object)"midnight", (Object)hadoopConf.get("when?", null));
        Assert.assertEquals((Object)"what do you think?", (Object)hadoopConf.get("why?", null));
        Assert.assertEquals((Object)"south, always south...", (Object)hadoopConf.get("which way?", null));
        Assert.assertEquals((Object)"an eternity", (Object)hadoopConf.get("how long?", null));
        Assert.assertEquals((Object)"quite so...", (Object)hadoopConf.get("for real?", null));
        Assert.assertEquals((Object)IN_CP_CONFIG_VALUE, (Object)hadoopConf.get(IN_CP_CONFIG_KEY, null));
    }

    private static void printConfig(File file, String key, String value) throws IOException {
        try (PrintStream out = new PrintStream(new FileOutputStream(file));){
            out.println("<?xml version=\"1.0\"?>");
            out.println("<?xml-stylesheet type=\"text/xsl\" href=\"configuration.xsl\"?>");
            out.println("<configuration>");
            out.println("\t<property>");
            out.println("\t\t<name>" + key + "</name>");
            out.println("\t\t<value>" + value + "</value>");
            out.println("\t</property>");
            out.println("</configuration>");
        }
    }
}

