/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import junit.framework.TestCase;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemTestUtils;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.TestLogger;
import org.junit.AfterClass;
import org.junit.Test;

public abstract class AbstractHadoopFileSystemITTest
extends TestLogger {
    protected static FileSystem fs;
    protected static Path basePath;
    protected static long deadline;

    public static void checkPathExistence(Path path, boolean expectedExists, long deadline) throws IOException, InterruptedException {
        if (deadline == 0L) {
            TestCase.assertEquals((boolean)expectedExists, (boolean)fs.exists(path));
        } else {
            FileSystemTestUtils.checkPathEventualExistence((FileSystem)fs, (Path)path, (boolean)expectedExists, (long)deadline);
        }
    }

    protected void checkEmptyDirectory(Path path) throws IOException, InterruptedException {
        AbstractHadoopFileSystemITTest.checkPathExistence(path, true, deadline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleFileWriteAndRead() throws Exception {
        String testLine = "Hello Upload!";
        Path path = new Path(basePath, "test.txt");
        try {
            Throwable throwable;
            try (FSDataOutputStream out = fs.create(path, FileSystem.WriteMode.OVERWRITE);){
                throwable = null;
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);){
                    writer.write("Hello Upload!");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            AbstractHadoopFileSystemITTest.checkPathExistence(path, true, deadline);
            var4_4 = null;
            try (FSDataInputStream in = fs.open(path);){
                throwable = null;
                try (InputStreamReader ir = new InputStreamReader((InputStream)in, StandardCharsets.UTF_8);
                     BufferedReader reader = new BufferedReader(ir);){
                    String line = reader.readLine();
                    TestCase.assertEquals((String)"Hello Upload!", (String)line);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                var4_4 = throwable4;
                throw throwable4;
            }
        }
        finally {
            fs.delete(path, false);
        }
        AbstractHadoopFileSystemITTest.checkPathExistence(path, false, deadline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDirectoryListing() throws Exception {
        Path directory = new Path(basePath, "testdir/");
        TestCase.assertFalse((boolean)fs.exists(directory));
        try {
            TestCase.assertTrue((boolean)fs.mkdirs(directory));
            this.checkEmptyDirectory(directory);
            TestCase.assertEquals((int)0, (int)fs.listStatus(directory).length);
            int numFiles = 3;
            for (int i = 0; i < 3; ++i) {
                Path file = new Path(directory, "/file-" + i);
                try (FSDataOutputStream out = fs.create(file, FileSystem.WriteMode.OVERWRITE);
                     OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);){
                    writer.write("hello-" + i + "\n");
                }
                AbstractHadoopFileSystemITTest.checkPathExistence(file, true, deadline);
            }
            FileStatus[] files = fs.listStatus(directory);
            TestCase.assertNotNull((Object)files);
            TestCase.assertEquals((int)3, (int)files.length);
            for (FileStatus status : files) {
                TestCase.assertFalse((boolean)status.isDir());
            }
            TestCase.assertTrue((boolean)fs.exists(directory));
        }
        finally {
            fs.delete(directory, true);
        }
        AbstractHadoopFileSystemITTest.checkPathExistence(directory, false, deadline);
    }

    @AfterClass
    public static void teardown() throws IOException, InterruptedException {
        try {
            if (fs != null) {
                fs.delete(basePath, true);
                AbstractHadoopFileSystemITTest.checkPathExistence(basePath, false, deadline);
            }
        }
        finally {
            FileSystem.initialize((Configuration)new Configuration());
        }
    }
}

