/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.io.IOException;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemKind;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.fs.hdfs.HadoopFileSystem;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class HdfsKindTest
extends TestLogger {
    @Test
    public void testHdfsKind() throws IOException {
        FileSystem fs = new Path("hdfs://localhost:55445/my/file").getFileSystem();
        Assert.assertEquals((Object)FileSystemKind.FILE_SYSTEM, (Object)fs.getKind());
    }

    @Test
    public void testS3fileSystemSchemes() {
        Assert.assertEquals((Object)FileSystemKind.OBJECT_STORE, (Object)HadoopFileSystem.getKindForScheme((String)"s3"));
        Assert.assertEquals((Object)FileSystemKind.OBJECT_STORE, (Object)HadoopFileSystem.getKindForScheme((String)"s3n"));
        Assert.assertEquals((Object)FileSystemKind.OBJECT_STORE, (Object)HadoopFileSystem.getKindForScheme((String)"s3a"));
        Assert.assertEquals((Object)FileSystemKind.OBJECT_STORE, (Object)HadoopFileSystem.getKindForScheme((String)"EMRFS"));
    }

    @Test
    public void testViewFs() {
        Assert.assertEquals((Object)FileSystemKind.FILE_SYSTEM, (Object)HadoopFileSystem.getKindForScheme((String)"viewfs"));
    }
}

