/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.runtime.fs.hdfs.HadoopFileSystem;
import org.apache.flink.runtime.util.HadoopUtils;
import org.apache.flink.util.OperatingSystem;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.ViewFileSystemTestSetup;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class HadoopViewFileSystemTruncateTest {
    @ClassRule
    public static final TemporaryFolder TEMP_FOLDER = new TemporaryFolder();
    private final FileSystemTestHelper fileSystemTestHelper = new FileSystemTestHelper("/tests");
    private static MiniDFSCluster hdfsCluster;
    private static org.apache.hadoop.fs.FileSystem fHdfs;
    private static FileSystem fSystem;
    private Configuration fsViewConf;
    private org.apache.hadoop.fs.FileSystem fsTarget;
    private org.apache.hadoop.fs.Path targetTestRoot;

    @BeforeClass
    public static void testHadoopVersion() {
        Assume.assumeTrue((boolean)HadoopUtils.isMinHadoopVersion((int)2, (int)7));
    }

    @BeforeClass
    public static void verifyOS() {
        Assume.assumeTrue((String)"HDFS cluster cannot be started on Windows without extensions.", (!OperatingSystem.isWindows() ? 1 : 0) != 0);
    }

    @BeforeClass
    public static void createHDFS() throws Exception {
        File baseDir = TEMP_FOLDER.newFolder();
        Configuration hdConf = new Configuration();
        hdConf.set("hdfs.minidfs.basedir", baseDir.getAbsolutePath());
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(hdConf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology((int)1));
        hdfsCluster = builder.build();
        hdfsCluster.waitClusterUp();
        fHdfs = hdfsCluster.getFileSystem(0);
    }

    @Before
    public void setUp() throws Exception {
        this.fsTarget = fHdfs;
        this.targetTestRoot = this.fileSystemTestHelper.getAbsoluteTestRootPath(this.fsTarget);
        this.fsTarget.delete(this.targetTestRoot, true);
        this.fsTarget.mkdirs(this.targetTestRoot);
        this.fsViewConf = ViewFileSystemTestSetup.createConfig();
        this.setupMountPoints();
        org.apache.hadoop.fs.FileSystem fsView = org.apache.hadoop.fs.FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)this.fsViewConf);
        fSystem = new HadoopFileSystem(fsView);
    }

    private void setupMountPoints() {
        org.apache.hadoop.fs.Path mountOnNn1 = new org.apache.hadoop.fs.Path("/mountOnNn1");
        ConfigUtil.addLink((Configuration)this.fsViewConf, (String)mountOnNn1.toString(), (URI)this.targetTestRoot.toUri());
    }

    @AfterClass
    public static void shutdownCluster() {
        hdfsCluster.shutdown();
    }

    @After
    public void tearDown() throws Exception {
        this.fsTarget.delete(this.fileSystemTestHelper.getTestRootPath(this.fsTarget), true);
    }

    @Test
    public void testViewFileSystemRecoverWorks() throws IOException {
        Path testPath = new Path(fSystem.getUri() + "mountOnNn1/test-1");
        String expectedContent = "test_line";
        RecoverableWriter writer = fSystem.createRecoverableWriter();
        RecoverableFsDataOutputStream streamUnderTest = this.getOpenStreamToFileWithContent(writer, testPath, "test_line");
        RecoverableWriter.ResumeRecoverable resumeRecover = streamUnderTest.persist();
        RecoverableFsDataOutputStream recover = writer.recover(resumeRecover);
        RecoverableWriter.CommitRecoverable committable = recover.closeForCommit().getRecoverable();
        RecoverableWriter recoveredWriter = fSystem.createRecoverableWriter();
        recoveredWriter.recoverForCommit(committable).commitAfterRecovery();
        HadoopViewFileSystemTruncateTest.verifyFileContent(testPath, "test_line");
    }

    private RecoverableFsDataOutputStream getOpenStreamToFileWithContent(RecoverableWriter writerUnderTest, Path path, String expectedContent) throws IOException {
        byte[] content = expectedContent.getBytes(StandardCharsets.UTF_8);
        RecoverableFsDataOutputStream streamUnderTest = writerUnderTest.open(path);
        streamUnderTest.write(content);
        return streamUnderTest;
    }

    private static void verifyFileContent(Path testPath, String expectedContent) throws IOException {
        try (FSDataInputStream in = fSystem.open(testPath);
             InputStreamReader ir = new InputStreamReader((InputStream)in, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(ir);){
            String line = reader.readLine();
            Assert.assertEquals((Object)expectedContent, (Object)line);
        }
    }
}

