/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Random;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.util.StringUtils;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public abstract class AbstractHadoopRecoverableWriterExceptionITCase
extends TestLogger {
    private static final Random RND = new Random();
    protected static Path basePath;
    protected static FileSystem fileSystem;
    protected Path basePathForTest;
    private static final String testData1 = "THIS IS A TEST 1.";
    private static final String testData2 = "THIS IS A TEST 2.";
    private static final String testData3 = "THIS IS A TEST 3.";
    protected static boolean skipped;
    @ClassRule
    public static final TemporaryFolder TEMP_FOLDER;

    @AfterClass
    public static void cleanUp() throws Exception {
        if (!skipped) {
            AbstractHadoopRecoverableWriterExceptionITCase.getFileSystem().delete(basePath, true);
        }
        FileSystem.initialize((Configuration)new Configuration());
    }

    protected abstract String getLocalTmpDir() throws Exception;

    @Before
    public void prepare() throws Exception {
        this.basePathForTest = new Path(basePath, StringUtils.getRandomString((Random)RND, (int)16, (int)16, (char)'a', (char)'z'));
        String defaultTmpDir = this.getLocalTmpDir();
        java.nio.file.Path path = Paths.get(defaultTmpDir, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectory(path, new FileAttribute[0]);
        }
    }

    @After
    public void cleanup() throws Exception {
        AbstractHadoopRecoverableWriterExceptionITCase.getFileSystem().delete(this.basePathForTest, true);
    }

    protected static FileSystem getFileSystem() throws Exception {
        if (fileSystem == null) {
            fileSystem = FileSystem.get((URI)basePath.toUri());
        }
        return fileSystem;
    }

    @Test(expected=IOException.class)
    public void testExceptionWritingAfterCloseForCommit() throws Exception {
        Path path = new Path(this.basePathForTest, "part-0");
        RecoverableFsDataOutputStream stream = AbstractHadoopRecoverableWriterExceptionITCase.getFileSystem().createRecoverableWriter().open(path);
        stream.write(testData1.getBytes(StandardCharsets.UTF_8));
        stream.closeForCommit().getRecoverable();
        stream.write(testData2.getBytes(StandardCharsets.UTF_8));
    }

    @Test(expected=IOException.class)
    public void testResumeAfterCommit() throws Exception {
        RecoverableWriter writer = AbstractHadoopRecoverableWriterExceptionITCase.getFileSystem().createRecoverableWriter();
        Path path = new Path(this.basePathForTest, "part-0");
        RecoverableFsDataOutputStream stream = writer.open(path);
        stream.write(testData1.getBytes(StandardCharsets.UTF_8));
        RecoverableWriter.ResumeRecoverable recoverable = stream.persist();
        stream.write(testData2.getBytes(StandardCharsets.UTF_8));
        stream.closeForCommit().commit();
        RecoverableFsDataOutputStream recoveredStream = writer.recover(recoverable);
        recoveredStream.closeForCommit().commit();
    }

    @Test(expected=IOException.class)
    public void testResumeWithWrongOffset() throws Exception {
        RecoverableWriter writer = AbstractHadoopRecoverableWriterExceptionITCase.getFileSystem().createRecoverableWriter();
        Path path = new Path(this.basePathForTest, "part-0");
        RecoverableFsDataOutputStream stream = writer.open(path);
        stream.write(testData1.getBytes(StandardCharsets.UTF_8));
        RecoverableWriter.ResumeRecoverable recoverable1 = stream.persist();
        stream.write(testData2.getBytes(StandardCharsets.UTF_8));
        RecoverableWriter.ResumeRecoverable recoverable2 = stream.persist();
        stream.write(testData3.getBytes(StandardCharsets.UTF_8));
        RecoverableFsDataOutputStream recoveredStream = writer.recover(recoverable1);
        recoveredStream.closeForCommit().commit();
        RecoverableFsDataOutputStream newRecoveredStream = writer.recover(recoverable2);
        newRecoveredStream.closeForCommit().commit();
    }

    static {
        skipped = true;
        TEMP_FOLDER = new TemporaryFolder();
    }
}

