/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.util.HadoopUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class HadoopConfigLoadingTest {
    private static final String IN_CP_CONFIG_KEY = "cp_conf_key";
    private static final String IN_CP_CONFIG_VALUE = "oompf!";
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void loadFromClasspathByDefault() {
        org.apache.hadoop.conf.Configuration hadoopConf = HadoopUtils.getHadoopConfiguration((Configuration)new Configuration());
        Assert.assertEquals((Object)IN_CP_CONFIG_VALUE, (Object)hadoopConf.get(IN_CP_CONFIG_KEY, null));
    }

    @Test
    public void loadFromLegacyConfigEntries() throws Exception {
        String k1 = "shipmate";
        String v1 = "smooth sailing";
        String k2 = "pirate";
        String v2 = "Arrg, yer scurvy dog!";
        File file1 = this.tempFolder.newFile("core-site.xml");
        File file2 = this.tempFolder.newFile("hdfs-site.xml");
        HadoopConfigLoadingTest.printConfig(file1, "shipmate", "smooth sailing");
        HadoopConfigLoadingTest.printConfig(file2, "pirate", "Arrg, yer scurvy dog!");
        Configuration cfg = new Configuration();
        cfg.setString("fs.hdfs.hdfsdefault", file1.getAbsolutePath());
        cfg.setString("fs.hdfs.hdfssite", file2.getAbsolutePath());
        org.apache.hadoop.conf.Configuration hadoopConf = HadoopUtils.getHadoopConfiguration((Configuration)cfg);
        Assert.assertEquals((Object)"smooth sailing", (Object)hadoopConf.get("shipmate", null));
        Assert.assertEquals((Object)"Arrg, yer scurvy dog!", (Object)hadoopConf.get("pirate", null));
        Assert.assertEquals((Object)IN_CP_CONFIG_VALUE, (Object)hadoopConf.get(IN_CP_CONFIG_KEY, null));
    }

    @Test
    public void loadFromHadoopConfEntry() throws Exception {
        String k1 = "singing?";
        String v1 = "rain!";
        String k2 = "dancing?";
        String v2 = "shower!";
        File confDir = this.tempFolder.newFolder();
        File file1 = new File(confDir, "core-site.xml");
        File file2 = new File(confDir, "hdfs-site.xml");
        HadoopConfigLoadingTest.printConfig(file1, "singing?", "rain!");
        HadoopConfigLoadingTest.printConfig(file2, "dancing?", "shower!");
        Configuration cfg = new Configuration();
        cfg.setString("fs.hdfs.hadoopconf", confDir.getAbsolutePath());
        org.apache.hadoop.conf.Configuration hadoopConf = HadoopUtils.getHadoopConfiguration((Configuration)cfg);
        Assert.assertEquals((Object)"rain!", (Object)hadoopConf.get("singing?", null));
        Assert.assertEquals((Object)"shower!", (Object)hadoopConf.get("dancing?", null));
        Assert.assertEquals((Object)IN_CP_CONFIG_VALUE, (Object)hadoopConf.get(IN_CP_CONFIG_KEY, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void loadFromEnvVariables() throws Exception {
        org.apache.hadoop.conf.Configuration hadoopConf;
        String k1 = "where?";
        String v1 = "I'm on a boat";
        String k2 = "when?";
        String v2 = "midnight";
        String k3 = "why?";
        String v3 = "what do you think?";
        String k4 = "which way?";
        String v4 = "south, always south...";
        String k5 = "how long?";
        String v5 = "an eternity";
        String k6 = "for real?";
        String v6 = "quite so...";
        File hadoopConfDir = this.tempFolder.newFolder();
        File hadoopHome = this.tempFolder.newFolder();
        File hadoopHomeConf = new File(hadoopHome, "conf");
        File hadoopHomeEtc = new File(hadoopHome, "etc/hadoop");
        Assert.assertTrue((boolean)hadoopHomeConf.mkdirs());
        Assert.assertTrue((boolean)hadoopHomeEtc.mkdirs());
        File file1 = new File(hadoopConfDir, "core-site.xml");
        File file2 = new File(hadoopConfDir, "hdfs-site.xml");
        File file3 = new File(hadoopHomeConf, "core-site.xml");
        File file4 = new File(hadoopHomeConf, "hdfs-site.xml");
        File file5 = new File(hadoopHomeEtc, "core-site.xml");
        File file6 = new File(hadoopHomeEtc, "hdfs-site.xml");
        HadoopConfigLoadingTest.printConfig(file1, "where?", "I'm on a boat");
        HadoopConfigLoadingTest.printConfig(file2, "when?", "midnight");
        HadoopConfigLoadingTest.printConfig(file3, "why?", "what do you think?");
        HadoopConfigLoadingTest.printConfig(file4, "which way?", "south, always south...");
        HadoopConfigLoadingTest.printConfig(file5, "how long?", "an eternity");
        HadoopConfigLoadingTest.printConfig(file6, "for real?", "quite so...");
        Map<String, String> originalEnv = System.getenv();
        HashMap<String, String> newEnv = new HashMap<String, String>(originalEnv);
        newEnv.put("HADOOP_CONF_DIR", hadoopConfDir.getAbsolutePath());
        newEnv.put("HADOOP_HOME", hadoopHome.getAbsolutePath());
        try {
            CommonTestUtils.setEnv(newEnv);
            hadoopConf = HadoopUtils.getHadoopConfiguration((Configuration)new Configuration());
        }
        finally {
            CommonTestUtils.setEnv(originalEnv);
        }
        Assert.assertEquals((Object)"I'm on a boat", (Object)hadoopConf.get("where?", null));
        Assert.assertEquals((Object)"midnight", (Object)hadoopConf.get("when?", null));
        Assert.assertEquals((Object)"what do you think?", (Object)hadoopConf.get("why?", null));
        Assert.assertEquals((Object)"south, always south...", (Object)hadoopConf.get("which way?", null));
        Assert.assertEquals((Object)"an eternity", (Object)hadoopConf.get("how long?", null));
        Assert.assertEquals((Object)"quite so...", (Object)hadoopConf.get("for real?", null));
        Assert.assertEquals((Object)IN_CP_CONFIG_VALUE, (Object)hadoopConf.get(IN_CP_CONFIG_KEY, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void loadOverlappingConfig() throws Exception {
        org.apache.hadoop.conf.Configuration hadoopConf;
        String k1 = "key1";
        String k2 = "key2";
        String k3 = "key3";
        String k4 = "key4";
        String k5 = "key5";
        String v1 = "from HADOOP_CONF_DIR";
        String v2 = "from Flink config `fs.hdfs.hadoopconf`";
        String v3 = "from Flink config `fs.hdfs.hdfsdefault`";
        String v4 = "from HADOOP_HOME/etc/hadoop";
        String v5 = "from HADOOP_HOME/conf";
        File hadoopConfDir = this.tempFolder.newFolder("hadoopConfDir");
        File hadoopConfEntryDir = this.tempFolder.newFolder("hadoopConfEntryDir");
        File legacyConfDir = this.tempFolder.newFolder("legacyConfDir");
        File hadoopHome = this.tempFolder.newFolder("hadoopHome");
        File hadoopHomeConf = new File(hadoopHome, "conf");
        File hadoopHomeEtc = new File(hadoopHome, "etc/hadoop");
        Assert.assertTrue((boolean)hadoopHomeConf.mkdirs());
        Assert.assertTrue((boolean)hadoopHomeEtc.mkdirs());
        File file1 = new File(hadoopConfDir, "core-site.xml");
        File file2 = new File(hadoopConfEntryDir, "core-site.xml");
        File file3 = new File(legacyConfDir, "core-site.xml");
        File file4 = new File(hadoopHomeEtc, "core-site.xml");
        File file5 = new File(hadoopHomeConf, "core-site.xml");
        HadoopConfigLoadingTest.printConfig(file1, "key1", "from HADOOP_CONF_DIR");
        HashMap<String, String> properties2 = new HashMap<String, String>();
        properties2.put("key1", "from Flink config `fs.hdfs.hadoopconf`");
        properties2.put("key2", "from Flink config `fs.hdfs.hadoopconf`");
        HadoopConfigLoadingTest.printConfigs(file2, properties2);
        HashMap<String, String> properties3 = new HashMap<String, String>();
        properties3.put("key1", "from Flink config `fs.hdfs.hdfsdefault`");
        properties3.put("key2", "from Flink config `fs.hdfs.hdfsdefault`");
        properties3.put("key3", "from Flink config `fs.hdfs.hdfsdefault`");
        HadoopConfigLoadingTest.printConfigs(file3, properties3);
        HashMap<String, String> properties4 = new HashMap<String, String>();
        properties4.put("key1", "from HADOOP_HOME/etc/hadoop");
        properties4.put("key2", "from HADOOP_HOME/etc/hadoop");
        properties4.put("key3", "from HADOOP_HOME/etc/hadoop");
        properties4.put("key4", "from HADOOP_HOME/etc/hadoop");
        HadoopConfigLoadingTest.printConfigs(file4, properties4);
        HashMap<String, String> properties5 = new HashMap<String, String>();
        properties5.put("key1", "from HADOOP_HOME/conf");
        properties5.put("key2", "from HADOOP_HOME/conf");
        properties5.put("key3", "from HADOOP_HOME/conf");
        properties5.put("key4", "from HADOOP_HOME/conf");
        properties5.put("key5", "from HADOOP_HOME/conf");
        HadoopConfigLoadingTest.printConfigs(file5, properties5);
        Configuration cfg = new Configuration();
        cfg.setString("fs.hdfs.hadoopconf", hadoopConfEntryDir.getAbsolutePath());
        cfg.setString("fs.hdfs.hdfsdefault", file3.getAbsolutePath());
        Map<String, String> originalEnv = System.getenv();
        HashMap<String, String> newEnv = new HashMap<String, String>(originalEnv);
        newEnv.put("HADOOP_CONF_DIR", hadoopConfDir.getAbsolutePath());
        newEnv.put("HADOOP_HOME", hadoopHome.getAbsolutePath());
        try {
            CommonTestUtils.setEnv(newEnv);
            hadoopConf = HadoopUtils.getHadoopConfiguration((Configuration)cfg);
        }
        finally {
            CommonTestUtils.setEnv(originalEnv);
        }
        Assert.assertEquals((Object)"from HADOOP_CONF_DIR", (Object)hadoopConf.get("key1", null));
        Assert.assertEquals((Object)"from Flink config `fs.hdfs.hadoopconf`", (Object)hadoopConf.get("key2", null));
        Assert.assertEquals((Object)"from Flink config `fs.hdfs.hdfsdefault`", (Object)hadoopConf.get("key3", null));
        Assert.assertEquals((Object)"from HADOOP_HOME/etc/hadoop", (Object)hadoopConf.get("key4", null));
        Assert.assertEquals((Object)"from HADOOP_HOME/conf", (Object)hadoopConf.get("key5", null));
        Assert.assertEquals((Object)IN_CP_CONFIG_VALUE, (Object)hadoopConf.get(IN_CP_CONFIG_KEY, null));
    }

    @Test
    public void loadFromFlinkConfEntry() throws Exception {
        String prefix = "flink.hadoop.";
        String k1 = "brooklyn";
        String v1 = "nets";
        String k2 = "miami";
        String v2 = "heat";
        String k3 = "philadelphia";
        String v3 = "76ers";
        String k4 = "golden.state";
        String v4 = "warriors";
        String k5 = "oklahoma.city";
        String v5 = "thunders";
        Configuration cfg = new Configuration();
        cfg.setString("flink.hadoop.brooklyn", "nets");
        cfg.setString("flink.hadoop.miami", "heat");
        cfg.setString("flink.hadoop.philadelphia", "76ers");
        cfg.setString("flink.hadoop.golden.state", "warriors");
        cfg.setString("oklahoma.city", "thunders");
        org.apache.hadoop.conf.Configuration hadoopConf = HadoopUtils.getHadoopConfiguration((Configuration)cfg);
        Assert.assertEquals((Object)"nets", (Object)hadoopConf.get("brooklyn", null));
        Assert.assertEquals((Object)"heat", (Object)hadoopConf.get("miami", null));
        Assert.assertEquals((Object)"76ers", (Object)hadoopConf.get("philadelphia", null));
        Assert.assertEquals((Object)"warriors", (Object)hadoopConf.get("golden.state", null));
        Assert.assertTrue((hadoopConf.get("oklahoma.city") == null ? 1 : 0) != 0);
        Assert.assertEquals((Object)IN_CP_CONFIG_VALUE, (Object)hadoopConf.get(IN_CP_CONFIG_KEY, null));
    }

    private static void printConfig(File file, String key, String value) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put(key, value);
        HadoopConfigLoadingTest.printConfigs(file, map);
    }

    private static void printConfigs(File file, Map<String, String> properties) throws IOException {
        try (PrintStream out = new PrintStream(new FileOutputStream(file));){
            out.println("<?xml version=\"1.0\"?>");
            out.println("<?xml-stylesheet type=\"text/xsl\" href=\"configuration.xsl\"?>");
            out.println("<configuration>");
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                out.println("\t<property>");
                out.println("\t\t<name>" + entry.getKey() + "</name>");
                out.println("\t\t<value>" + entry.getValue() + "</value>");
                out.println("\t</property>");
            }
            out.println("</configuration>");
        }
    }
}

